/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.Resource;
import com.android.tools.r8.dex.DexFile;
import com.android.tools.r8.dex.DexFileReader;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ClassProvider;
import com.android.tools.r8.utils.ClasspathClassCollection;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DexVersion;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LibraryClassCollection;
import com.android.tools.r8.utils.MainDexList;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class ApplicationReader {
    final InternalOptions options;
    final DexItemFactory itemFactory;
    final Timing timing;
    private final AndroidApp inputApp;

    public ApplicationReader(AndroidApp inputApp, InternalOptions options, Timing timing) {
        this.options = options;
        this.itemFactory = options.itemFactory;
        this.timing = timing;
        this.inputApp = inputApp;
    }

    public DexApplication read() throws IOException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.read(executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DexApplication read(ExecutorService executorService) throws IOException, ExecutionException {
        this.timing.begin("DexApplication.read");
        LazyLoadedDexApplication.Builder builder = DexApplication.builder(this.itemFactory, this.timing);
        try {
            ArrayList futures = new ArrayList();
            this.readProguardMap(builder, executorService, futures);
            this.readMainDexList(builder, executorService, futures);
            ClassReader classReader = new ClassReader(executorService, futures);
            classReader.readSources();
            ThreadUtils.awaitFutures(futures);
            classReader.initializeLazyClassCollection(builder);
        }
        finally {
            this.timing.end();
        }
        return builder.build();
    }

    private int verifyOrComputeMinApiLevel(int computedMinApiLevel, DexFile file) {
        DexVersion version = DexVersion.getDexVersion(file.getDexVersion());
        if (this.options.minApiLevel == AndroidApiLevel.getDefault().getLevel()) {
            computedMinApiLevel = Math.max(computedMinApiLevel, AndroidApiLevel.getMinAndroidApiLevel(version).getLevel());
        } else if (!version.matchesApiLevel(AndroidApiLevel.getAndroidApiLevel(this.options.minApiLevel))) {
            throw new CompilationError("Dex file with version '" + version.getIntValue() + "' cannot be used with min sdk level '" + this.options.minApiLevel + "'.");
        }
        return computedMinApiLevel;
    }

    private void readProguardMap(DexApplication.Builder<?> builder, ExecutorService executorService, List<Future<?>> futures) {
        if (this.inputApp.hasProguardMap()) {
            futures.add(executorService.submit(() -> {
                try {
                    InputStream map = this.inputApp.getProguardMap();
                    Throwable throwable = null;
                    try {
                        builder.setProguardMap(ClassNameMapper.mapperFromInputStream(map));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (map != null) {
                            ApplicationReader.$closeResource(throwable, map);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
    }

    private void readMainDexList(DexApplication.Builder<?> builder, ExecutorService executorService, List<Future<?>> futures) {
        if (this.inputApp.hasMainDexList()) {
            futures.add(executorService.submit(() -> {
                for (Resource resource : this.inputApp.getMainDexListResources()) {
                    try {
                        InputStream input = resource.getStream();
                        Throwable throwable = null;
                        try {
                            builder.addToMainDexList(MainDexList.parse(input, this.itemFactory));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (input == null) continue;
                            ApplicationReader.$closeResource(throwable, input);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                builder.addToMainDexList(this.inputApp.getMainDexClasses().stream().map(clazz -> this.itemFactory.createType(DescriptorUtils.javaTypeToDescriptor(clazz))).collect(Collectors.toList()));
            }));
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private final class ClassReader {
        private final ExecutorService executorService;
        private final List<Future<?>> futures;
        private final Queue<DexProgramClass> programClasses = new ConcurrentLinkedQueue<DexProgramClass>();
        private final Queue<DexClasspathClass> classpathClasses = new ConcurrentLinkedQueue<DexClasspathClass>();
        private final Queue<DexLibraryClass> libraryClasses = new ConcurrentLinkedQueue<DexLibraryClass>();
        private final JarApplicationReader application;

        ClassReader(ExecutorService executorService, List<Future<?>> futures) {
            this.application = new JarApplicationReader(ApplicationReader.this.options);
            this.executorService = executorService;
            this.futures = futures;
        }

        private <T extends DexClass> void readDexSources(List<ProgramResource> dexSources, ClassKind classKind, Queue<T> classes) throws IOException {
            if (dexSources.size() > 0) {
                ArrayList<DexFileReader> fileReaders = new ArrayList<DexFileReader>(dexSources.size());
                int computedMinApiLevel = ApplicationReader.this.options.minApiLevel;
                for (ProgramResource input : dexSources) {
                    InputStream is = input.getStream();
                    Throwable throwable = null;
                    try {
                        DexFile file = new DexFile(is);
                        computedMinApiLevel = ApplicationReader.this.verifyOrComputeMinApiLevel(computedMinApiLevel, file);
                        fileReaders.add(new DexFileReader(input.getOrigin(), file, classKind, ApplicationReader.this.itemFactory));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        ClassReader.$closeResource(throwable, is);
                    }
                }
                ApplicationReader.this.options.minApiLevel = computedMinApiLevel;
                for (DexFileReader reader : fileReaders) {
                    DexFileReader.populateIndexTables(reader);
                }
                if (!ApplicationReader.this.options.skipReadingDexCode) {
                    for (DexFileReader reader : fileReaders) {
                        this.futures.add(this.executorService.submit(() -> {
                            reader.addCodeItemsTo();
                            reader.addClassDefsTo(classKind.bridgeConsumer(classes::add));
                        }));
                    }
                }
            }
        }

        private <T extends DexClass> void readClassSources(List<ProgramResource> classSources, ClassKind classKind, Queue<T> classes) {
            JarClassFileReader reader = new JarClassFileReader(this.application, classKind.bridgeConsumer(classes::add));
            for (ProgramResource input : classSources) {
                this.futures.add(this.executorService.submit(() -> {
                    InputStream is = input.getStream();
                    Throwable throwable = null;
                    try {
                        reader.read(input.getOrigin(), classKind, is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is != null) {
                            ClassReader.$closeResource(throwable, is);
                        }
                    }
                    return null;
                }));
            }
        }

        void readSources() throws IOException {
            this.readDexSources(ApplicationReader.this.inputApp.getDexProgramResources(), ClassKind.PROGRAM, this.programClasses);
            this.readClassSources(ApplicationReader.this.inputApp.getClassProgramResources(), ClassKind.PROGRAM, this.programClasses);
        }

        private <T extends DexClass> ClassProvider<T> buildClassProvider(ClassKind classKind, Queue<T> preloadedClasses, List<ClassFileResourceProvider> resourceProviders, JarApplicationReader reader) {
            ArrayList providers = new ArrayList();
            if (!preloadedClasses.isEmpty()) {
                providers.add(ClassProvider.forPreloadedClasses(classKind, preloadedClasses));
            }
            for (ClassFileResourceProvider provider : resourceProviders) {
                providers.add(ClassProvider.forClassFileResources(classKind, provider, reader));
            }
            if (providers.isEmpty()) {
                return null;
            }
            return providers.size() == 1 ? (ClassProvider)providers.get(0) : ClassProvider.combine(classKind, providers);
        }

        void initializeLazyClassCollection(LazyLoadedDexApplication.Builder builder) {
            ClassProvider<DexLibraryClass> libraryClassProvider;
            for (DexProgramClass clazz : this.programClasses) {
                builder.addProgramClass(clazz.asProgramClass());
            }
            ClassProvider<DexClasspathClass> classpathClassProvider = this.buildClassProvider(ClassKind.CLASSPATH, this.classpathClasses, ApplicationReader.this.inputApp.getClasspathResourceProviders(), this.application);
            if (classpathClassProvider != null) {
                builder.setClasspathClassCollection(new ClasspathClassCollection(classpathClassProvider));
            }
            if ((libraryClassProvider = this.buildClassProvider(ClassKind.LIBRARY, this.libraryClasses, ApplicationReader.this.inputApp.getLibraryResourceProviders(), this.application)) != null) {
                builder.setLibraryClassCollection(new LibraryClassCollection(libraryClassProvider));
            }
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }
    }
}

