/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugEventVisitor;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexDebugPositionState;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DexDebugEntryBuilder
implements DexDebugEventVisitor {
    private boolean prologueEnd = false;
    private boolean epilogueBegin = false;
    private final Map<Integer, LocalEntry> locals = new HashMap<Integer, LocalEntry>();
    private final Int2ReferenceMap<DebugLocalInfo> arguments = new Int2ReferenceArrayMap<DebugLocalInfo>();
    private final DexMethod method;
    private DexDebugEntry pending = null;
    private final Map<DebugLocalInfo, DebugLocalInfo> canonicalizedLocals = new HashMap<DebugLocalInfo, DebugLocalInfo>();
    private List<DexDebugEntry> entries = new ArrayList<DexDebugEntry>();
    private DexDebugPositionState positionState;

    public DexDebugEntryBuilder(int startLine, DexMethod method) {
        assert (method != null);
        this.method = method;
        this.positionState = new DexDebugPositionState(startLine, method);
    }

    public DexDebugEntryBuilder(DexEncodedMethod method, DexItemFactory factory) {
        assert (method != null && method.method != null);
        this.method = method.method;
        this.positionState = new DexDebugPositionState(method.getCode().asDexCode().getDebugInfo().startLine, method.method);
        DexCode code = method.getCode().asDexCode();
        DexDebugInfo info = code.getDebugInfo();
        int argumentRegister = code.registerSize - code.incomingRegisterSize;
        if (!method.accessFlags.isStatic()) {
            DexString name = factory.thisName;
            DexType type = method.method.getHolder();
            this.startArgument(argumentRegister, name, type);
            argumentRegister += ValueType.fromDexType(type).requiredRegisters();
        }
        DexType[] types = method.method.proto.parameters.values;
        DexString[] names = info.parameters;
        for (int i = 0; i < types.length; ++i) {
            if (names[i] != null) {
                this.startArgument(argumentRegister, names[i], types[i]);
            }
            argumentRegister += ValueType.fromDexType(types[i]).requiredRegisters();
        }
        for (DexDebugEvent event : info.events) {
            event.accept(this);
        }
    }

    public Int2ReferenceMap<DebugLocalInfo> getArguments() {
        return this.arguments;
    }

    @Override
    public void visit(DexDebugEvent.AdvancePC advancePC) {
        this.positionState.visit(advancePC);
    }

    @Override
    public void visit(DexDebugEvent.AdvanceLine advanceLine) {
        this.positionState.visit(advanceLine);
    }

    @Override
    public void visit(DexDebugEvent.SetInlineFrame setInlineFrame) {
        this.positionState.visit(setInlineFrame);
    }

    @Override
    public void visit(DexDebugEvent.Default defaultEvent) {
        this.positionState.visit(defaultEvent);
        this.defaultEventReceived();
    }

    @Override
    public void visit(DexDebugEvent.SetFile setFile) {
        this.positionState.visit(setFile);
    }

    @Override
    public void visit(DexDebugEvent.SetPrologueEnd setPrologueEnd) {
        this.prologueEnd = true;
    }

    @Override
    public void visit(DexDebugEvent.SetEpilogueBegin setEpilogueBegin) {
        this.epilogueBegin = true;
    }

    public void startArgument(int register, DexString name, DexType type) {
        DebugLocalInfo argument = this.canonicalize(name, type, null);
        this.arguments.put(register, argument);
        this.getEntry(register).set(argument);
    }

    @Override
    public void visit(DexDebugEvent.StartLocal setStartLocal) {
        this.getEntry(setStartLocal.registerNum).set(this.canonicalize(setStartLocal.name, setStartLocal.type, setStartLocal.signature));
    }

    @Override
    public void visit(DexDebugEvent.EndLocal endLocal) {
        this.getEntry(endLocal.registerNum).unset();
    }

    @Override
    public void visit(DexDebugEvent.RestartLocal restartLocal) {
        this.getEntry(restartLocal.registerNum).reset();
    }

    public void defaultEventReceived() {
        if (this.pending != null) {
            this.entries.add(new DexDebugEntry(this.pending.address, this.pending.line, this.pending.sourceFile, this.pending.prologueEnd, this.pending.epilogueBegin, this.getLocals(), this.pending.method, this.pending.callerPosition));
        }
        this.pending = new DexDebugEntry(this.positionState.getCurrentPc(), this.positionState.getCurrentLine(), this.positionState.getCurrentFile(), this.prologueEnd, this.epilogueBegin, null, this.positionState.getCurrentMethod(), this.positionState.getCurrentCallerPosition());
        this.prologueEnd = false;
        this.epilogueBegin = false;
    }

    public List<DexDebugEntry> build() {
        if (this.pending != null) {
            this.defaultEventReceived();
            this.pending = null;
        }
        List<DexDebugEntry> result = this.entries;
        this.entries = null;
        return result;
    }

    private DebugLocalInfo canonicalize(DexString name, DexType type, DexString signature) {
        DebugLocalInfo local = new DebugLocalInfo(name, type, signature);
        DebugLocalInfo canonical = this.canonicalizedLocals.putIfAbsent(local, local);
        return canonical != null ? canonical : local;
    }

    private LocalEntry getEntry(int register) {
        LocalEntry entry = this.locals.get(register);
        if (entry == null) {
            entry = new LocalEntry();
            this.locals.put(register, entry);
        }
        return entry;
    }

    private ImmutableMap<Integer, DebugLocalInfo> getLocals() {
        ImmutableMap.Builder<Integer, DebugLocalInfo> builder = ImmutableMap.builder();
        for (Map.Entry<Integer, LocalEntry> mapEntry : this.locals.entrySet()) {
            Integer register = mapEntry.getKey();
            LocalEntry entry = mapEntry.getValue();
            if (entry.current == null) continue;
            builder.put(register, entry.current);
        }
        return builder.build();
    }

    private static class LocalEntry {
        DebugLocalInfo current;
        DebugLocalInfo last;

        private LocalEntry() {
        }

        void set(DebugLocalInfo value) {
            this.current = value;
            this.last = value;
        }

        void unset() {
            this.current = null;
        }

        void reset() {
            this.current = this.last;
        }
    }
}

