/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.constant;

import com.android.tools.r8.ir.analysis.constant.Bottom;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.code.ConstNumber;

public class ConstLatticeElement
extends LatticeElement {
    private ConstNumber value;

    public ConstLatticeElement(ConstNumber value) {
        this.value = value;
    }

    @Override
    public LatticeElement meet(LatticeElement other) {
        if (other.isTop()) {
            return this;
        }
        if (other.isBottom()) {
            return other;
        }
        if (this.value.identicalNonValueNonPositionParts(other.asConst().value)) {
            return this;
        }
        return Bottom.getInstance();
    }

    public int getBranchCondition() {
        return this.value.getIntValue();
    }

    @Override
    public boolean isConst() {
        return true;
    }

    @Override
    public ConstLatticeElement asConst() {
        return this;
    }

    public String toString() {
        return this.value.toString();
    }

    public ConstNumber getConstNumber() {
        return this.value;
    }

    public int getIntValue() {
        return this.value.getIntValue();
    }

    public long getLongValue() {
        return this.value.getLongValue();
    }

    public float getFloatValue() {
        return this.value.getFloatValue();
    }

    public double getDoubleValue() {
        return this.value.getDoubleValue();
    }
}

