/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.constant;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.analysis.constant.Top;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Value;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SparseConditionalConstantPropagation {
    private IRCode code;
    private Map<Value, LatticeElement> mapping = new HashMap<Value, LatticeElement>();
    private Deque<Value> ssaEdges = new LinkedList<Value>();
    private Deque<BasicBlock> flowEdges = new LinkedList<BasicBlock>();
    private final int nextBlockNumber;
    private final BitSet[] executableFlowEdges;
    private final BitSet visitedBlocks;

    public SparseConditionalConstantPropagation(IRCode code) {
        this.code = code;
        this.nextBlockNumber = code.getHighestBlockNumber() + 1;
        this.executableFlowEdges = new BitSet[this.nextBlockNumber];
        this.visitedBlocks = new BitSet(this.nextBlockNumber);
    }

    public void run() {
        BasicBlock firstBlock = this.code.blocks.get(0);
        this.visitInstructions(firstBlock);
        while (!this.flowEdges.isEmpty() || !this.ssaEdges.isEmpty()) {
            while (!this.flowEdges.isEmpty()) {
                BasicBlock block = this.flowEdges.poll();
                for (Phi phi : block.getPhis()) {
                    this.visitPhi(phi);
                }
                if (this.visitedBlocks.get(block.getNumber())) continue;
                this.visitInstructions(block);
            }
            while (!this.ssaEdges.isEmpty()) {
                Value value = this.ssaEdges.poll();
                for (Phi phi : value.uniquePhiUsers()) {
                    this.visitPhi(phi);
                }
                for (Instruction user : value.uniqueUsers()) {
                    BasicBlock userBlock = user.getBlock();
                    if (!this.visitedBlocks.get(userBlock.getNumber())) continue;
                    this.visitInstruction(user);
                }
            }
        }
        this.rewriteCode();
        assert (this.code.isConsistentSSA());
    }

    private void rewriteCode() {
        this.mapping.entrySet().stream().filter(entry -> ((LatticeElement)entry.getValue()).isConst()).forEach(entry -> {
            Value value = (Value)entry.getKey();
            ConstNumber evaluatedConst = ((LatticeElement)entry.getValue()).asConst().getConstNumber();
            if (value.definition != evaluatedConst) {
                if (value.isPhi()) {
                    if (value.numberOfAllUsers() != 0) {
                        BasicBlock block = value.asPhi().getBlock();
                        ConstNumber newConst = ConstNumber.copyOf(this.code, evaluatedConst);
                        InstructionListIterator iterator = block.listIterator();
                        Object inst = iterator.nextUntil(i -> !i.isMoveException());
                        newConst.setPosition(((Instruction)inst).getPosition());
                        if (!((Instruction)inst).isDebugPosition()) {
                            iterator.previous();
                        }
                        iterator.add(newConst);
                        value.replaceUsers(newConst.outValue());
                    }
                } else {
                    BasicBlock block = value.definition.getBlock();
                    InstructionListIterator iterator = block.listIterator();
                    Object toReplace = iterator.nextUntil(i -> i == value.definition);
                    iterator.replaceCurrentInstruction(evaluatedConst);
                }
            }
        });
        for (BasicBlock block : this.code.blocks) {
            PhiEquivalence equivalence = new PhiEquivalence();
            HashMap<Equivalence.Wrapper<Phi>, Phi> phis = new HashMap<Equivalence.Wrapper<Phi>, Phi>();
            for (Phi phi : block.getPhis()) {
                Equivalence.Wrapper<Phi> key = equivalence.wrap(phi);
                Phi replacement = (Phi)phis.get(key);
                if (replacement != null) {
                    phi.replaceUsers(replacement);
                    continue;
                }
                phis.put(key, phi);
            }
        }
    }

    private LatticeElement getLatticeElement(Value value) {
        return this.mapping.getOrDefault(value, Top.getInstance());
    }

    private void setLatticeElement(Value value, LatticeElement element) {
        this.mapping.put(value, element);
    }

    private void visitPhi(Phi phi) {
        BasicBlock phiBlock = phi.getBlock();
        int phiBlockNumber = phiBlock.getNumber();
        LatticeElement element = Top.getInstance();
        for (int i = 0; i < phiBlock.getPredecessors().size(); ++i) {
            BasicBlock predecessor = phiBlock.getPredecessors().get(i);
            if (!this.isExecutableEdge(predecessor.getNumber(), phiBlockNumber)) continue;
            element = ((LatticeElement)element).meet(this.getLatticeElement(phi.getOperand(i)));
        }
        LatticeElement currentPhiElement = this.getLatticeElement(phi);
        if (!((LatticeElement)element).isTop() && currentPhiElement.meet(element) != currentPhiElement) {
            this.ssaEdges.add(phi);
            this.setLatticeElement(phi, element);
        }
    }

    private void visitInstructions(BasicBlock block) {
        for (Instruction instruction : block.getInstructions()) {
            this.visitInstruction(instruction);
        }
        this.visitedBlocks.set(block.getNumber());
    }

    private void visitInstruction(Instruction instruction) {
        if (instruction.outValue() != null && !instruction.isDebugLocalUninitialized()) {
            LatticeElement element = instruction.evaluate(this.code, this.mapping);
            LatticeElement currentLattice = this.getLatticeElement(instruction.outValue());
            if (currentLattice.meet(element) != currentLattice) {
                this.setLatticeElement(instruction.outValue(), element);
                this.ssaEdges.add(instruction.outValue());
            }
        }
        if (instruction.isJumpInstruction()) {
            this.addFlowEdgesForJumpInstruction(instruction.asJumpInstruction());
        }
    }

    private void addFlowEdgesForJumpInstruction(JumpInstruction jumpInstruction) {
        Switch switchInst;
        LatticeElement switchElement;
        BasicBlock jumpInstBlock = jumpInstruction.getBlock();
        int jumpInstBlockNumber = jumpInstBlock.getNumber();
        if (jumpInstruction.isIf()) {
            If theIf = jumpInstruction.asIf();
            if (theIf.isZeroTest()) {
                LatticeElement element = this.getLatticeElement(theIf.inValues().get(0));
                if (element.isConst()) {
                    BasicBlock target = theIf.targetFromCondition(element.asConst().getBranchCondition());
                    if (!this.isExecutableEdge(jumpInstBlockNumber, target.getNumber())) {
                        this.setExecutableEdge(jumpInstBlockNumber, target.getNumber());
                        this.flowEdges.add(target);
                    }
                    return;
                }
            } else {
                LatticeElement leftElement = this.getLatticeElement(theIf.inValues().get(0));
                LatticeElement rightElement = this.getLatticeElement(theIf.inValues().get(1));
                if (leftElement.isConst() && rightElement.isConst()) {
                    long rightValue;
                    long leftValue = leftElement.asConst().getConstNumber().getIntValue();
                    BasicBlock target = theIf.targetFromCondition(leftValue - (rightValue = (long)rightElement.asConst().getConstNumber().getIntValue()));
                    if (!this.isExecutableEdge(jumpInstBlockNumber, target.getNumber())) {
                        this.setExecutableEdge(jumpInstBlockNumber, target.getNumber());
                        this.flowEdges.add(target);
                    }
                    return;
                }
                assert (!leftElement.isTop());
                assert (!rightElement.isTop());
            }
        } else if (jumpInstruction.isSwitch() && (switchElement = this.getLatticeElement((switchInst = jumpInstruction.asSwitch()).value())).isConst()) {
            BasicBlock target = (BasicBlock)switchInst.getKeyToTargetMap().get(switchElement.asConst().getIntValue());
            if (target == null) {
                target = switchInst.fallthroughBlock();
            }
            assert (target != null);
            this.setExecutableEdge(jumpInstBlockNumber, target.getNumber());
            this.flowEdges.add(target);
            return;
        }
        for (BasicBlock dst : jumpInstBlock.getSuccessors()) {
            if (this.isExecutableEdge(jumpInstBlockNumber, dst.getNumber())) continue;
            this.setExecutableEdge(jumpInstBlockNumber, dst.getNumber());
            this.flowEdges.add(dst);
        }
    }

    private void setExecutableEdge(int from, int to) {
        BitSet previousExecutable = this.executableFlowEdges[to];
        if (previousExecutable == null) {
            this.executableFlowEdges[to] = previousExecutable = new BitSet(this.nextBlockNumber);
        }
        previousExecutable.set(from);
    }

    private boolean isExecutableEdge(int from, int to) {
        BitSet previousExecutable = this.executableFlowEdges[to];
        if (previousExecutable == null) {
            return false;
        }
        return previousExecutable.get(from);
    }

    private static class PhiEquivalence
    extends Equivalence<Phi> {
        private PhiEquivalence() {
        }

        @Override
        protected boolean doEquivalent(Phi a, Phi b) {
            assert (a.getBlock() == b.getBlock());
            for (int i = 0; i < a.getOperands().size(); ++i) {
                if (a.getOperand(i) == b.getOperand(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int doHash(Phi phi) {
            int hash = 0;
            for (Value value : phi.getOperands()) {
                hash = hash * 13 + value.hashCode();
            }
            return hash;
        }
    }
}

