/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.origin.Origin;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public interface ClassFileResourceProvider {
    public Set<String> getClassDescriptors();

    default public ProgramResource getProgramResource(String descriptor) {
        Resource resource = this.getResource(descriptor);
        return resource == null ? null : new ClassFileResource(resource);
    }

    @Deprecated
    public Resource getResource(String var1);

    @Deprecated
    public static class ClassFileResource
    implements ProgramResource {
        private final Resource resource;

        public ClassFileResource(Resource resource) {
            this.resource = resource;
            assert (resource.getClassDescriptors() == null || resource.getClassDescriptors().size() == 1);
        }

        @Override
        public ProgramResource.Kind getKind() {
            return ProgramResource.Kind.CF;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return this.resource.getStream();
            }
            catch (IOException e) {
                throw new ResourceException(this.resource.getOrigin(), (Throwable)e);
            }
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.resource.getClassDescriptors();
        }

        @Override
        public Origin getOrigin() {
            return this.resource.getOrigin();
        }

        @Override
        public InputStream getStream() throws IOException {
            return this.resource.getStream();
        }
    }
}

