/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.origin.StandardOutOrigin;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class R8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: r8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --release                # Compile without debugging information (default).", "  --debug                  # Compile with debugging information.", "  --dex                    # Compile program to DEX file format (default).", "  --classfile              # Compile program to Java classfile format.", "  --output <file>          # Output result in <file>.", "                           # <file> must be an existing directory or a zip file.", "  --lib <file>             # Add <file> as a library resource.", "  --min-api                # Minimum Android API level compatibility.", "  --pg-conf <file>         # Proguard configuration <file> (implies tree", new String[]{"                           # shaking/minification).", "  --pg-map-output <file>   # Output the resulting name and line mapping to <file>.", "  --no-tree-shaking        # Force disable tree shaking of unreachable classes.", "  --no-discarded-checker   # Force disable the discarded checker (when tree shaking).", "  --no-minification        # Force disable minification of names.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version of r8.", "  --help                   # Print this message."}));
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final StringConsumer mainDexListConsumer;
    private final ProguardConfiguration proguardConfiguration;
    private final boolean useTreeShaking;
    private final boolean useDiscardedChecker;
    private final boolean useMinification;
    private final boolean forceProguardCompatibility;
    private final StringConsumer proguardMapConsumer;
    private final Path proguardCompatibilityRulesOutput;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    static Builder builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
        return new Builder(app, diagnosticsHandler);
    }

    public static Builder parse(String[] args, Origin origin) {
        Builder builder = R8Command.builder();
        ParseState state = new ParseState();
        R8Command.parse(args, origin, builder, state);
        if (state.mode != null) {
            builder.setMode(state.mode);
        }
        Path outputPath = state.outputPath != null ? state.outputPath : Paths.get(".", new String[0]);
        OutputMode outputMode = state.outputMode != null ? state.outputMode : OutputMode.DexIndexed;
        builder.setOutput(outputPath, outputMode);
        return builder;
    }

    private static ParseState parse(String[] args, Origin argsOrigin, Builder builder, ParseState state) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (state.mode == CompilationMode.RELEASE) {
                    builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", argsOrigin));
                }
                state.mode = CompilationMode.DEBUG;
                continue;
            }
            if (arg.equals("--release")) {
                if (state.mode == CompilationMode.DEBUG) {
                    builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", argsOrigin));
                }
                state.mode = CompilationMode.RELEASE;
                continue;
            }
            if (arg.equals("--dex")) {
                if (state.outputMode == OutputMode.ClassFile) {
                    builder.getReporter().error(new StringDiagnostic("Cannot compile in both --dex and --classfile output mode.", argsOrigin));
                }
                state.outputMode = OutputMode.DexIndexed;
                continue;
            }
            if (arg.equals("--classfile")) {
                if (state.outputMode == OutputMode.DexIndexed) {
                    builder.getReporter().error(new StringDiagnostic("Cannot compile in both --dex and --classfile output mode.", argsOrigin));
                }
                state.outputMode = OutputMode.ClassFile;
                continue;
            }
            if (arg.equals("--output")) {
                String outputPath = args[++i];
                if (state.outputPath != null) {
                    builder.getReporter().error(new StringDiagnostic("Cannot output both to '" + state.outputPath.toString() + "' and '" + outputPath + "'", argsOrigin));
                }
                state.outputPath = Paths.get(outputPath, new String[0]);
                continue;
            }
            if (arg.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--min-api")) {
                builder.setMinApiLevel(Integer.valueOf(args[++i]));
                continue;
            }
            if (arg.equals("--no-tree-shaking")) {
                builder.setTreeShaking(false);
                continue;
            }
            if (arg.equals("--no-discarded-checker")) {
                builder.setDiscardedChecker(false);
                continue;
            }
            if (arg.equals("--no-minification")) {
                builder.setMinification(false);
                continue;
            }
            if (arg.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--pg-map-output")) {
                builder.setProguardMapOutput(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.startsWith("@")) {
                Path argsFile = Paths.get(arg.substring(1), new String[0]);
                PathOrigin argsFileOrigin = new PathOrigin(argsFile);
                try {
                    List<String> linesInFile = FileUtils.readAllLines(argsFile);
                    ArrayList<String> argsInFile = new ArrayList<String>();
                    for (String line : linesInFile) {
                        for (String word : line.split("\\s")) {
                            String trimmed = word.trim();
                            if (trimmed.isEmpty()) continue;
                            argsInFile.add(trimmed);
                        }
                    }
                    state = R8Command.parse(argsInFile.toArray(new String[argsInFile.size()]), argsFileOrigin, builder, state);
                }
                catch (IOException e) {
                    builder.getReporter().error(new StringDiagnostic("Failed to read arguments from file " + argsFile + ": " + e.getMessage(), argsFileOrigin));
                }
                continue;
            }
            if (arg.startsWith("--")) {
                builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, argsOrigin));
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        return state;
    }

    private R8Command(AndroidApp inputApp, ProgramConsumer programConsumer, BaseCompilerCommand.OutputOptions outputOptions, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, StringConsumer mainDexListConsumer, ProguardConfiguration proguardConfiguration, CompilationMode mode, int minApiLevel, Reporter reporter, boolean enableDesugaring, boolean useTreeShaking, boolean useDiscardedChecker, boolean useMinification, boolean forceProguardCompatibility, StringConsumer proguardMapConsumer, Path proguardCompatibilityRulesOutput) {
        super(inputApp, mode, programConsumer, outputOptions, minApiLevel, reporter, enableDesugaring);
        assert (proguardConfiguration != null);
        assert (mainDexKeepRules != null);
        this.mainDexKeepRules = mainDexKeepRules;
        this.mainDexListConsumer = mainDexListConsumer;
        this.proguardConfiguration = proguardConfiguration;
        this.useTreeShaking = useTreeShaking;
        this.useDiscardedChecker = useDiscardedChecker;
        this.useMinification = useMinification;
        this.forceProguardCompatibility = forceProguardCompatibility;
        this.proguardMapConsumer = proguardMapConsumer;
        this.proguardCompatibilityRulesOutput = proguardCompatibilityRulesOutput;
    }

    private R8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.mainDexKeepRules = ImmutableList.of();
        this.mainDexListConsumer = null;
        this.proguardConfiguration = null;
        this.useTreeShaking = false;
        this.useDiscardedChecker = false;
        this.useMinification = false;
        this.forceProguardCompatibility = false;
        this.proguardMapConsumer = null;
        this.proguardCompatibilityRulesOutput = null;
    }

    public boolean useTreeShaking() {
        return this.useTreeShaking;
    }

    public boolean useDiscardedChecker() {
        return this.useDiscardedChecker;
    }

    public boolean useMinification() {
        return this.useMinification;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.proguardConfiguration, this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.programConsumer = this.getProgramConsumer();
        internal.minApiLevel = this.getMinApiLevel();
        if (!this.proguardConfiguration.isOptimizing()) {
            internal.skipClassMerging = true;
            internal.inlineAccessors = false;
            internal.removeSwitchMaps = false;
            internal.outline.enabled = false;
            internal.propagateMemberValue = false;
        }
        assert (!internal.skipMinification);
        boolean bl = internal.skipMinification = !this.useMinification() || !this.proguardConfiguration.isObfuscating();
        assert (internal.useTreeShaking);
        internal.useTreeShaking = this.useTreeShaking();
        assert (internal.useDiscardedChecker);
        internal.useDiscardedChecker = this.useDiscardedChecker();
        assert (!internal.ignoreMissingClasses);
        boolean bl2 = internal.ignoreMissingClasses = this.proguardConfiguration.isIgnoreWarnings() || this.forceProguardCompatibility && !this.proguardConfiguration.isOptimizing() && internal.skipMinification && !internal.useTreeShaking;
        assert (!internal.verbose);
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.minimalMainDex = internal.debug;
        internal.mainDexListConsumer = this.mainDexListConsumer;
        InternalOptions.LineNumberOptimization lineNumberOptimization = internal.lineNumberOptimization = internal.debug || this.forceProguardCompatibility && !this.proguardConfiguration.isOptimizing() ? InternalOptions.LineNumberOptimization.OFF : InternalOptions.LineNumberOptimization.ON;
        if (internal.debug) {
            internal.removeSwitchMaps = false;
            internal.inlineAccessors = false;
            internal.outline.enabled = false;
        }
        if (this.proguardConfiguration.isPrintUsage()) {
            StringConsumer stringConsumer = internal.usageInformationConsumer = this.proguardConfiguration.getPrintUsageFile() != null ? new StringConsumer.FileConsumer(this.proguardConfiguration.getPrintUsageFile()) : new StringConsumer.StreamConsumer(StandardOutOrigin.instance(), System.out);
        }
        if (this.proguardConfiguration.isPrintSeeds()) {
            StringConsumer stringConsumer = internal.proguardSeedsConsumer = this.proguardConfiguration.getSeedFile() != null ? new StringConsumer.FileConsumer(this.proguardConfiguration.getSeedFile()) : new StringConsumer.StreamConsumer(StandardOutOrigin.instance(), System.out);
        }
        StringConsumer wrappedConsumer = this.proguardConfiguration.isPrintMapping() ? (this.proguardConfiguration.getPrintMappingFile() != null ? new StringConsumer.FileConsumer(this.proguardConfiguration.getPrintMappingFile(), this.proguardMapConsumer) : new StringConsumer.StreamConsumer(StandardOutOrigin.instance(), System.out, this.proguardMapConsumer)) : this.proguardMapConsumer;
        internal.proguardMapConsumer = wrappedConsumer;
        internal.proguardCompatibilityRulesOutput = this.proguardCompatibilityRulesOutput;
        assert (!internal.forceProguardCompatibility);
        internal.forceProguardCompatibility = this.forceProguardCompatibility;
        return internal;
    }

    private static class ParseState {
        CompilationMode mode = null;
        OutputMode outputMode = null;
        Path outputPath = null;

        private ParseState() {
        }
    }

    public static class Builder
    extends BaseCompilerCommand.Builder<R8Command, Builder> {
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Consumer<ProguardConfiguration.Builder> proguardConfigurationConsumer = null;
        private final List<ProguardConfigurationSource> proguardConfigs = new ArrayList<ProguardConfigurationSource>();
        private Optional<Boolean> treeShaking = Optional.empty();
        private Optional<Boolean> discardedChecker = Optional.empty();
        private Optional<Boolean> minification = Optional.empty();
        private boolean forceProguardCompatibility = false;
        private StringConsumer proguardMapConsumer = null;
        protected Path proguardCompatibilityRulesOutput = null;
        private StringConsumer mainDexListConsumer = null;

        private Builder() {
            this.setMode(CompilationMode.RELEASE);
        }

        protected Builder(boolean forceProguardCompatibility) {
            this.setMode(CompilationMode.RELEASE);
            this.forceProguardCompatibility = forceProguardCompatibility;
        }

        protected Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            this.setMode(CompilationMode.DEBUG);
        }

        private Builder(AndroidApp app) {
            super(app);
            this.setMode(CompilationMode.RELEASE);
        }

        private Builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
            super(app, diagnosticsHandler);
            this.setMode(CompilationMode.RELEASE);
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setTreeShaking(boolean useTreeShaking) {
            this.treeShaking = Optional.of(useTreeShaking);
            return this.self();
        }

        public Builder setDiscardedChecker(boolean useDiscardedChecker) {
            this.discardedChecker = Optional.of(useDiscardedChecker);
            return this.self();
        }

        public Builder setMinification(boolean useMinification) {
            this.minification = Optional.of(useMinification);
            return this.self();
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRulesFiles(List<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines, Origin origin) {
            this.guard(() -> this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListConsumer = new StringConsumer.FileConsumer(mainDexListOutputPath);
            return this.self();
        }

        public Builder setMainDexListConsumer(StringConsumer mainDexListConsumer) {
            this.mainDexListConsumer = mainDexListConsumer;
            return this.self();
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines, Origin origin) {
            this.guard(() -> this.proguardConfigs.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder addProguardConfigurationConsumer(Consumer<ProguardConfiguration.Builder> c) {
            Consumer<ProguardConfiguration.Builder> oldConsumer = this.proguardConfigurationConsumer;
            this.proguardConfigurationConsumer = builder -> {
                if (oldConsumer != null) {
                    oldConsumer.accept((ProguardConfiguration.Builder)builder);
                }
                c.accept((ProguardConfiguration.Builder)builder);
            };
            return this.self();
        }

        public Builder setProguardMapOutput(Path proguardMapOutput) {
            assert (proguardMapOutput != null);
            this.proguardMapConsumer = new StringConsumer.FileConsumer(proguardMapOutput);
            return this.self();
        }

        public Builder setProguardMapConsumer(StringConsumer proguardMapConsumer) {
            this.proguardMapConsumer = proguardMapConsumer;
            return this.self();
        }

        @Override
        public Builder setOutputMode(OutputMode outputMode) {
            throw new CompilationError("Invalid API use for R8");
        }

        @Override
        public Builder setOutputPath(Path outputPath) {
            throw new CompilationError("Invalid API use for R8");
        }

        @Override
        protected void validate() {
            if (this.getProgramConsumer() == null) {
                this.reporter.error("A ProgramConsumer or Output is required for compilation");
            }
            if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                this.reporter.error("R8 does not support compiling to a single DEX file per Java class file");
            }
            if (this.mainDexListConsumer != null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList()) {
                this.reporter.error("Option --main-dex-list-output require --main-dex-rules and/or --main-dex-list");
            }
            super.validate();
        }

        @Override
        protected R8Command makeCommand() {
            try {
                if (this.isPrintHelp() || this.isPrintVersion()) {
                    return new R8Command(this.isPrintHelp(), this.isPrintVersion());
                }
                return this.makeR8Command();
            }
            catch (IOException e) {
                throw this.reporter.fatalError(new IOExceptionDiagnostic(e), e);
            }
            catch (CompilationException e) {
                throw this.reporter.fatalError(new StringDiagnostic(e.getMessage()), e);
            }
        }

        private R8Command makeR8Command() throws IOException, CompilationException {
            ProguardConfiguration.Builder configurationBuilder;
            ImmutableList<Object> mainDexKeepRules;
            DexItemFactory factory = new DexItemFactory();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, this.reporter);
                parser.parse(this.mainDexRules);
                mainDexKeepRules = parser.getConfig().getRules();
            }
            if (this.proguardConfigs.isEmpty()) {
                configurationBuilder = ProguardConfiguration.builder(factory, this.reporter);
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, this.reporter);
                parser.parse(this.proguardConfigs);
                configurationBuilder = parser.getConfigurationBuilder();
                configurationBuilder.setForceProguardCompatibility(this.forceProguardCompatibility);
            }
            if (this.proguardConfigurationConsumer != null) {
                this.proguardConfigurationConsumer.accept(configurationBuilder);
            }
            ProguardConfiguration configuration = configurationBuilder.build();
            this.getAppBuilder().addFilteredProgramArchives(configuration.getInjars()).addFilteredLibraryArchives(configuration.getLibraryjars());
            boolean useTreeShaking = this.treeShaking.orElse(configuration.isShrinking());
            boolean useDiscardedChecker = this.discardedChecker.orElse(true);
            boolean useMinification = this.minification.orElse(configuration.isObfuscating());
            assert (this.getProgramConsumer() != null);
            R8Command command = new R8Command(this.getAppBuilder().build(), this.getProgramConsumer(), null, mainDexKeepRules, this.mainDexListConsumer, configuration, this.getMode(), this.getMinApiLevel(), this.reporter, this.getEnableDesugaring(), useTreeShaking, useDiscardedChecker, useMinification, this.forceProguardCompatibility, this.proguardMapConsumer, this.proguardCompatibilityRulesOutput);
            return command;
        }
    }
}

