/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dexfilemerger;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFileMergerHelper;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;

public class DexFileMerger {
    private static final String DEX_PREFIX = "classes";
    private static final String DEFAULT_OUTPUT_ARCHIVE_FILENAME = "classes.dex.jar";
    private static final boolean PRINT_ARGS = false;

    private static List<String> tryParseMulti(ParseContext context, String name) {
        List<String> result = null;
        String head = context.head();
        if (head.equals(name)) {
            context.next();
            result = new ArrayList<String>();
            while (context.head() != null && !context.head().startsWith("-")) {
                result.add(context.head());
                context.next();
            }
        } else if (head.startsWith(name) && head.charAt(name.length()) == '=') {
            result = Collections.singletonList(head.substring(name.length() + 1));
            context.next();
        }
        return result;
    }

    private static String tryParseSingle(ParseContext context, String name, String shortName) {
        String head = context.head();
        if (head.equals(name) || head.equals(shortName)) {
            String next = context.next();
            if (next == null) {
                throw new RuntimeException(String.format("Missing argument for '%s'.", head));
            }
            context.next();
            return next;
        }
        if (head.startsWith(name) && head.charAt(name.length()) == '=') {
            context.next();
            return head.substring(name.length() + 1);
        }
        return null;
    }

    private static Boolean tryParseBoolean(ParseContext context, String name) {
        if (context.head().equals(name)) {
            context.next();
            return true;
        }
        assert (name.startsWith("--"));
        if (context.head().equals("--no" + name.substring(2))) {
            context.next();
            return false;
        }
        return null;
    }

    private static Options parseArguments(String[] args) {
        Options options = new Options();
        ParseContext context = new ParseContext(args);
        while (context.head() != null) {
            List<String> strings = DexFileMerger.tryParseMulti(context, "--input");
            if (strings != null) {
                options.inputArchives.addAll(strings);
                continue;
            }
            String string = DexFileMerger.tryParseSingle(context, "--output", "-o");
            if (string != null) {
                options.outputArchive = string;
                continue;
            }
            string = DexFileMerger.tryParseSingle(context, "--multidex", null);
            if (string != null) {
                options.multidexMode = MultidexStrategy.valueOf(string.toUpperCase());
                continue;
            }
            string = DexFileMerger.tryParseSingle(context, "--main-dex-list", null);
            if (string != null) {
                options.mainDexListFile = string;
                continue;
            }
            Boolean b = DexFileMerger.tryParseBoolean(context, "--minimal-main-dex");
            if (b != null) {
                options.minimalMainDex = b;
                continue;
            }
            b = DexFileMerger.tryParseBoolean(context, "--verbose");
            if (b != null) {
                options.verbose = b;
                continue;
            }
            string = DexFileMerger.tryParseSingle(context, "--max-bytes-wasted-per-file", null);
            if (string != null) {
                System.err.println("Warning: '--max-bytes-wasted-per-file' is ignored.");
                continue;
            }
            string = DexFileMerger.tryParseSingle(context, "--set-max-idx-number", null);
            if (string != null) {
                System.err.println("Warning: The '--set-max-idx-number' option is ignored.");
                continue;
            }
            b = DexFileMerger.tryParseBoolean(context, "--forceJumbo");
            if (b != null) {
                System.err.println("Warning: '--forceJumbo' can be safely omitted. Strings will only use jumbo-string indexing if necessary.");
                continue;
            }
            string = DexFileMerger.tryParseSingle(context, "--dex_prefix", null);
            if (string != null) {
                options.dexPrefix = string;
                continue;
            }
            throw new RuntimeException(String.format("Unknown options: '%s'.", context.head()));
        }
        return options;
    }

    private static int parseFileIndexFromShardFilename(String inputArchive) {
        String name;
        Pattern namingPattern = Pattern.compile("([0-9]+)\\..*");
        Matcher matcher = namingPattern.matcher(name = new File(inputArchive).getName());
        if (!matcher.matches()) {
            throw new RuntimeException(String.format("Expect input named <N>.xxx.zip for --multidex=given_shard but got %s.", name));
        }
        int shard = Integer.parseInt(matcher.group(1));
        if (shard <= 0) {
            throw new RuntimeException(String.format("Expect positive N in input named <N>.xxx.zip but got %d.", shard));
        }
        return shard;
    }

    public static void run(String[] args) throws CompilationFailedException, IOException, CompilationException, ExecutionException {
        Options options = DexFileMerger.parseArguments(args);
        if (options.inputArchives.isEmpty()) {
            throw new RuntimeException("Need at least one --input");
        }
        if (options.mainDexListFile != null && options.inputArchives.size() != 1) {
            throw new RuntimeException("--main-dex-list only supported with exactly one --input, use DexFileSplitter for more");
        }
        if (!options.multidexMode.isMultidexAllowed()) {
            if (options.mainDexListFile != null) {
                throw new RuntimeException("--main-dex-list is only supported with multidex enabled, but mode is: " + options.multidexMode.toString());
            }
            if (options.minimalMainDex) {
                throw new RuntimeException("--minimal-main-dex is only supported with multidex enabled, but mode is: " + options.multidexMode.toString());
            }
        }
        D8Command.Builder builder = D8Command.builder();
        HashMap<String, Integer> inputOrdering = new HashMap<String, Integer>(options.inputArchives.size());
        int sequenceNumber = 0;
        for (String s : options.inputArchives) {
            builder.addProgramFiles(Paths.get(s, new String[0]));
            inputOrdering.put(s, sequenceNumber++);
        }
        Integer singleFixedFileIndex = null;
        switch (options.multidexMode) {
            case OFF: {
                singleFixedFileIndex = 0;
                break;
            }
            case GIVEN_SHARD: {
                if (options.inputArchives.size() != 1) {
                    throw new RuntimeException("'--multidex=given_shard' requires exactly one --input.");
                }
                singleFixedFileIndex = DexFileMerger.parseFileIndexFromShardFilename(options.inputArchives.get(0));
                break;
            }
            case MINIMAL: 
            case BEST_EFFORT: {
                break;
            }
            default: {
                throw new Unreachable("Unexpected enum: " + (Object)((Object)options.multidexMode));
            }
        }
        if (options.mainDexListFile != null) {
            builder.addMainDexListFiles(Paths.get(options.mainDexListFile, new String[0]));
        }
        ArchiveConsumer consumer = new ArchiveConsumer(Paths.get(options.outputArchive, new String[0]), options.dexPrefix, singleFixedFileIndex);
        builder.setProgramConsumer(consumer);
        DexFileMergerHelper.run((D8Command)builder.build(), options.minimalMainDex, inputOrdering);
        if (!consumer.dataHasBeenWritten) {
            File f = new File(options.outputArchive);
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
            out.close();
        }
    }

    public static void main(String[] args) {
        try {
            DexFileMerger.run(args);
        }
        catch (CompilationException | CompilationFailedException | IOException | ExecutionException e) {
            System.err.println("Merge failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printArgs(String[] args) {
        System.err.printf("r8.DexFileMerger", new Object[0]);
        for (String s : args) {
            System.err.printf(" %s", s);
        }
        System.err.println("");
    }

    private static class ArchiveConsumer
    extends DexIndexedConsumer.ArchiveConsumer {
        private final Integer singleFixedFileIndex;
        private final String prefix;
        private boolean dataHasBeenWritten = false;

        private ArchiveConsumer(Path path, String prefix, Integer singleFixedFileIndex) {
            super(path);
            this.prefix = prefix;
            this.singleFixedFileIndex = singleFixedFileIndex;
        }

        @Override
        protected String getDexFileName(int fileIndex) {
            if (this.singleFixedFileIndex != null) {
                fileIndex = this.singleFixedFileIndex;
            }
            return this.prefix + (fileIndex == 0 ? "" : Integer.valueOf(fileIndex + 1)) + ".dex";
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.singleFixedFileIndex != null && fileIndex != 0) {
                handler.error(new StringDiagnostic("Result does not fit into a single dex file."));
                return;
            }
            super.accept(fileIndex, data, descriptors, handler);
            this.dataHasBeenWritten = true;
        }
    }

    private static class ParseContext {
        private String[] args;
        private int nextIndex = 0;

        ParseContext(String[] args) {
            this.args = args;
        }

        String head() {
            return this.nextIndex < this.args.length ? this.args[this.nextIndex] : null;
        }

        String next() {
            if (this.nextIndex < this.args.length) {
                ++this.nextIndex;
                return this.head();
            }
            throw new RuntimeException("Iterating over the end of argument list.");
        }
    }

    private static class Options {
        List<String> inputArchives = new ArrayList<String>();
        String outputArchive = "classes.dex.jar";
        MultidexStrategy multidexMode = MultidexStrategy.OFF;
        String mainDexListFile = null;
        boolean minimalMainDex = false;
        boolean verbose = false;
        String dexPrefix = "classes";

        private Options() {
        }
    }

    private static enum MultidexStrategy {
        OFF,
        GIVEN_SHARD,
        MINIMAL,
        BEST_EFFORT;


        public boolean isMultidexAllowed() {
            switch (this) {
                case OFF: 
                case GIVEN_SHARD: {
                    return false;
                }
                case MINIMAL: 
                case BEST_EFFORT: {
                    return true;
                }
            }
            throw new AssertionError((Object)("Unknown: " + (Object)((Object)this)));
        }
    }
}

