/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;

public class ArrayTypeLatticeElement
extends TypeLatticeElement {
    final DexType elementType;
    final int nesting;

    ArrayTypeLatticeElement(DexType elementType, int nesting, boolean isNullable) {
        super(isNullable);
        this.elementType = elementType;
        this.nesting = nesting;
    }

    @Override
    TypeLatticeElement asNullable() {
        return this.isNullable() ? this : new ArrayTypeLatticeElement(this.elementType, this.nesting, true);
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfoWithSubtyping appInfo) {
        if (this.nesting == 1) {
            return ArrayTypeLatticeElement.fromDexType(appInfo, this.elementType, true);
        }
        return new ArrayTypeLatticeElement(this.elementType, this.nesting - 1, true);
    }

    @Override
    public TypeLatticeElement checkCast(AppInfoWithSubtyping appInfo, DexType castType) {
        DexType base;
        if (castType.getNumberOfLeadingSquareBrackets() == this.nesting && this.elementType.isSubtypeOf(base = castType.toBaseType(appInfo.dexItemFactory), appInfo)) {
            return this;
        }
        return super.checkCast(appInfo, castType);
    }

    @Override
    public String toString() {
        return this.isNullableString() + this.elementType.toString() + Strings.repeat("[]", this.nesting);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ArrayTypeLatticeElement other = (ArrayTypeLatticeElement)o;
        return this.nesting == other.nesting && this.elementType == other.elementType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.elementType.hashCode();
        result = 31 * result + this.nesting;
        return result;
    }
}

