/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.jar;

import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.tree.ClassNode;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.org.objectweb.asm.util.CheckClassAdapter;
import com.android.tools.r8.org.objectweb.asm.util.Textifier;
import com.android.tools.r8.org.objectweb.asm.util.TraceMethodVisitor;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;

public class CfApplicationWriter {
    private final DexApplication application;
    private final InternalOptions options;

    public CfApplicationWriter(DexApplication application, InternalOptions options) {
        this.application = application;
        this.options = options;
    }

    public void write(ClassFileConsumer consumer, ExecutorService executor) throws IOException {
        this.application.timing.begin("CfApplicationWriter.write");
        try {
            this.writeApplication(consumer, executor);
        }
        finally {
            this.application.timing.end();
        }
    }

    private void writeApplication(ClassFileConsumer consumer, ExecutorService executor) throws IOException {
        for (DexProgramClass clazz : this.application.classes()) {
            if (clazz.getSynthesizedFrom().isEmpty()) {
                this.writeClass(clazz, consumer);
                continue;
            }
            throw new Unimplemented("No support for synthetics in the Java bytecode backend.");
        }
    }

    private int downgrade(int version) {
        return version > 49 ? 49 : version;
    }

    private void writeClass(DexProgramClass clazz, ClassFileConsumer consumer) throws IOException {
        ClassWriter writer = new ClassWriter(0);
        writer.visitSource(clazz.sourceFile != null ? clazz.sourceFile.toString() : null, null);
        int version = this.downgrade(clazz.getClassFileVersion());
        int access = clazz.accessFlags.getAsCfAccessFlags();
        String desc = clazz.type.toDescriptorString();
        String name = clazz.type.getInternalName();
        String signature = null;
        String superName = clazz.type == this.options.itemFactory.objectType ? null : clazz.superType.getInternalName();
        String[] interfaces = new String[clazz.interfaces.values.length];
        for (int i = 0; i < clazz.interfaces.values.length; ++i) {
            interfaces[i] = clazz.interfaces.values[i].getInternalName();
        }
        writer.visit(version, access, name, signature, superName, interfaces);
        if (clazz.getEnclosingMethod() != null) {
            clazz.getEnclosingMethod().write(writer);
        }
        for (InnerClassAttribute entry : clazz.getInnerClasses()) {
            entry.write(writer);
        }
        for (DexEncodedField dexEncodedField : clazz.staticFields()) {
            this.writeField(dexEncodedField, writer);
        }
        for (DexEncodedField dexEncodedField : clazz.instanceFields()) {
            this.writeField(dexEncodedField, writer);
        }
        for (KeyedDexItem keyedDexItem : clazz.directMethods()) {
            this.writeMethod((DexEncodedMethod)keyedDexItem, writer);
        }
        for (KeyedDexItem keyedDexItem : clazz.virtualMethods()) {
            this.writeMethod((DexEncodedMethod)keyedDexItem, writer);
        }
        writer.visitEnd();
        byte[] result = writer.toByteArray();
        assert (CfApplicationWriter.verifyCf(result));
        ExceptionUtils.withConsumeResourceHandler(this.options.reporter, handler -> consumer.accept(result, desc, (DiagnosticsHandler)handler));
    }

    private Object getStaticValue(DexEncodedField field) {
        if (!field.accessFlags.isStatic() || field.staticValue == null) {
            return null;
        }
        return field.staticValue.asAsmEncodedObject();
    }

    private void writeField(DexEncodedField field, ClassWriter writer) {
        int access = field.accessFlags.getAsCfAccessFlags();
        String name = field.field.name.toString();
        String desc = field.field.type.toDescriptorString();
        String signature = null;
        Object value = this.getStaticValue(field);
        writer.visitField(access, name, desc, signature, value);
    }

    private void writeMethod(DexEncodedMethod method, ClassWriter writer) {
        int access = method.accessFlags.getAsCfAccessFlags();
        String name = method.method.name.toString();
        String desc = method.descriptor();
        String signature = null;
        String[] exceptions = null;
        MethodVisitor visitor = writer.visitMethod(access, name, desc, signature, exceptions);
        if (!method.accessFlags.isAbstract()) {
            this.writeCode(method.getCode(), visitor);
        }
    }

    private void writeCode(Code code, MethodVisitor visitor) {
        if (code.isJarCode()) {
            code.asJarCode().writeTo(visitor);
        } else {
            assert (code.isCfCode());
            code.asCfCode().write(visitor);
        }
    }

    private String printCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        ClassNode node = new ClassNode(393216);
        reader.accept(node, 393216);
        StringWriter writer = new StringWriter();
        for (MethodNode method : node.methods) {
            writer.append(method.name).append(method.desc).append('\n');
            TraceMethodVisitor visitor = new TraceMethodVisitor(new Textifier());
            method.accept(visitor);
            visitor.p.print(new PrintWriter(writer));
            writer.append('\n');
        }
        return writer.toString();
    }

    private static boolean verifyCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        PrintWriter pw = new PrintWriter(System.out);
        CheckClassAdapter.verify(reader, false, pw);
        return true;
    }
}

