/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchives;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;

final class DirDexArchive
implements DexArchive {
    private final Path rootDir;

    public DirDexArchive(Path rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public Path getRootPath() {
        return this.rootDir;
    }

    @Override
    public void addFile(String relativePath, byte[] bytes, int offset, int end) throws IOException {
        Path finalPath = this.rootDir.resolve(relativePath);
        Files.createDirectories(finalPath.getParent(), new FileAttribute[0]);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(finalPath, new OpenOption[0]));){
            ((OutputStream)os).write(bytes, offset, end);
            ((OutputStream)os).flush();
        }
    }

    @Override
    public void removeFile(String relativePath) throws IOException {
        Path finalPath = this.rootDir.resolve(relativePath);
        if (Files.isDirectory(finalPath, new LinkOption[0])) {
            FileUtils.deleteDirectoryContents((File)finalPath.toFile());
        }
        Files.deleteIfExists(finalPath);
    }

    @Override
    public List<DexArchiveEntry> getFiles() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator files = Files.walk(this.getRootPath(), new FileVisitOption[0]).filter(DexArchives.DEX_ENTRY_FILTER).iterator();
        while (files.hasNext()) {
            builder.add((Object)this.createEntry((Path)files.next()));
        }
        return builder.build();
    }

    @Override
    public void close() throws IOException {
    }

    private DexArchiveEntry createEntry(Path dexFile) throws IOException {
        byte[] content = Files.readAllBytes(dexFile);
        Path relativePath = this.getRootPath().relativize(dexFile);
        return new DexArchiveEntry(content, PathUtils.toSystemIndependentPath((Path)relativePath), this);
    }
}

