/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.DexOverflowException;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.ClassAndMemberPublicizer;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.EnumOrdinalMapCollector;
import com.android.tools.r8.ir.optimize.SwitchMapCollector;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapApplier;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.naming.SourceFileRewriter;
import com.android.tools.r8.optimize.BridgeMethodAnalysis;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.optimize.VisibilityBridgeRemover;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.shaking.AbstractMethodRemover;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.DiscardedChecker;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ReasonPrinter;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.SimpleClassMerger;
import com.android.tools.r8.shaking.TreePruner;
import com.android.tools.r8.shaking.protolite.ProtoLiteExtension;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LineNumberOptimizer;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.VersionProperties;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class R8 {
    private final Timing timing = new Timing("R8");
    private final InternalOptions options;

    private R8(InternalOptions options) {
        this.options = options;
        options.itemFactory.resetSortedIndices();
    }

    public static void run(R8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withR8CompilationHandler(command.getReporter(), () -> {
            try {
                R8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    public static void run(R8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withR8CompilationHandler(command.getReporter(), () -> R8.run(app, options, executor));
    }

    private static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        Marker marker = new Marker(Marker.Tool.R8).setVersion("v0.2.7-dev").setMinApi(options.minApiLevel);
        if (Version.isDev()) {
            marker.setSha1(VersionProperties.INSTANCE.getSha());
        }
        return marker;
    }

    static void writeApplication(ExecutorService executorService, DexApplication application, String deadCode, NamingLens namingLens, String proguardSeedsData, InternalOptions options, ProguardMapSupplier proguardMapSupplier) throws ExecutionException, DexOverflowException {
        try {
            Marker marker = R8.getMarker(options);
            if (options.isGeneratingClassFiles()) {
                new CfApplicationWriter(application, options).write(options.getClassFileConsumer(), executorService);
            } else {
                new ApplicationWriter(application, options, marker, deadCode, namingLens, proguardSeedsData, proguardMapSupplier).write(executorService);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write application", e);
        }
    }

    private Set<DexType> filterMissingClasses(Set<DexType> missingClasses, ProguardClassFilter dontWarnPatterns) {
        HashSet<DexType> result = new HashSet<DexType>(missingClasses);
        dontWarnPatterns.filterOutMatches(result);
        return result;
    }

    static void runForTesting(AndroidApp app, InternalOptions options) throws IOException, CompilationException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        try {
            R8.run(app, options, executor);
        }
        finally {
            executor.shutdown();
        }
    }

    private static void run(AndroidApp app, InternalOptions options, ExecutorService executor) throws IOException, CompilationException {
        new R8(options).run(app, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(AndroidApp inputApp, ExecutorService executorService) throws IOException, CompilationException {
        assert (this.options.programConsumer != null);
        if (this.options.quiet) {
            System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
        }
        try {
            ProguardMapSupplier proguardMapSupplier;
            Object closer;
            TreePruner pruner;
            Enqueuer enqueuer;
            RootSetBuilder.RootSet rootSet;
            String proguardSeedsData;
            AppInfoWithSubtyping appInfo;
            DexApplication application;
            block48: {
                AndroidApiLevel oLevel = AndroidApiLevel.O;
                if (this.options.minApiLevel >= oLevel.getLevel() && !this.options.mainDexKeepRules.isEmpty()) {
                    throw new CompilationError("Automatic main dex list is not supported when compiling for " + oLevel.getName() + " and later (--min-api " + oLevel.getLevel() + ")");
                }
                application = new ApplicationReader(inputApp, this.options, this.timing).read(executorService).toDirect();
                appInfo = new AppInfoWithSubtyping(application);
                proguardSeedsData = null;
                this.timing.begin("Strip unused code");
                try {
                    Object out;
                    Set<DexType> missingClasses = appInfo.getMissingClasses();
                    missingClasses = this.filterMissingClasses(missingClasses, this.options.proguardConfiguration.getDontWarnPatterns());
                    if (!missingClasses.isEmpty()) {
                        missingClasses.forEach(clazz -> this.options.reporter.warning(new StringDiagnostic("Missing class: " + clazz.toSourceString())));
                        if (!this.options.ignoreMissingClasses) {
                            throw new CompilationError("Compilation can't be completed because some library classes are missing.");
                        }
                    }
                    ProguardConfiguration.Builder compatibility = ProguardConfiguration.builder(application.dexItemFactory, this.options.reporter);
                    rootSet = new RootSetBuilder(application, appInfo, this.options.proguardConfiguration.getRules(), this.options).run(executorService);
                    enqueuer = new Enqueuer(appInfo, this.options, compatibility);
                    enqueuer.addExtension(new ProtoLiteExtension(appInfo));
                    appInfo = enqueuer.traceApplication(rootSet, this.timing);
                    if (this.options.proguardConfiguration.isPrintSeeds()) {
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        out = new PrintStream(bytes);
                        RootSetBuilder.writeSeeds(appInfo.withLiveness(), (PrintStream)out);
                        ((PrintStream)out).flush();
                        proguardSeedsData = bytes.toString();
                    }
                    if (this.options.useTreeShaking) {
                        pruner = new TreePruner(application, appInfo.withLiveness(), this.options);
                        application = pruner.run();
                        appInfo = appInfo.withLiveness().prunedCopyFrom(application, pruner.getRemovedClasses());
                        new AbstractMethodRemover(appInfo).run();
                        new AnnotationRemover(appInfo.withLiveness(), compatibility, this.options).run();
                    }
                    if (!this.options.forceProguardCompatibility || this.options.proguardCompatibilityRulesOutput == null) break block48;
                    closer = Closer.create();
                    out = null;
                    try {
                        OutputStream outputStream = FileUtils.openPath((Closer)closer, this.options.proguardCompatibilityRulesOutput, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                        PrintStream ps = new PrintStream(outputStream);
                        ps.println(compatibility.buildRaw().toString());
                    }
                    catch (Throwable throwable) {
                        out = throwable;
                        throw throwable;
                    }
                    finally {
                        if (closer != null) {
                            R8.$closeResource((Throwable)out, (AutoCloseable)closer);
                        }
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            if (this.options.proguardConfiguration.isAccessModificationAllowed()) {
                ClassAndMemberPublicizer.run(application);
                application = new VisibilityBridgeRemover(appInfo, application).run();
            }
            GraphLense graphLense = GraphLense.getIdentityLense();
            if (appInfo.hasLiveness()) {
                graphLense = new MemberRebindingAnalysis(appInfo.withLiveness(), graphLense).run();
                if (!this.options.skipClassMerging && this.options.inlineAccessors) {
                    this.timing.begin("ClassMerger");
                    SimpleClassMerger classMerger = new SimpleClassMerger(application, appInfo.withLiveness(), graphLense, this.timing);
                    graphLense = classMerger.run();
                    this.timing.end();
                    appInfo = appInfo.withLiveness().prunedCopyFrom(application, classMerger.getRemovedClasses());
                }
                if (this.options.proguardConfiguration.hasApplyMappingFile()) {
                    SeedMapper seedMapper = SeedMapper.seedMapperFromFile(this.options.proguardConfiguration.getApplyMappingFile());
                    this.timing.begin("apply-mapping");
                    graphLense = new ProguardMapApplier(appInfo.withLiveness(), graphLense, seedMapper).run(this.timing);
                    this.timing.end();
                }
                application = application.asDirect().rewrittenWithLense(graphLense);
                appInfo = appInfo.withLiveness().rewrittenWithLense(application.asDirect(), graphLense);
                new SwitchMapCollector(appInfo.withLiveness(), this.options).run();
                new EnumOrdinalMapCollector(appInfo.withLiveness(), this.options).run();
            }
            graphLense = new BridgeMethodAnalysis(graphLense, appInfo.withSubtyping()).run();
            this.timing.begin("Create IR");
            CfgPrinter printer = this.options.printCfg ? new CfgPrinter() : null;
            try {
                IRConverter converter = new IRConverter(appInfo, this.options, this.timing, printer, graphLense);
                application = converter.optimize(application, executorService);
            }
            finally {
                this.timing.end();
            }
            if (this.options.printCfg) {
                if (this.options.printCfgFile == null || this.options.printCfgFile.isEmpty()) {
                    System.out.print(printer.toString());
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.options.printCfgFile), StandardCharsets.UTF_8);
                    closer = null;
                    try {
                        writer.write(printer.toString());
                    }
                    catch (Throwable out) {
                        closer = out;
                        throw out;
                    }
                    finally {
                        R8.$closeResource((Throwable)closer, writer);
                    }
                }
            }
            this.timing.begin("Rename SourceFile");
            new SourceFileRewriter(appInfo, this.options).run();
            this.timing.end();
            if (!this.options.mainDexKeepRules.isEmpty()) {
                appInfo = new AppInfoWithSubtyping(application);
                enqueuer = new Enqueuer(appInfo, this.options);
                RootSetBuilder.RootSet mainDexRootSet = new RootSetBuilder(application, appInfo, this.options.mainDexKeepRules, this.options).run(executorService);
                Set<DexType> mainDexBaseClasses = enqueuer.traceMainDex(mainDexRootSet, this.timing);
                application = application.builder().addToMainDexList(new MainDexListBuilder(mainDexBaseClasses, application).run()).build();
            }
            appInfo = new AppInfoWithSubtyping(application);
            if (this.options.useTreeShaking || !this.options.skipMinification) {
                this.timing.begin("Post optimization code stripping");
                try {
                    enqueuer = new Enqueuer(appInfo, this.options);
                    appInfo = enqueuer.traceApplication(rootSet, this.timing);
                    if (this.options.useTreeShaking) {
                        pruner = new TreePruner(application, appInfo.withLiveness(), this.options);
                        application = pruner.run();
                        appInfo = appInfo.withLiveness().prunedCopyFrom(application, pruner.getRemovedClasses());
                        ReasonPrinter reasonPrinter = enqueuer.getReasonPrinter(rootSet.reasonAsked);
                        reasonPrinter.run(application);
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            if (this.options.useTreeShaking && !rootSet.checkDiscarded.isEmpty()) {
                new DiscardedChecker(rootSet, application, this.options).run();
            }
            this.timing.begin("Minification");
            NamingLens namingLens = this.options.skipMinification ? NamingLens.getIdentityLens() : new Minifier(appInfo.withLiveness(), rootSet, this.options).run(this.timing);
            this.timing.end();
            if (this.options.lineNumberOptimization != InternalOptions.LineNumberOptimization.OFF) {
                this.timing.begin("Line number remapping");
                ClassNameMapper classNameMapper = LineNumberOptimizer.run(application, namingLens, this.options.lineNumberOptimization == InternalOptions.LineNumberOptimization.IDENTITY_MAPPING);
                this.timing.end();
                proguardMapSupplier = ProguardMapSupplier.fromClassNameMapper(classNameMapper);
            } else {
                proguardMapSupplier = ProguardMapSupplier.fromNamingLens(namingLens, application);
            }
            if (this.options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                this.options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                return;
            }
            R8.writeApplication(executorService, application, application.deadCode, namingLens, proguardSeedsData, this.options, proguardMapSupplier);
            this.options.printWarnings();
        }
        catch (ExecutionException e) {
            R8.unwrapExecutionException(e);
            throw new AssertionError((Object)e);
        }
        finally {
            this.options.signalFinishedToProgramConsumer();
            if (this.options.printTimes) {
                this.timing.report();
            }
        }
    }

    static void unwrapExecutionException(ExecutionException executionException) throws CompilationException {
        Throwable cause = executionException.getCause();
        if (cause instanceof CompilationError) {
            cause.addSuppressed(executionException);
            throw (CompilationError)cause;
        }
        if (cause instanceof CompilationException) {
            cause.addSuppressed(executionException);
            throw (CompilationException)cause;
        }
        if (cause instanceof RuntimeException) {
            if (cause.getCause() != null && cause.getCause() instanceof CompilationException) {
                cause.addSuppressed(executionException);
                throw (CompilationException)cause.getCause();
            }
            if (cause.getCause() != null && cause.getCause().getCause() != null && cause.getCause().getCause() instanceof CompilationException) {
                cause.addSuppressed(executionException);
                throw (CompilationException)cause.getCause().getCause();
            }
            cause.addSuppressed(executionException);
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(executionException.getMessage(), cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws CompilationFailedException {
        R8Command command = (R8Command)R8Command.parse(args, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            System.out.println(R8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            Version.printToolVersion("R8");
            return;
        }
        InternalOptions options = command.getInternalOptions();
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        try {
            ExceptionUtils.withR8CompilationHandler(options.reporter, () -> R8.run(command.getInputApp(), options, executorService));
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(R8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        ExceptionUtils.withMainProgramHandler(() -> R8.run(args));
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

