/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.benchmarks;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.benchmarks.BenchmarkUtils;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class FrameworkIncrementalDexingBenchmark {
    private static final int ITERATIONS = 100;
    private static final int API = 24;
    private static final Path JAR_DESUGARED = Paths.get("third_party", "framework", "framework_14082017_desugared.jar");
    private static final Path JAR_NOT_DESUGARED = Paths.get("third_party", "framework", "framework_14082017.jar");
    private static final Path LIB = Paths.get("third_party", "android_jar", "lib-v24", "android.jar");

    private static String title(String title, boolean desugar) {
        return "FrameworkIncremental" + (desugar ? title : "NoDesugar" + title);
    }

    private static void compileAll(Path input, final InMemoryClassPathProvider provider, boolean desugar, final Map<String, ProgramResource> outputs, ExecutorService executor) throws IOException, CompilationException, CompilationFailedException {
        DexFilePerClassFileConsumer.ForwardingConsumer consumer = new DexFilePerClassFileConsumer.ForwardingConsumer(null){

            @Override
            public synchronized void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
                ProgramResource resource = ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data, descriptors);
                for (String descriptor : descriptors) {
                    assert (!outputs.containsKey(descriptor));
                    if (!provider.resources.containsKey(descriptor)) continue;
                    outputs.put(descriptor, resource);
                }
            }
        };
        long start = System.nanoTime();
        D8.run((D8Command)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder().setMinApiLevel(24)).setIntermediate(true).setMode(CompilationMode.DEBUG)).addProgramFiles(input)).addLibraryFiles(LIB)).setDisableDesugaring(!desugar)).setProgramConsumer(consumer)).build(), executor);
        BenchmarkUtils.printRuntimeNanoseconds(FrameworkIncrementalDexingBenchmark.title("DexAll", desugar), System.nanoTime() - start);
    }

    private static void compileGroupsOf(int count, List<String> descriptors, final InMemoryClassPathProvider provider, boolean desugar, final Map<String, ProgramResource> outputs, ExecutorService executor) throws IOException, CompilationException, CompilationFailedException {
        DexFilePerClassFileConsumer.ForwardingConsumer consumer = new DexFilePerClassFileConsumer.ForwardingConsumer(null){

            @Override
            public synchronized void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
                ProgramResource resource = ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data, descriptors);
                for (String descriptor : descriptors) {
                    if (!provider.resources.containsKey(descriptor)) continue;
                    outputs.put(descriptor, resource);
                }
            }
        };
        descriptors.sort(String::compareTo);
        int increment = descriptors.size() / 100;
        long start = System.nanoTime();
        for (int iteration = 0; iteration < 100; ++iteration) {
            int index = iteration * increment;
            D8Command.Builder builder = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder().setMinApiLevel(24)).setIntermediate(true).setMode(CompilationMode.DEBUG)).addClasspathResourceProvider(provider).addLibraryFiles(LIB)).setProgramConsumer(consumer)).setDisableDesugaring(!desugar);
            for (int j = 0; j < count; ++j) {
                builder.addClassProgramData(provider.resources.get(descriptors.get(index + j)), Origin.unknown());
            }
            D8.run((D8Command)builder.build(), executor);
        }
        BenchmarkUtils.printRuntimeNanoseconds(FrameworkIncrementalDexingBenchmark.title("DexGroupsOf" + count, desugar), System.nanoTime() - start);
    }

    private static void merge(boolean desugar, Map<String, ProgramResource> outputs, ExecutorService executor) throws IOException, CompilationException, CompilationFailedException, ResourceException {
        D8Command.Builder builder = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder().setMinApiLevel(24)).setIntermediate(false).setMode(CompilationMode.DEBUG)).setProgramConsumer(DexIndexedConsumer.emptyConsumer())).setDisableDesugaring(true);
        for (ProgramResource input : outputs.values()) {
            InputStream inputStream = input.getByteStream();
            Throwable throwable = null;
            try {
                builder.addDexProgramData(ByteStreams.toByteArray(inputStream), input.getOrigin());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        long start = System.nanoTime();
        D8.run((D8Command)builder.build(), executor);
        BenchmarkUtils.printRuntimeNanoseconds(FrameworkIncrementalDexingBenchmark.title("DexMerge", desugar), System.nanoTime() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CompilationException, CompilationFailedException, ResourceException {
        boolean desugar = Arrays.asList(args).contains("--desugar");
        Path input = desugar ? JAR_NOT_DESUGARED : JAR_DESUGARED;
        InMemoryClassPathProvider provider = new InMemoryClassPathProvider(input);
        ArrayList<String> descriptors = new ArrayList<String>(provider.getClassDescriptors());
        HashMap<String, ProgramResource> outputs = new HashMap<String, ProgramResource>(provider.getClassDescriptors().size());
        int threads = Integer.min(Runtime.getRuntime().availableProcessors(), 16) / 2;
        ExecutorService executor = ThreadUtils.getExecutorService(threads);
        try {
            FrameworkIncrementalDexingBenchmark.compileAll(input, provider, desugar, outputs, executor);
            FrameworkIncrementalDexingBenchmark.compileGroupsOf(1, descriptors, provider, desugar, outputs, executor);
            FrameworkIncrementalDexingBenchmark.compileGroupsOf(10, descriptors, provider, desugar, outputs, executor);
            FrameworkIncrementalDexingBenchmark.compileGroupsOf(100, descriptors, provider, desugar, outputs, executor);
            FrameworkIncrementalDexingBenchmark.merge(desugar, outputs, executor);
        }
        finally {
            executor.shutdown();
        }
    }

    static class EntryOrigin
    extends Origin {
        final String descriptor;

        public EntryOrigin(String descriptor, Origin parent) {
            super(parent);
            this.descriptor = descriptor;
        }

        @Override
        public String part() {
            return this.descriptor;
        }
    }

    static class InMemoryClassPathProvider
    implements ClassFileResourceProvider {
        Origin origin;
        Map<String, byte[]> resources;

        InMemoryClassPathProvider(Path archive) throws IOException {
            this.origin = new PathOrigin(archive);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ZipUtils.iter(archive.toString(), (entry, stream) -> {
                String name = entry.getName();
                if (FileUtils.isClassFile(Paths.get(name, new String[0]))) {
                    String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                    builder.put(descriptor, ByteStreams.toByteArray(stream));
                }
            });
            this.resources = builder.build();
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.resources.keySet();
        }

        @Override
        public ProgramResource getProgramResource(String descriptor) {
            byte[] bytes = this.resources.get(descriptor);
            return bytes == null ? null : ProgramResource.fromBytes(new EntryOrigin(descriptor, this.origin), ProgramResource.Kind.CF, bytes, Collections.singleton(descriptor));
        }
    }
}

