/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.VDexFile;
import com.android.tools.r8.errors.CompilationError;
import java.util.ArrayList;
import java.util.List;

public class VDexFileReader {
    private VDexFile file;
    private List<byte[]> dexFiles = new ArrayList<byte[]>();

    public void close() {
        this.file = null;
        this.dexFiles = ImmutableList.of();
    }

    public VDexFileReader(VDexFile file) {
        this.file = file;
        file.setByteOrder();
        this.parseDexFiles();
    }

    public List<byte[]> getDexFiles() {
        return this.dexFiles;
    }

    private void parseDexFiles() {
        this.file.position(8);
        int numberOfDexFiles = this.file.getUint();
        int dexSize = this.file.getUint();
        int verifierDepsSize = this.file.getUint();
        int quickeningInfoSize = this.file.getUint();
        int offset = VDexFile.firstDexOffset(numberOfDexFiles);
        int totalDexSize = 0;
        for (int i = 0; i < numberOfDexFiles; ++i) {
            int size = this.file.getUint(offset + 32);
            this.file.position(offset);
            this.dexFiles.add(this.file.getByteArray(size));
            totalDexSize += size;
            offset += size;
        }
        if (totalDexSize != dexSize) {
            throw new CompilationError("Invalid vdex file. Mismatch in total dex files size");
        }
    }
}

