/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Nop;
import com.android.tools.r8.code.PackedSwitch;
import com.android.tools.r8.code.PackedSwitchPayload;
import com.android.tools.r8.code.SparseSwitch;
import com.android.tools.r8.code.SparseSwitchPayload;
import com.android.tools.r8.com.google.common.primitives.Ints;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.utils.CfgPrinter;
import java.util.List;

public class Switch
extends JumpInstruction {
    private final int[] keys;
    private final int[] targetBlockIndices;
    private int fallthroughBlockIndex;

    public Switch(Value value, int[] keys, int[] targetBlockIndices, int fallthroughBlockIndex) {
        super(null, value);
        this.keys = keys;
        this.targetBlockIndices = targetBlockIndices;
        this.fallthroughBlockIndex = fallthroughBlockIndex;
        assert (this.valid());
    }

    private boolean valid() {
        assert (this.keys.length <= 65535);
        assert (this.keys.length == this.targetBlockIndices.length);
        for (int i = 1; i < this.keys.length - 1; ++i) {
            assert (this.keys[i - 1] < this.keys[i]);
            assert (this.targetBlockIndices[i] != this.fallthroughBlockIndex);
        }
        assert (this.targetBlockIndices[this.keys.length - 1] != this.fallthroughBlockIndex);
        return true;
    }

    public Value value() {
        return (Value)this.inValues.get(0);
    }

    private static long numberOfTargetsIfPacked(int[] keys) {
        return (long)keys[keys.length - 1] - (long)keys[0] + 1L;
    }

    public static boolean canBePacked(int[] keys) {
        return Switch.numberOfTargetsIfPacked(keys) <= 65535L;
    }

    public static int numberOfTargetsForPacked(int[] keys) {
        assert (Switch.canBePacked(keys));
        return (int)Switch.numberOfTargetsIfPacked(keys);
    }

    private static int packedPayloadSize(int[] keys) {
        return Switch.numberOfTargetsForPacked(keys) * 2 + 4;
    }

    private static int sparsePayloadSize(int[] keys) {
        return keys.length * 4 + 2;
    }

    public static int payloadSize(List<Integer> keys) {
        return Switch.payloadSize(Ints.toArray(keys));
    }

    public static int payloadSize(int[] keys) {
        int sparse = Switch.sparsePayloadSize(keys);
        if (Switch.canBePacked(keys)) {
            return Math.min(sparse, Switch.packedPayloadSize(keys));
        }
        return sparse;
    }

    private boolean canBePacked() {
        return Switch.canBePacked(this.keys);
    }

    private int numberOfTargetsForPacked() {
        return Switch.numberOfTargetsForPacked(this.keys);
    }

    private int packedPayloadSize() {
        return Switch.packedPayloadSize(this.keys);
    }

    private int sparsePayloadSize() {
        return Switch.sparsePayloadSize(this.keys);
    }

    private boolean emitPacked() {
        return this.canBePacked() && this.packedPayloadSize() <= this.sparsePayloadSize();
    }

    public int getFirstKey() {
        return this.keys[0];
    }

    @Override
    public boolean isSwitch() {
        return true;
    }

    @Override
    public Switch asSwitch() {
        return this;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        assert (other.isSwitch());
        return false;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isSwitch());
        return 0;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        if (this.emitPacked()) {
            builder.addSwitch(this, new PackedSwitch(value));
        } else {
            builder.addSwitch(this, new SparseSwitch(value));
        }
    }

    public static int estimatedDexSize() {
        return 3;
    }

    public int numberOfKeys() {
        return this.keys.length;
    }

    public int getKey(int index) {
        return this.keys[index];
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] targetBlockIndices() {
        return this.targetBlockIndices;
    }

    public Int2ReferenceSortedMap<BasicBlock> getKeyToTargetMap() {
        Int2ReferenceAVLTreeMap<BasicBlock> result = new Int2ReferenceAVLTreeMap<BasicBlock>();
        for (int i = 0; i < this.keys.length; ++i) {
            result.put(this.getKey(i), this.targetBlock(i));
        }
        return result;
    }

    @Override
    public BasicBlock fallthroughBlock() {
        return this.getBlock().getSuccessors().get(this.fallthroughBlockIndex);
    }

    public int getFallthroughBlockIndex() {
        return this.fallthroughBlockIndex;
    }

    public void setFallthroughBlockIndex(int i) {
        this.fallthroughBlockIndex = i;
    }

    public BasicBlock targetBlock(int index) {
        return this.getBlock().getSuccessors().get(this.targetBlockIndices()[index]);
    }

    @Override
    public void setFallthroughBlock(BasicBlock block) {
        this.getBlock().getSuccessors().set(this.fallthroughBlockIndex, block);
    }

    public Nop buildPayload(int[] targets, int fallthroughTarget) {
        assert (this.keys.length == targets.length);
        if (this.emitPacked()) {
            int targetsCount = this.numberOfTargetsForPacked();
            if (targets.length == targetsCount) {
                return new PackedSwitchPayload(this.getFirstKey(), targets);
            }
            int[] packedTargets = new int[targetsCount];
            int originalIndex = 0;
            for (int i = 0; i < targetsCount; ++i) {
                int key = this.getFirstKey() + i;
                if (this.keys[originalIndex] == key) {
                    packedTargets[i] = targets[originalIndex];
                    ++originalIndex;
                    continue;
                }
                packedTargets[i] = fallthroughTarget;
            }
            assert (originalIndex == this.keys.length);
            return new PackedSwitchPayload(this.getFirstKey(), packedTargets);
        }
        assert (this.numberOfKeys() == this.keys.length);
        return new SparseSwitchPayload(this.keys, targets);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString() + "\n");
        for (int i = 0; i < this.numberOfKeys(); ++i) {
            builder.append("          ");
            builder.append(this.getKey(i));
            builder.append(" -> ");
            builder.append(this.targetBlock(i).getNumber());
            builder.append("\n");
        }
        builder.append("          F -> ");
        builder.append(this.fallthroughBlock().getNumber());
        return builder.toString();
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        for (int index : this.targetBlockIndices) {
            BasicBlock target = this.getBlock().getSuccessors().get(index);
            printer.append(" B").append(target.getNumber());
        }
    }
}

