/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DirectoryClassFileProvider;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.FilteredArchiveClassFileProvider;
import com.android.tools.r8.utils.FilteredArchiveProgramResourceProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndroidApp {
    private final ImmutableList<ProgramResourceProvider> programResourceProviders;
    private final ImmutableMap<Resource, String> programResourcesMainDescriptor;
    private final ImmutableList<ClassFileResourceProvider> classpathResourceProviders;
    private final ImmutableList<ClassFileResourceProvider> libraryResourceProviders;
    private final StringResource proguardMapOutputData;
    private final List<StringResource> mainDexListResources;
    private final List<String> mainDexClasses;

    private AndroidApp(ImmutableList<ProgramResourceProvider> programResourceProviders, ImmutableMap<Resource, String> programResourcesMainDescriptor, ImmutableList<ClassFileResourceProvider> classpathResourceProviders, ImmutableList<ClassFileResourceProvider> libraryResourceProviders, StringResource proguardMapOutputData, List<StringResource> mainDexListResources, List<String> mainDexClasses) {
        this.programResourceProviders = programResourceProviders;
        this.programResourcesMainDescriptor = programResourcesMainDescriptor;
        this.classpathResourceProviders = classpathResourceProviders;
        this.libraryResourceProviders = libraryResourceProviders;
        this.proguardMapOutputData = proguardMapOutputData;
        this.mainDexListResources = mainDexListResources;
        this.mainDexClasses = mainDexClasses;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public Collection<ProgramResource> computeAllProgramResources() throws ResourceException {
        ArrayList<ProgramResource> resources = new ArrayList<ProgramResource>();
        for (ProgramResourceProvider provider : this.programResourceProviders) {
            resources.addAll(provider.getProgramResources());
        }
        return resources;
    }

    public List<ProgramResource> getDexProgramResourcesForTesting() throws IOException {
        try {
            return this.filter(this.programResourceProviders, ProgramResource.Kind.DEX);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new InternalCompilerError("Unexpected resource error", e);
        }
    }

    public List<ProgramResource> getClassProgramResourcesForTesting() throws IOException {
        try {
            return this.filter(this.programResourceProviders, ProgramResource.Kind.CF);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new InternalCompilerError("Unexpected resource error", e);
        }
    }

    public List<ProgramResourceProvider> getProgramResourceProviders() {
        return this.programResourceProviders;
    }

    public List<ClassFileResourceProvider> getClasspathResourceProviders() {
        return this.classpathResourceProviders;
    }

    public List<ClassFileResourceProvider> getLibraryResourceProviders() {
        return this.libraryResourceProviders;
    }

    private List<ProgramResource> filter(List<ProgramResourceProvider> providers, ProgramResource.Kind kind) throws ResourceException {
        ArrayList<ProgramResource> out = new ArrayList<ProgramResource>();
        for (ProgramResourceProvider provider : providers) {
            for (ProgramResource code : provider.getProgramResources()) {
                if (code.getKind() != kind) continue;
                out.add(code);
            }
        }
        return out;
    }

    public StringResource getProguardMapOutputData() {
        return this.proguardMapOutputData;
    }

    public boolean hasMainDexList() {
        return !this.mainDexListResources.isEmpty() || !this.mainDexClasses.isEmpty();
    }

    public boolean hasMainDexListResources() {
        return !this.mainDexListResources.isEmpty();
    }

    public List<StringResource> getMainDexListResources() {
        return this.mainDexListResources;
    }

    public List<String> getMainDexClasses() {
        return this.mainDexClasses;
    }

    public void write(Path output, OutputMode outputMode) throws IOException {
        if (FileUtils.isArchive(output)) {
            this.writeToZip(output, outputMode);
        } else {
            this.writeToDirectory(output, outputMode);
        }
    }

    public void writeToDirectory(Path directory, OutputMode outputMode) throws IOException {
        List<ProgramResource> dexProgramSources = this.getDexProgramResourcesForTesting();
        try {
            if (outputMode == OutputMode.DexIndexed) {
                DexIndexedConsumer.DirectoryConsumer.writeResources(directory, dexProgramSources);
            } else {
                DexFilePerClassFileConsumer.DirectoryConsumer.writeResources(directory, dexProgramSources, this.programResourcesMainDescriptor);
            }
        }
        catch (ResourceException e) {
            throw new IOException("Resource Error", e);
        }
    }

    public void writeToZip(Path archive, OutputMode outputMode) throws IOException {
        block4: {
            List<ProgramResource> resources = this.getDexProgramResourcesForTesting();
            try {
                if (outputMode == OutputMode.DexIndexed) {
                    DexIndexedConsumer.ArchiveConsumer.writeResources(archive, resources);
                    break block4;
                }
                if (outputMode == OutputMode.DexFilePerClassFile) {
                    DexFilePerClassFileConsumer.ArchiveConsumer.writeResources(archive, resources, this.programResourcesMainDescriptor);
                    break block4;
                }
                throw new Unreachable("Unsupported output-mode for writing: " + (Object)((Object)outputMode));
            }
            catch (ResourceException e) {
                throw new IOException("Resource Error", e);
            }
        }
    }

    public String getPrimaryClassDescriptor(Resource resource) {
        assert (resource instanceof ProgramResource);
        return this.programResourcesMainDescriptor.get(resource);
    }

    public static class Builder {
        private final List<ProgramResourceProvider> programResourceProviders = new ArrayList<ProgramResourceProvider>();
        private final List<ProgramResource> programResources = new ArrayList<ProgramResource>();
        private final Map<ProgramResource, String> programResourcesMainDescriptor = new HashMap<ProgramResource, String>();
        private final List<ClassFileResourceProvider> classpathResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private final List<ClassFileResourceProvider> libraryResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private List<StringResource> mainDexListResources = new ArrayList<StringResource>();
        private List<String> mainDexListClasses = new ArrayList<String>();
        private boolean ignoreDexInArchive = false;
        private StringResource proguardMapOutputData;

        private Builder() {
        }

        private Builder(AndroidApp app) {
            this.programResourceProviders.addAll(app.programResourceProviders);
            this.classpathResourceProviders.addAll(app.classpathResourceProviders);
            this.libraryResourceProviders.addAll(app.libraryResourceProviders);
            this.mainDexListResources = app.mainDexListResources;
            this.mainDexListClasses = app.mainDexClasses;
        }

        public Builder addProgramFiles(Path ... files) throws NoSuchFileException {
            return this.addProgramFiles(Arrays.asList(files));
        }

        public Builder addProgramFiles(Collection<Path> files) throws NoSuchFileException {
            for (Path file : files) {
                this.addProgramFile(file);
            }
            return this;
        }

        public Builder addFilteredProgramArchives(Collection<FilteredClassPath> filteredArchives) throws NoSuchFileException {
            for (FilteredClassPath archive : filteredArchives) {
                assert (FileUtils.isArchive(archive.getPath()));
                this.addProgramResourceProvider(new FilteredArchiveProgramResourceProvider(archive, this.ignoreDexInArchive));
            }
            return this;
        }

        public Builder addProgramResourceProvider(ProgramResourceProvider provider) {
            assert (provider != null);
            this.programResourceProviders.add(provider);
            return this;
        }

        public Builder addClasspathFiles(Path ... files) throws IOException {
            return this.addClasspathFiles(Arrays.asList(files));
        }

        public Builder addClasspathFiles(Collection<Path> files) throws IOException {
            for (Path file : files) {
                this.addClasspathFile(file);
            }
            return this;
        }

        public Builder addClasspathFile(Path file) throws IOException {
            this.addClasspathOrLibraryProvider(file, this.classpathResourceProviders);
            return this;
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.classpathResourceProviders.add(provider);
            return this;
        }

        public Builder addLibraryFiles(Path ... files) throws IOException {
            return this.addLibraryFiles(Arrays.asList(files));
        }

        public Builder addLibraryFiles(Collection<Path> files) throws IOException {
            for (Path file : files) {
                this.addClasspathOrLibraryProvider(file, this.libraryResourceProviders);
            }
            return this;
        }

        public Builder addLibraryFile(Path file) throws IOException {
            this.addClasspathOrLibraryProvider(file, this.libraryResourceProviders);
            return this;
        }

        public Builder addFilteredLibraryArchives(Collection<FilteredClassPath> filteredArchives) throws IOException {
            for (FilteredClassPath archive : filteredArchives) {
                assert (FileUtils.isArchive(archive.getPath()));
                this.libraryResourceProviders.add(new FilteredArchiveClassFileProvider(archive));
            }
            return this;
        }

        public Builder addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.libraryResourceProviders.add(provider);
            return this;
        }

        public Builder addDexProgramData(byte[] data, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data, classDescriptors));
            return this;
        }

        public Builder addDexProgramData(byte[] data, Set<String> classDescriptors, String primaryClassDescriptor) {
            ProgramResource resource = ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data, classDescriptors);
            this.programResources.add(resource);
            this.programResourcesMainDescriptor.put(resource, primaryClassDescriptor);
            return this;
        }

        public Builder addDexProgramData(byte[] data, Origin origin) {
            this.addProgramResources(ProgramResource.fromBytes(origin, ProgramResource.Kind.DEX, data, null));
            return this;
        }

        public Builder addDexProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.addProgramResources(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, datum, null));
            }
            return this;
        }

        public Builder addClassProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.addClassProgramData(datum, Origin.unknown());
            }
            return this;
        }

        public Builder addClassProgramData(byte[] data, Origin origin) {
            return this.addClassProgramData(data, origin, null);
        }

        public Builder addClassProgramData(byte[] data, Origin origin, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(origin, ProgramResource.Kind.CF, data, classDescriptors));
            return this;
        }

        public Builder setProguardMapOutputData(String content) {
            this.proguardMapOutputData = content == null ? null : StringResource.fromString(content, Origin.unknown());
            return this;
        }

        public Builder addMainDexListFiles(Path ... files) throws NoSuchFileException {
            return this.addMainDexListFiles(Arrays.asList(files));
        }

        public Builder addMainDexListFiles(Collection<Path> files) throws NoSuchFileException {
            for (Path file : files) {
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new NoSuchFileException(file.toString());
                }
                this.mainDexListResources.add(StringResource.fromFile(file));
            }
            return this;
        }

        public Builder addMainDexClasses(String ... classes) {
            return this.addMainDexClasses(Arrays.asList(classes));
        }

        public Builder addMainDexClasses(Collection<String> classes) {
            this.mainDexListClasses.addAll(classes);
            return this;
        }

        public boolean hasMainDexList() {
            return !this.mainDexListResources.isEmpty() || !this.mainDexListClasses.isEmpty();
        }

        public Builder setIgnoreDexInArchive(boolean value) {
            this.ignoreDexInArchive = value;
            return this;
        }

        public AndroidApp build() {
            if (!this.programResources.isEmpty()) {
                final ImmutableList<ProgramResource> resources = ImmutableList.copyOf(this.programResources);
                this.programResourceProviders.add(new ProgramResourceProvider(){

                    @Override
                    public Collection<ProgramResource> getProgramResources() throws ResourceException {
                        return resources;
                    }
                });
                this.programResources.clear();
            }
            return new AndroidApp(ImmutableList.copyOf(this.programResourceProviders), ImmutableMap.copyOf(this.programResourcesMainDescriptor), ImmutableList.copyOf(this.classpathResourceProviders), ImmutableList.copyOf(this.libraryResourceProviders), this.proguardMapOutputData, this.mainDexListResources, this.mainDexListClasses);
        }

        public void addProgramFile(Path file) throws NoSuchFileException {
            if (!Files.exists(file, new LinkOption[0])) {
                throw new NoSuchFileException(file.toString());
            }
            if (FileUtils.isDexFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.DEX, file));
            } else if (FileUtils.isClassFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.CF, file));
            } else if (FileUtils.isArchive(file)) {
                this.addProgramResourceProvider(new FilteredArchiveProgramResourceProvider(FilteredClassPath.unfiltered(file), this.ignoreDexInArchive));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
        }

        private void addProgramResources(ProgramResource ... resources) {
            this.addProgramResources(Arrays.asList(resources));
        }

        private void addProgramResources(Collection<ProgramResource> resources) {
            this.programResources.addAll(resources);
        }

        private void addClasspathOrLibraryProvider(Path file, List<ClassFileResourceProvider> providerList) throws IOException {
            if (!Files.exists(file, new LinkOption[0])) {
                throw new NoSuchFileException(file.toString());
            }
            if (FileUtils.isArchive(file)) {
                providerList.add(new ArchiveClassFileProvider(file));
            } else if (Files.isDirectory(file, new LinkOption[0])) {
                providerList.add(DirectoryClassFileProvider.fromDirectory(file));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
        }
    }
}

