/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.Collection;

public class Reporter
implements DiagnosticsHandler {
    private final DiagnosticsHandler clientHandler;
    private int errorCount = 0;
    private final Collection<Throwable> suppressedExceptions = new ArrayList<Throwable>();

    public Reporter(DiagnosticsHandler clientHandler) {
        this.clientHandler = clientHandler;
    }

    @Override
    public void info(Diagnostic info) {
        this.clientHandler.info(info);
    }

    @Override
    public void warning(Diagnostic warning) {
        this.clientHandler.warning(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(Diagnostic error) {
        this.clientHandler.error(error);
        Reporter reporter = this;
        synchronized (reporter) {
            ++this.errorCount;
        }
    }

    public void error(String message) {
        this.error(new StringDiagnostic(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Diagnostic error, Throwable suppressedException) {
        this.clientHandler.error(error);
        Reporter reporter = this;
        synchronized (reporter) {
            ++this.errorCount;
            this.suppressedExceptions.add(suppressedException);
        }
    }

    public RuntimeException fatalError(Diagnostic error) {
        this.error(error);
        this.failIfPendingErrors();
        throw new Unreachable();
    }

    public RuntimeException fatalError(Diagnostic error, Throwable suppressedException) {
        this.error(error, suppressedException);
        this.failIfPendingErrors();
        throw new Unreachable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failIfPendingErrors() {
        Reporter reporter = this;
        synchronized (reporter) {
            if (this.errorCount != 0) {
                AbortException abort = new AbortException();
                throw this.addSuppressedExceptions(abort);
            }
        }
    }

    private <T extends Throwable> T addSuppressedExceptions(T t) {
        this.suppressedExceptions.forEach(throwable -> t.addSuppressed((Throwable)throwable));
        return t;
    }

    public void guard(Runnable action) throws CompilationFailedException {
        try {
            action.run();
        }
        catch (CompilationError e) {
            this.error(e);
            throw this.addSuppressedExceptions(new CompilationFailedException());
        }
        catch (AbortException e) {
            throw new CompilationFailedException(e);
        }
    }
}

