/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Bottom;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class TypeAnalysis {
    private final AppInfoWithSubtyping appInfo;
    private final DexEncodedMethod encodedMethod;
    private final IRCode code;
    private final Deque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
    private final Map<Value, TypeLatticeElement> typeMap = Maps.newHashMap();
    private final Map<Value, Set<BasicBlock>> users = Maps.newHashMap();

    public TypeAnalysis(AppInfoWithSubtyping appInfo, DexEncodedMethod encodedMethod, IRCode code) {
        this.appInfo = appInfo;
        this.encodedMethod = encodedMethod;
        this.code = code;
    }

    public void run() {
        this.worklist.addAll(this.code.topologicallySortedBlocks());
        while (!this.worklist.isEmpty()) {
            this.processBasicBlock(this.worklist.poll());
        }
    }

    private void addToWorklist(BasicBlock block) {
        if (!this.worklist.contains(block)) {
            this.worklist.add(block);
        }
    }

    private void processBasicBlock(BasicBlock block) {
        int argumentsSeen = this.encodedMethod.accessFlags.isStatic() ? 0 : -1;
        for (Instruction instruction : block.getInstructions()) {
            TypeLatticeElement current;
            TypeLatticeElement derived = Bottom.getInstance();
            Value outValue = instruction.outValue();
            if (instruction instanceof Argument) {
                if (argumentsSeen < 0) {
                    derived = TypeLatticeElement.fromDexType(this.appInfo, this.encodedMethod.method.holder, false);
                } else {
                    DexType argType = this.encodedMethod.method.proto.parameters.values[argumentsSeen];
                    derived = TypeLatticeElement.fromDexType(this.appInfo, argType, true);
                }
                ++argumentsSeen;
            } else {
                instruction.inValues().forEach((? super T v) -> this.registerAsUserOfValue((Value)v, block, Sets.newIdentityHashSet()));
                if (outValue != null) {
                    derived = instruction.evaluate(this.appInfo, this::getLatticeElement);
                }
            }
            if (outValue == null || (current = this.getLatticeElement(outValue)).equals(derived)) continue;
            this.updateTypeOfValue(outValue, derived);
        }
    }

    private void registerAsUserOfValue(Value value, BasicBlock block, Set<Value> seenPhis) {
        if (value.isPhi() && seenPhis.add(value)) {
            for (Value operand : value.asPhi().getOperands()) {
                this.registerAsUserOfValue(operand, block, seenPhis);
            }
        } else {
            this.users.computeIfAbsent(value, k -> Sets.newIdentityHashSet()).add(block);
        }
    }

    private void updateTypeOfValue(Value value, TypeLatticeElement type) {
        this.setLatticeElement(value, type);
        this.users.getOrDefault(value, Collections.emptySet()).forEach(this::addToWorklist);
        for (Phi phi : value.uniquePhiUsers()) {
            TypeLatticeElement phiType = this.computePhiType(phi);
            if (this.getLatticeElement(phi).equals(phiType)) continue;
            this.updateTypeOfValue(phi, phiType);
        }
    }

    private TypeLatticeElement computePhiType(Phi phi) {
        BiFunction<TypeLatticeElement, TypeLatticeElement, TypeLatticeElement> joiner = TypeLatticeElement.joiner(this.appInfo);
        return phi.getOperands().stream().reduce(Bottom.getInstance(), (acc, value) -> (TypeLatticeElement)joiner.apply((TypeLatticeElement)acc, this.getLatticeElement((Value)value)), joiner::apply);
    }

    private void setLatticeElement(Value value, TypeLatticeElement type) {
        this.typeMap.put(value, type);
    }

    TypeLatticeElement getLatticeElement(Value value) {
        return this.typeMap.getOrDefault(value, Bottom.getInstance());
    }

    @VisibleForTesting
    void forEach(BiConsumer<Value, TypeLatticeElement> consumer) {
        this.typeMap.forEach(consumer);
    }
}

