/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base2Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import java.nio.ShortBuffer;

public abstract class Format22s
extends Base2Format {
    public final byte A;
    public final byte B;
    public final short CCCC;

    Format22s(int high, BytecodeStream stream) {
        super(stream);
        this.A = (byte)(high & 0xF);
        this.B = (byte)(high >> 4 & 0xF);
        this.CCCC = Format22s.readSigned16BitValue(stream);
    }

    Format22s(int A, int B, int CCCC) {
        assert (0 <= A && A <= 15);
        assert (0 <= B && B <= 15);
        assert (Short.MIN_VALUE <= CCCC && CCCC <= Short.MAX_VALUE);
        this.A = (byte)A;
        this.B = (byte)B;
        this.CCCC = (short)CCCC;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(this.B, this.A, dest);
        this.write16BitValue(this.CCCC, dest);
    }

    @Override
    public final int hashCode() {
        return (this.CCCC << 8 | this.A << 4 | this.B) ^ this.getClass().hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format22s o = (Format22s)other;
        return o.A == this.A && o.B == this.B && o.CCCC == this.CCCC;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.A + ", v" + this.B + ", #" + this.CCCC);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.A + ", v" + this.B + ", " + StringUtils.hexString(this.CCCC, 4) + "  # " + this.CCCC);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
    }
}

