/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2DaemonUtil;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2QueuedResourceProcessor;
import com.android.builder.tasks.BooleanLatch;
import com.android.builder.tasks.Job;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AaptProcess {
    private static final int DEFAULT_SLAVE_AAPT_TIMEOUT_IN_SECONDS = 5;
    private static final int SLAVE_AAPT_TIMEOUT_IN_SECONDS = System.getenv("SLAVE_AAPT_TIMEOUT") == null ? 5 : Integer.parseInt(System.getenv("SLAVE_AAPT_TIMEOUT"));
    private static final Joiner joiner = Joiner.on((char)'\n');
    private final String mAaptLocation;
    private final Process mProcess;
    private final ILogger mLogger;
    private final ProcessOutputFacade mProcessOutputFacade = new ProcessOutputFacade();
    private int processCount = 0;
    private final AtomicBoolean mReady = new AtomicBoolean(false);
    private final BooleanLatch mReadyLatch = new BooleanLatch();
    private final OutputStreamWriter mWriter;

    private AaptProcess(String aaptLocation, Process process, ILogger iLogger) throws InterruptedException {
        this.mAaptLocation = aaptLocation;
        this.mProcess = process;
        this.mLogger = iLogger;
        GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)this.mProcessOutputFacade);
        this.mWriter = new OutputStreamWriter(this.mProcess.getOutputStream());
    }

    public void crunch(File in, File out, Job<AaptProcess> job) throws IOException {
        if (!this.mReady.get()) {
            throw new RuntimeException("AAPT process not ready to receive commands");
        }
        NotifierProcessOutput notifier = new NotifierProcessOutput(job, this.mProcessOutputFacade, this.mLogger, null);
        this.mProcessOutputFacade.setNotifier(notifier);
        this.mWriter.write("s\n");
        this.mWriter.write(FileUtils.toExportableSystemDependentPath((File)in));
        this.mWriter.write(10);
        this.mWriter.write(FileUtils.toExportableSystemDependentPath((File)out));
        this.mWriter.write(10);
        this.mWriter.flush();
        ++this.processCount;
        this.mLogger.verbose("AAPT1 processed(%1$d) %2$s job:%3$s", new Object[]{this.hashCode(), in.getName(), job.toString()});
    }

    public void compile(CompileResourceRequest request, Job<AaptProcess> job, ProcessOutputHandler processOutputHandler) throws IOException {
        if (!this.mReady.get()) {
            throw new RuntimeException(String.format("AAPT2 process not ready to receive commands. Please make sure the build tools (located at %s) are not corrupted. Check the logs for details.", this.mAaptLocation));
        }
        NotifierProcessOutput notifier = new NotifierProcessOutput(job, this.mProcessOutputFacade, this.mLogger, processOutputHandler);
        this.mProcessOutputFacade.setNotifier(notifier);
        Aapt2DaemonUtil.requestCompile(this.mWriter, request);
        ++this.processCount;
        this.mLogger.verbose("AAPT2 processed(%1$d) %2$s job:%3$s", new Object[]{this.hashCode(), request.getInputFile().getName(), job.toString()});
    }

    public void link(AaptPackageConfig config, Job<AaptProcess> job, ProcessOutputHandler processOutputHandler) throws IOException {
        if (!this.mReady.get()) {
            throw new RuntimeException(String.format("AAPT2 process not ready to receive commands. Please make sure the build tools (located at %s) are not corrupted. Check the logs for details.", this.mAaptLocation));
        }
        NotifierProcessOutput notifier = new NotifierProcessOutput(job, this.mProcessOutputFacade, this.mLogger, processOutputHandler);
        this.mProcessOutputFacade.setNotifier(notifier);
        Aapt2DaemonUtil.requestLink(this.mWriter, config);
        ++this.processCount;
        this.mLogger.verbose("AAPT2 processed(%1$d) linking job:%2$s", new Object[]{this.hashCode(), job.toString()});
    }

    public boolean waitForReadyOrFail() throws InterruptedException {
        if (!this.mReadyLatch.await(TimeUnit.NANOSECONDS.convert(SLAVE_AAPT_TIMEOUT_IN_SECONDS, TimeUnit.SECONDS))) {
            throw new RuntimeException(String.format("Timed out while waiting for slave aapt process, make sure the aapt execute at %1$s can run successfully (some anti-virus may block it) or try setting environment variable SLAVE_AAPT_TIMEOUT to a value bigger than %2$d seconds", this.mAaptLocation, SLAVE_AAPT_TIMEOUT_IN_SECONDS));
        }
        if (this.mReady.get()) {
            this.mLogger.verbose("Slave %1$s is ready", new Object[]{this.hashCode()});
            return true;
        }
        this.mLogger.error((Throwable)new RuntimeException(String.format("AAPT slave failed to start. Please make sure the current build tools (located at %s) are not corrupted.", this.mAaptLocation)), String.format("Slave %1$s failed to start", this.hashCode()), new Object[0]);
        Aapt2QueuedResourceProcessor.invalidateProcess(this.mAaptLocation);
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashcode", this.hashCode()).add("\nlocation", (Object)this.mAaptLocation).add("\nready", this.mReady.get()).add("\nprocess", this.mProcess.hashCode()).toString();
    }

    public void shutdown() throws IOException, InterruptedException {
        if (!this.mReady.get()) {
            this.mLogger.verbose("Process (%1$s) already shutdown", new Object[]{this.hashCode()});
            return;
        }
        this.mReady.set(false);
        Aapt2DaemonUtil.requestShutdown(this.mWriter);
        this.mProcess.waitFor();
        this.mLogger.verbose("Process (%1$s) processed %2$s files", new Object[]{this.hashCode(), this.processCount});
    }

    private static class NotifierProcessOutput
    implements GrabProcessOutput.IProcessOutput {
        private final Job<AaptProcess> mJob;
        private final ProcessOutputFacade mOwner;
        private final ILogger mLogger;
        private final AtomicBoolean mInError = new AtomicBoolean(false);
        private final ArrayList<String> errors = new ArrayList();
        private final ProcessOutputHandler processOutputHandler;

        NotifierProcessOutput(Job<AaptProcess> job, ProcessOutputFacade owner, ILogger iLogger, ProcessOutputHandler processOutputHandler) {
            this.mOwner = owner;
            this.mJob = job;
            this.mLogger = iLogger;
            this.processOutputHandler = processOutputHandler;
        }

        public void out(String line) {
            if (line != null) {
                if (line.equalsIgnoreCase("Done")) {
                    this.mOwner.reset();
                    if (this.mInError.get()) {
                        if (this.errors.isEmpty()) {
                            this.mJob.error(new Aapt2Exception("AAPT error: check logs for details"));
                        } else {
                            this.mJob.error(new AaptException(joiner.join(this.errors)));
                        }
                    } else {
                        this.mJob.finished();
                    }
                } else if (line.equalsIgnoreCase("Error")) {
                    this.mInError.set(true);
                } else {
                    this.mLogger.verbose("AAPT(%1$s) discarded: %2$s", new Object[]{this.mJob, line});
                }
            }
        }

        public void err(String line) {
            if (line != null) {
                if (line.equalsIgnoreCase("Done")) {
                    this.mOwner.reset();
                    if (this.mInError.get()) {
                        if (!this.handleOutput()) {
                            if (this.errors.isEmpty()) {
                                this.mJob.error(new Aapt2Exception("AAPT2 error: check logs for details"));
                            } else {
                                this.mJob.error(new Aapt2Exception(joiner.join(this.errors)));
                            }
                        }
                    } else {
                        this.mJob.finished();
                    }
                } else if (line.equalsIgnoreCase("Error")) {
                    this.mInError.set(true);
                } else if (this.mInError.get() || line.contains("error:")) {
                    this.errors.add(line);
                }
                this.mLogger.verbose("AAPT warning(%1$s), Job(%2$s): %3$s", new Object[]{this.mOwner.getProcess().hashCode(), this.mJob, line});
            }
        }

        private boolean handleOutput() {
            ProcessOutput output;
            if (this.processOutputHandler == null) {
                return false;
            }
            try (ProcessOutput ignored = output = this.processOutputHandler.createOutput();
                 PrintWriter err = new PrintWriter(output.getErrorOutput());){
                for (String error : this.errors) {
                    err.println(error);
                }
            }
            catch (IOException e) {
                this.mJob.error(new Aapt2Exception("Unexpected error parsing AAPT2 error output"));
                return false;
            }
            try {
                this.processOutputHandler.handleOutput(output);
            }
            catch (ProcessException e) {
                this.mJob.error(new Aapt2Exception("Unexpected error parsing AAPT2 error output"));
                return false;
            }
            this.mJob.error(new Aapt2Exception("AAPT2 error: check logs for details"));
            return true;
        }
    }

    private class ProcessOutputFacade
    implements GrabProcessOutput.IProcessOutput {
        NotifierProcessOutput notifier = null;

        private ProcessOutputFacade() {
        }

        synchronized void setNotifier(NotifierProcessOutput notifierProcessOutput) {
            if (this.notifier != null) {
                throw new RuntimeException("Notifier already set, threading issue");
            }
            this.notifier = notifierProcessOutput;
        }

        public String toString() {
            return "Facade for " + String.valueOf(AaptProcess.this.hashCode());
        }

        synchronized void reset() {
            this.notifier = null;
        }

        synchronized NotifierProcessOutput getNotifier() {
            return this.notifier;
        }

        public synchronized void out(String line) {
            if (Strings.isNullOrEmpty((String)line)) {
                return;
            }
            if (line.equals("Ready")) {
                AaptProcess.this.mReady.set(true);
                AaptProcess.this.mReadyLatch.signal();
                return;
            }
            if (line.equals("Exiting daemon")) {
                return;
            }
            NotifierProcessOutput delegate = this.getNotifier();
            if (delegate != null) {
                delegate.out(line);
            } else {
                AaptProcess.this.mLogger.error(null, "AAPT out(%1$s) : No Delegate set : lost message:%2$s", new Object[]{this.toString(), line});
            }
        }

        public synchronized void err(String line) {
            if (Strings.isNullOrEmpty((String)line)) {
                return;
            }
            NotifierProcessOutput delegate = this.getNotifier();
            if (delegate != null) {
                AaptProcess.this.mLogger.verbose("AAPT1 err(%1$s): %2$s -> %3$s", new Object[]{this.toString(), line, delegate.mJob});
                delegate.err(line);
            } else if (!AaptProcess.this.mReady.get()) {
                if (line.equals("ERROR: Unknown command 'm'")) {
                    throw new RuntimeException("Invalid AAPT version.\nFor AAPT1 version 21 or above is required.\nFor AAPT2 version " + BuildToolInfo.PathId.DAEMON_AAPT2.getMinRevision().toString() + " or above is required.");
                }
                AaptProcess.this.mLogger.verbose("AAPT err(%1$s): %2$s", new Object[]{this.toString(), line});
                AaptProcess.this.mLogger.error(null, "AAPT err(%1$s): %2$s", new Object[]{this.toString(), line});
            } else {
                AaptProcess.this.mLogger.error(null, "AAPT err(%1$s) : No Delegate set : lost message:%2$s", new Object[]{this.toString(), line});
            }
            if (!AaptProcess.this.mReadyLatch.isSignalled()) {
                AaptProcess.this.mReady.set(false);
                AaptProcess.this.mReadyLatch.signal();
            }
        }

        Process getProcess() {
            return AaptProcess.this.mProcess;
        }
    }

    public static class Builder {
        private final String mAaptLocation;
        private final ILogger mLogger;

        public Builder(String aaptPath, ILogger iLogger) {
            this.mAaptLocation = aaptPath;
            this.mLogger = iLogger;
        }

        public AaptProcess start() throws IOException, InterruptedException {
            String[] command = new String[]{this.mAaptLocation, "m"};
            this.mLogger.verbose("Trying to start %1$s", new Object[]{command[0]});
            Process process = new ProcessBuilder(command).start();
            AaptProcess aaptProcess = new AaptProcess(this.mAaptLocation, process, this.mLogger);
            this.mLogger.verbose("Started %1$d", new Object[]{aaptProcess.hashCode()});
            return aaptProcess;
        }
    }
}

