/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;

public class DexType
extends IndexedDexItem
implements PresortedComparable<DexType> {
    private static final int ROOT_LEVEL = 0;
    private static final int UNKNOWN_LEVEL = -1;
    private static final int INTERFACE_LEVEL = -2;
    private static final Set<DexType> NO_DIRECT_SUBTYPE = ImmutableSet.of();
    public final DexString descriptor;
    private String toStringCache = null;
    private int hierarchyLevel = -1;
    private Set<DexType> directSubtypes = NO_DIRECT_SUBTYPE;

    DexType(DexString descriptor) {
        assert (!descriptor.toString().contains("."));
        this.descriptor = descriptor;
    }

    @Override
    public int computeHashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexType) {
            return this.descriptor.equals(((DexType)other).descriptor);
        }
        return false;
    }

    private void ensureDirectSubTypeSet() {
        if (this.directSubtypes == NO_DIRECT_SUBTYPE) {
            this.directSubtypes = new TreeSet<DexType>(DexType::slowCompareTo);
        }
    }

    private void setLevel(int level) {
        if (level == this.hierarchyLevel) {
            return;
        }
        if (this.hierarchyLevel == -2) {
            assert (level == 1);
        } else if (level == -2) {
            assert (this.hierarchyLevel == 1 || this.hierarchyLevel == -1);
            this.hierarchyLevel = -2;
        } else {
            assert (this.hierarchyLevel == -1);
            this.hierarchyLevel = level;
        }
    }

    synchronized void addDirectSubtype(DexType type) {
        assert (this.hierarchyLevel != -1);
        this.ensureDirectSubTypeSet();
        this.directSubtypes.add(type);
        type.setLevel(this.hierarchyLevel + 1);
    }

    void tagAsSubtypeRoot() {
        this.setLevel(0);
    }

    void tagAsInteface() {
        this.setLevel(-2);
    }

    public boolean isInterface() {
        assert (this.isClassType() && this.hierarchyLevel != -1);
        return this.hierarchyLevel == -2;
    }

    synchronized void addInterfaceSubtype(DexType type) {
        this.setLevel(-2);
        this.ensureDirectSubTypeSet();
        this.directSubtypes.add(type);
    }

    static void clearSubtypeInformation(DexType type) {
        type.hierarchyLevel = -1;
        type.directSubtypes = NO_DIRECT_SUBTYPE;
    }

    public boolean isSubtypeOf(DexType other, AppInfo appInfo) {
        if (this == other) {
            return true;
        }
        if (this == appInfo.dexItemFactory.objectType) {
            return false;
        }
        if (other == appInfo.dexItemFactory.objectType) {
            return true;
        }
        if (this.hierarchyLevel == -2) {
            return this.isInterfaceSubtypeOf(this, other, appInfo);
        }
        if (other.hierarchyLevel == -2) {
            return other.directSubtypes.stream().anyMatch(subtype -> this.isSubtypeOf((DexType)subtype, appInfo));
        }
        return this.isSubtypeOfClass(other, appInfo);
    }

    private boolean isInterfaceSubtypeOf(DexType candidate, DexType other, AppInfo appInfo) {
        if (candidate == other || other == appInfo.dexItemFactory.objectType) {
            return true;
        }
        DexClass candidateHolder = appInfo.definitionFor(candidate);
        if (candidateHolder == null) {
            return false;
        }
        for (DexType iface : candidateHolder.interfaces.values) {
            assert (iface.hierarchyLevel == -2);
            if (!this.isInterfaceSubtypeOf(iface, other, appInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfClass(DexType other, AppInfo appInfo) {
        DexType self = this;
        if (other.hierarchyLevel == -1) {
            return false;
        }
        while (other.hierarchyLevel < self.hierarchyLevel) {
            DexClass holder = appInfo.definitionFor(self);
            assert (holder != null && !holder.isInterface());
            self = holder.superType;
        }
        return self == other;
    }

    public void forAllExtendsSubtypes(Consumer<DexType> f) {
        assert (this.hierarchyLevel != -1);
        if (this.hierarchyLevel == -2) {
            for (DexType subtype : this.directSubtypes) {
                if (subtype.hierarchyLevel != -2) continue;
                f.accept(subtype);
            }
        } else if (this.hierarchyLevel == 0) {
            for (DexType subtype : this.directSubtypes) {
                if (subtype.hierarchyLevel == -2) continue;
                f.accept(subtype);
            }
        } else {
            this.directSubtypes.forEach(f);
        }
    }

    public void forAllImplementsSubtypes(Consumer<DexType> f) {
        if (this.hierarchyLevel != -2) {
            return;
        }
        for (DexType subtype : this.directSubtypes) {
            if (subtype.hierarchyLevel == -2) continue;
            f.accept(subtype);
        }
    }

    public static void forAllInterfaces(DexItemFactory factory, Consumer<DexType> f) {
        DexType object = factory.objectType;
        assert (object.hierarchyLevel == 0);
        for (DexType subtype : object.directSubtypes) {
            if (!subtype.isInterface()) continue;
            f.accept(subtype);
        }
    }

    public boolean isSamePackage(DexType other) {
        return this.getPackageDescriptor().equals(other.getPackageDescriptor());
    }

    public String toDescriptorString() {
        return this.descriptor.toString();
    }

    @Override
    public String toSourceString() {
        if (this.toStringCache == null) {
            this.toStringCache = DexItemFactory.isInternalSentinel(this) ? this.descriptor.toString() : DescriptorUtils.descriptorToJavaType(this.toDescriptorString());
        }
        return this.toStringCache;
    }

    public char toShorty() {
        char c = (char)this.descriptor.content[0];
        return c == '[' ? (char)'L' : (char)c;
    }

    @Override
    public String toSmaliString() {
        return this.toDescriptorString();
    }

    public String toString() {
        return this.toSourceString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection collection) {
        if (collection.addType(this)) {
            collection.getRenamedDescriptor(this).collectIndexedItems(collection);
        }
    }

    @Override
    public void flushCachedValues() {
        super.flushCachedValues();
        this.toStringCache = null;
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public int compareTo(DexType other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexType other) {
        return this.descriptor.slowCompareTo(other.descriptor);
    }

    @Override
    public int slowCompareTo(DexType other, NamingLens namingLens) {
        DexString thisDescriptor = namingLens.lookupDescriptor(this);
        DexString otherDescriptor = namingLens.lookupDescriptor(other);
        return thisDescriptor.slowCompareTo(otherDescriptor);
    }

    @Override
    public int layeredCompareTo(DexType other, NamingLens namingLens) {
        DexString thisDescriptor = namingLens.lookupDescriptor(this);
        DexString otherDescriptor = namingLens.lookupDescriptor(other);
        return thisDescriptor.compareTo(otherDescriptor);
    }

    public boolean isPrimitiveType() {
        return this.isPrimitiveType((char)this.descriptor.content[0]);
    }

    private boolean isPrimitiveType(char c) {
        return c == 'Z' || c == 'B' || c == 'S' || c == 'C' || c == 'I' || c == 'F' || c == 'J' || c == 'D';
    }

    public boolean isVoidType() {
        return (char)this.descriptor.content[0] == 'V';
    }

    public boolean isBooleanType() {
        return this.descriptor.content[0] == 90;
    }

    public boolean isArrayType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == '[';
    }

    public boolean isClassType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == 'L';
    }

    public boolean isPrimitiveArrayType() {
        if (!this.isArrayType()) {
            return false;
        }
        return this.isPrimitiveType((char)this.descriptor.content[1]);
    }

    public int elementSizeForPrimitiveArrayType() {
        assert (this.isPrimitiveArrayType());
        switch (this.descriptor.content[1]) {
            case 66: 
            case 90: {
                return 1;
            }
            case 67: 
            case 83: {
                return 2;
            }
            case 70: 
            case 73: {
                return 4;
            }
            case 68: 
            case 74: {
                return 8;
            }
        }
        throw new Unreachable("Not array of primitives '" + this.descriptor + "'");
    }

    public int getNumberOfLeadingSquareBrackets() {
        int leadingSquareBrackets = 0;
        while (this.descriptor.content[leadingSquareBrackets] == 91) {
            ++leadingSquareBrackets;
        }
        return leadingSquareBrackets;
    }

    public DexType toBaseType(DexItemFactory dexItemFactory) {
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        if (leadingSquareBrackets == 0) {
            return this;
        }
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - leadingSquareBrackets, Arrays.copyOfRange(this.descriptor.content, leadingSquareBrackets, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    public DexType replaceBaseType(DexType newBase, DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        assert (!newBase.isArrayType());
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        byte[] content = new byte[newBase.descriptor.content.length + leadingSquareBrackets];
        Arrays.fill(content, 0, leadingSquareBrackets, (byte)91);
        System.arraycopy(newBase.descriptor.content, 0, content, leadingSquareBrackets, newBase.descriptor.content.length);
        DexString newDesc = dexItemFactory.createString(newBase.descriptor.size + leadingSquareBrackets, content);
        return dexItemFactory.createType(newDesc);
    }

    public DexType toArrayElementType(DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - 1, Arrays.copyOfRange(this.descriptor.content, 1, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    static boolean validateLevelsAreCorrect(Function<DexType, DexClass> definitions, DexItemFactory dexItemFactory) {
        Set<DexType> seenTypes = Sets.newIdentityHashSet();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        DexType objectType = dexItemFactory.objectType;
        worklist.add(objectType);
        while (!worklist.isEmpty()) {
            DexType next = (DexType)worklist.pop();
            DexClass nextHolder = definitions.apply(next);
            DexType superType = nextHolder == null ? (next == dexItemFactory.objectType ? null : dexItemFactory.objectType) : nextHolder.superType;
            assert (!seenTypes.contains(next));
            seenTypes.add(next);
            if (superType == null) {
                assert (next.hierarchyLevel == 0);
            } else {
                assert (superType.hierarchyLevel == next.hierarchyLevel - 1 || superType.hierarchyLevel == 0 && next.hierarchyLevel == -2);
                assert (superType.directSubtypes.contains(next));
            }
            if (next.hierarchyLevel != -2) {
                worklist.addAll(next.directSubtypes);
                continue;
            }
            if (nextHolder == null) continue;
            for (DexType iface : nextHolder.interfaces.values) {
                assert (iface.directSubtypes.contains(next));
                assert (iface.hierarchyLevel == -2);
            }
        }
        return true;
    }

    private String getPackageOrName(boolean packagePart) {
        assert (this.isClassType());
        String descriptor = this.toDescriptorString();
        int lastSeparator = descriptor.lastIndexOf(47);
        if (lastSeparator == -1) {
            return packagePart ? "" : descriptor.substring(1, descriptor.length() - 1);
        }
        return packagePart ? descriptor.substring(1, lastSeparator) : descriptor.substring(lastSeparator + 1, descriptor.length() - 1);
    }

    public DexType getSingleSubtype() {
        assert (this.hierarchyLevel != -1);
        if (this.directSubtypes.size() == 1) {
            return Iterables.getFirst(this.directSubtypes, null);
        }
        return null;
    }

    public String getPackageDescriptor() {
        return this.getPackageOrName(true);
    }

    public String getName() {
        if (this.isPrimitiveType()) {
            return this.toSourceString();
        }
        return this.getPackageOrName(false);
    }

    public String getInternalName() {
        assert (this.isClassType() || this.isArrayType());
        String descriptor = this.toDescriptorString();
        return this.isArrayType() ? descriptor : descriptor.substring(1, descriptor.length() - 1);
    }

    public boolean isImmediateSubtypeOf(DexType type) {
        assert (this.hierarchyLevel != -1);
        return type.directSubtypes.contains(this);
    }

    public DexType computeLeastUpperBound(AppInfoWithSubtyping appInfo, DexType other) {
        DexClass dexClass;
        DexType objectType = appInfo.dexItemFactory.objectType;
        if (this.isInterface() || other.isInterface()) {
            if (this.isSubtypeOf(other, appInfo)) {
                return other;
            }
            if (other.isSubtypeOf(this, appInfo)) {
                return this;
            }
            return objectType;
        }
        if (other.hierarchyLevel < this.hierarchyLevel) {
            return other.computeLeastUpperBound(appInfo, this);
        }
        while (other.hierarchyLevel > this.hierarchyLevel) {
            dexClass = appInfo.definitionFor(other);
            if (dexClass == null) {
                return objectType;
            }
            other = dexClass.superType;
        }
        DexType lub = this;
        while (other != lub) {
            dexClass = appInfo.definitionFor(other);
            if (dexClass == null) {
                return objectType;
            }
            other = dexClass.superType;
            dexClass = appInfo.definitionFor(lub);
            if (dexClass == null) {
                return objectType;
            }
            lub = dexClass.superType;
        }
        return lub;
    }
}

