/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FilteredClassPath {
    private final Path path;
    private final ImmutableList<String> pattern;

    public FilteredClassPath(Path path, ImmutableList<String> pattern) {
        this.path = path;
        this.pattern = pattern;
    }

    private FilteredClassPath(Path path) {
        this(path, ImmutableList.of());
    }

    public static FilteredClassPath unfiltered(File file) {
        return new FilteredClassPath(file.toPath());
    }

    public static FilteredClassPath unfiltered(Path path) {
        return new FilteredClassPath(path);
    }

    public static FilteredClassPath unfiltered(String path) {
        return new FilteredClassPath(Paths.get(path, new String[0]));
    }

    public Path getPath() {
        return this.path;
    }

    public boolean matchesFile(Path file) {
        if (this.isUnfiltered()) {
            return true;
        }
        boolean isNegated = false;
        for (String pattern : this.pattern) {
            isNegated = pattern.charAt(0) == '!';
            boolean matches = this.matchAgainstFileName(file.toString(), 0, pattern, isNegated ? 1 : 0);
            if (!matches) continue;
            return !isNegated;
        }
        return isNegated;
    }

    private boolean containsFileSeparator(String string) {
        return string.indexOf(File.separatorChar) != -1;
    }

    private boolean matchAgainstFileName(String fileName, int namePos, String pattern, int patternPos) {
        if (patternPos >= pattern.length()) {
            return namePos == fileName.length();
        }
        char currentPattern = pattern.charAt(patternPos);
        if (currentPattern == '*') {
            String remainingPattern;
            boolean includeFileSeparators;
            boolean bl = includeFileSeparators = pattern.length() > patternPos + 1 && pattern.charAt(patternPos + 1) == '*';
            if (includeFileSeparators) {
                ++patternPos;
            }
            if ((remainingPattern = pattern.substring(patternPos + 1)).indexOf(42) == -1) {
                int remaining = remainingPattern.length();
                if (namePos + remaining > fileName.length()) {
                    return false;
                }
                if (includeFileSeparators || !this.containsFileSeparator(fileName.substring(namePos, fileName.length() - remaining))) {
                    return this.matchAgainstFileName(fileName, fileName.length() - remaining, pattern, patternPos + 1);
                }
            } else {
                for (int i = namePos; i < fileName.length(); ++i) {
                    if (!includeFileSeparators && fileName.charAt(i) == File.separatorChar) {
                        return false;
                    }
                    if (!this.matchAgainstFileName(fileName, i, pattern, patternPos + 1)) continue;
                    return true;
                }
            }
        } else {
            if (namePos >= fileName.length()) {
                return false;
            }
            if (currentPattern == '?' || currentPattern == fileName.charAt(namePos)) {
                return this.matchAgainstFileName(fileName, namePos + 1, pattern, patternPos + 1);
            }
        }
        return false;
    }

    public boolean isUnfiltered() {
        return this.pattern.isEmpty();
    }

    public String toString() {
        if (this.isUnfiltered()) {
            return this.path.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.path);
        builder.append('(');
        boolean first = true;
        for (String pattern : this.pattern) {
            if (!first) {
                builder.append(',');
            }
            builder.append(pattern);
            first = false;
        }
        builder.append(')');
        return builder.toString();
    }
}

