/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.GenerateMainDexListCommand;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class GenerateMainDexList {
    private final Timing timing = new Timing("maindex");
    private final InternalOptions options;

    private GenerateMainDexList(InternalOptions options) {
        this.options = options;
    }

    private List<String> run(AndroidApp app, ExecutorService executor) throws IOException, ExecutionException {
        DirectMappedDexApplication application = new ApplicationReader(app, this.options, this.timing).read(executor).toDirect();
        AppInfoWithSubtyping appInfo = new AppInfoWithSubtyping(application);
        RootSetBuilder.RootSet mainDexRootSet = new RootSetBuilder(application, appInfo, this.options.mainDexKeepRules, this.options).run(executor);
        Set<DexType> mainDexBaseClasses = new Enqueuer(appInfo, this.options).traceMainDex(mainDexRootSet, this.timing);
        Set<DexType> mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
        List<String> result = mainDexClasses.stream().map(c -> c.toSourceString().replace('.', '/') + ".class").sorted().collect(Collectors.toList());
        if (this.options.mainDexListConsumer != null) {
            this.options.mainDexListConsumer.accept(String.join((CharSequence)"\n", result), this.options.reporter);
        }
        return result;
    }

    public static List<String> run(GenerateMainDexListCommand command) throws IOException, ExecutionException {
        ExecutorService executorService = ThreadUtils.getExecutorService(command.getInternalOptions());
        try {
            List<String> list = GenerateMainDexList.run(command, executorService);
            return list;
        }
        finally {
            executorService.shutdown();
        }
    }

    public static List<String> run(GenerateMainDexListCommand command, ExecutorService executor) throws IOException, ExecutionException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        return new GenerateMainDexList(options).run(app, executor);
    }

    public static void main(String[] args) throws IOException, ExecutionException, CompilationFailedException {
        GenerateMainDexListCommand.Builder builder = GenerateMainDexListCommand.parse(args);
        GenerateMainDexListCommand command = (GenerateMainDexListCommand)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(GenerateMainDexListCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("MainDexListGenerator v1.1.2-dev");
            return;
        }
        List<String> result = GenerateMainDexList.run(command);
        if (command.getMainDexListOutputPath() == null) {
            result.forEach(System.out::println);
        }
    }
}

