/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class DeadCodeRemover {
    public static void removeDeadCode(IRCode code, CodeRewriter codeRewriter, InternalOptions options) {
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        int color = code.reserveMarkingColor();
        worklist.addAll(code.blocks);
        BasicBlock block = (BasicBlock)worklist.poll();
        while (block != null) {
            if (!block.isMarked(color)) {
                DeadCodeRemover.removeDeadInstructions(worklist, code, block, options, color);
                DeadCodeRemover.removeDeadPhis(worklist, block, options, color);
                DeadCodeRemover.removeUnneededCatchHandlers(worklist, block, code, color);
            }
            block = (BasicBlock)worklist.poll();
        }
        code.removeMarkedBlocks(color);
        code.returnMarkingColor(color);
        assert (code.isConsistentSSA());
        codeRewriter.rewriteMoveResult(code);
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Value value, int color) {
        BasicBlock block = value.isPhi() ? value.asPhi().getBlock() : value.definition.getBlock();
        if (!block.isMarked(color)) {
            worklist.add(block);
        }
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Instruction instruction, int color) {
        for (Value inValue : instruction.inValues()) {
            DeadCodeRemover.updateWorklist(worklist, inValue, color);
        }
        for (Value debugValue : instruction.getDebugValues()) {
            DeadCodeRemover.updateWorklist(worklist, debugValue, color);
        }
    }

    private static void removeDeadPhis(Queue<BasicBlock> worklist, BasicBlock block, InternalOptions options, int color) {
        Iterator<Phi> phiIt = block.getPhis().iterator();
        while (phiIt.hasNext()) {
            Phi phi = phiIt.next();
            if (!phi.isDead(options)) continue;
            phiIt.remove();
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
                DeadCodeRemover.updateWorklist(worklist, operand, color);
            }
        }
    }

    private static void removeDeadInstructions(Queue<BasicBlock> worklist, IRCode code, BasicBlock block, InternalOptions options, int color) {
        InstructionListIterator iterator = block.listIterator(block.getInstructions().size());
        while (iterator.hasPrevious()) {
            Instruction current = (Instruction)iterator.previous();
            if (current.isInvoke() && current.outValue() != null && !current.outValue().isUsed()) {
                current.setOutValue(null);
            }
            if (!current.canBeDeadCode(code, options)) continue;
            Value outValue = current.outValue();
            assert (outValue != null);
            if (!outValue.isDead(options)) continue;
            DeadCodeRemover.updateWorklist(worklist, current, color);
            outValue.clearUsers();
            iterator.removeOrReplaceByDebugLocalRead();
        }
    }

    private static void removeUnneededCatchHandlers(Queue<BasicBlock> worklist, BasicBlock block, IRCode code, int color) {
        if (block.hasCatchHandlers() && !block.canThrow()) {
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            for (BasicBlock target : handlers.getUniqueTargets()) {
                DominatorTree dominatorTree = new DominatorTree(code);
                for (BasicBlock unlinked : block.unlink(target, dominatorTree)) {
                    if (unlinked.isMarked(color)) continue;
                    InstructionIterator iterator = unlinked.iterator();
                    while (iterator.hasNext()) {
                        DeadCodeRemover.updateWorklist(worklist, (Instruction)iterator.next(), color);
                    }
                    unlinked.mark(color);
                }
            }
        }
    }
}

