/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt;

import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;

public abstract class AbstractAapt
implements Aapt {
    @Override
    public final void link(AaptPackageConfig config, ILogger logger) throws AaptException, ExecutionException, InterruptedException {
        AbstractAapt.validatePackageConfig(config);
        this.makeValidatedPackage(config).get();
    }

    protected abstract ListenableFuture<Void> makeValidatedPackage(AaptPackageConfig var1) throws AaptException;

    private static void validatePackageConfig(AaptPackageConfig packageConfig) throws AaptException {
        if (packageConfig.getSymbolOutputDir() == null && packageConfig.getSourceOutputDir() == null || packageConfig.getLibrarySymbolTableFiles().isEmpty()) {
            // empty if block
        }
        if (!packageConfig.getDependentFeatures().isEmpty() && packageConfig.getPackageId() == null) {
            throw new AaptException("A dependent feature was defined but no package ID was set. You are probably missing a feature dependency in the base feature.");
        }
    }
}

