/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.R8;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.FeatureClassMapping;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class DexSplitterHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(D8Command command, String featureSplitMapping, String outputArchive) throws IOException, CompilationException, ExecutionException {
        InternalOptions options = command.getInternalOptions();
        options.enableDesugaring = false;
        options.enableMainDexListCheck = false;
        options.minimalMainDex = false;
        options.skipMinification = true;
        options.inlineAccessors = false;
        options.outline.enabled = false;
        ExecutorService executor = ThreadUtils.getExecutorService(-1);
        try {
            try {
                Timing timing = new Timing("DexSplitter");
                DexApplication app = new ApplicationReader(command.getInputApp(), options, timing).read(null, executor);
                FeatureClassMapping featureClassMapping = new FeatureClassMapping(Paths.get(featureSplitMapping, new String[0]));
                Map<String, DexApplication.Builder> applications = DexSplitterHelper.getDistribution(app, featureClassMapping);
                for (Map.Entry<String, DexApplication.Builder> entry : applications.entrySet()) {
                    DexApplication featureApp = entry.getValue().build();
                    featureApp.dexItemFactory.resetSortedIndices();
                    assert (!options.hasMethodsFilter());
                    AppInfo appInfo = new AppInfo(featureApp);
                    featureApp = D8.optimize(featureApp, appInfo, options, timing, executor);
                    DexIndexedConsumer.ArchiveConsumer consumer = new DexIndexedConsumer.ArchiveConsumer(Paths.get(outputArchive + "." + entry.getKey() + ".zip", new String[0]));
                    try {
                        new ApplicationWriter(featureApp, options, D8.getMarker(options), null, NamingLens.getIdentityLens(), null, null, consumer).write(executor);
                        options.printWarnings();
                    }
                    finally {
                        consumer.finished(options.reporter);
                    }
                }
            }
            catch (ExecutionException e) {
                R8.unwrapExecutionException(e);
                throw new AssertionError((Object)e);
            }
            catch (FeatureClassMapping.FeatureMappingException e) {
                options.reporter.error(e.getMessage());
            }
            finally {
                options.signalFinishedToProgramConsumer();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private static Map<String, DexApplication.Builder> getDistribution(DexApplication app, FeatureClassMapping featureClassMapping) throws FeatureClassMapping.FeatureMappingException {
        HashMap<String, DexApplication.Builder> applications = new HashMap<String, DexApplication.Builder>();
        for (DexProgramClass clazz : app.classes()) {
            String feature = featureClassMapping.featureForClass(clazz.toString());
            DexApplication.Builder featureApplication = (DexApplication.Builder)applications.get(feature);
            if (featureApplication == null) {
                featureApplication = DexApplication.builder(app.dexItemFactory, app.timing);
                applications.put(feature, featureApplication);
            }
            featureApplication.addProgramClass(clazz);
        }
        return applications;
    }
}

