/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.code.NewArray;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.function.Function;

public class NewArrayEmpty
extends Instruction {
    public final DexType type;

    public NewArrayEmpty(Value dest, Value size, DexType type) {
        super(dest, size);
        dest.markNeverNull();
        this.type = type;
    }

    public Value dest() {
        return this.outValue;
    }

    public Value size() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int size = builder.allocatedRegister(this.size(), this.getNumber());
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new NewArray(dest, size, this.type));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asNewArrayEmpty().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.slowCompareTo(other.asNewArrayEmpty().type);
    }

    @Override
    public boolean isNewArrayEmpty() {
        return true;
    }

    @Override
    public NewArrayEmpty asNewArrayEmpty() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.classIsVisible(invocationContext, this.type, info);
    }

    @Override
    public boolean hasInvariantVerificationType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        assert (this.type.isArrayType());
        builder.add(new CfNewArray(this.type));
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return TypeLatticeElement.newArray(this.type, false);
    }
}

