/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class FeatureClassMapping {
    HashMap<String, String> parsedRules = new HashMap();
    HashSet<FeaturePredicate> mappings = new HashSet();
    Path mappingFile;
    static final String COMMENT = "#";
    static final String SEPARATOR = ":";

    public FeatureClassMapping(Path file) throws IOException, FeatureMappingException {
        this(FileUtils.readAllLines(file));
        this.mappingFile = file;
    }

    FeatureClassMapping(List<String> lines) throws FeatureMappingException {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.parseAndAdd(line, i);
        }
    }

    public String featureForClass(String clazz) throws FeatureMappingException {
        FeaturePredicate bestMatch = null;
        for (FeaturePredicate mapping : this.mappings) {
            if (!mapping.match(clazz) || bestMatch != null && bestMatch.predicate.length() >= mapping.predicate.length()) continue;
            bestMatch = mapping;
        }
        if (bestMatch == null) {
            throw new FeatureMappingException("Class: " + clazz + " is not mapped to any feature");
        }
        return bestMatch.feature;
    }

    private void parseAndAdd(String line, int lineNumber) throws FeatureMappingException {
        String[] values;
        if (line.startsWith(COMMENT)) {
            return;
        }
        if (line.isEmpty()) {
            return;
        }
        if (!line.contains(SEPARATOR)) {
            this.error("Mapping lines must contain a :", lineNumber);
        }
        if ((values = line.split(SEPARATOR)).length != 2) {
            this.error("Mapping lines can only contain one :", lineNumber);
        }
        if (this.parsedRules.containsKey(values[0])) {
            if (!this.parsedRules.get(values[0]).equals(values[1])) {
                this.error("Redefinition of predicate not allowed", lineNumber);
            }
            return;
        }
        this.parsedRules.put(values[0], values[1]);
        FeaturePredicate featurePredicate = new FeaturePredicate(values[0], values[1]);
        this.mappings.add(featurePredicate);
    }

    private void error(String error, int line) throws FeatureMappingException {
        throw new FeatureMappingException("Invalid mappings specification: " + error + "\n in file " + this.mappingFile + SEPARATOR + line);
    }

    private static class FeaturePredicate {
        final String predicate;
        final String feature;
        final boolean isWildcard;

        FeaturePredicate(String predicate, String feature) throws FeatureMappingException {
            this.isWildcard = predicate.endsWith(".*");
            this.predicate = this.isWildcard ? predicate.substring(0, predicate.length() - 3) : predicate;
            this.validateIdentifiers(this.predicate.split("\\."));
            this.feature = feature;
        }

        private void validateIdentifiers(String[] names) throws FeatureMappingException {
            Pattern p = Pattern.compile("[A-Za-z_][A-Za-z0-9_$]*");
            for (String name : names) {
                if (p.matcher(name).matches()) continue;
                throw new FeatureMappingException(name + " is not a valid identifier");
            }
        }

        boolean match(String className) {
            if (this.isWildcard) {
                return className.startsWith(this.predicate);
            }
            return className.startsWith(this.predicate);
        }
    }

    public static class FeatureMappingException
    extends Exception {
        FeatureMappingException(String message) {
            super(message);
        }
    }
}

