/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collection;
import java.util.List;

public abstract class InvokeMethod
extends Invoke {
    private final DexMethod method;

    public InvokeMethod(DexMethod target, Value result, List<Value> arguments) {
        super(result, arguments);
        this.method = target;
    }

    @Override
    public DexType getReturnType() {
        return this.method.proto.returnType;
    }

    public DexMethod getInvokedMethod() {
        return this.method;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return this.method == other.asInvokeMethod().getInvokedMethod();
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.getInvokedMethod().slowCompareTo(other.asInvokeMethod().getInvokedMethod());
    }

    @Override
    public String toString() {
        return super.toString() + "; method: " + this.method.toSourceString();
    }

    @Override
    public boolean isInvokeMethod() {
        return true;
    }

    @Override
    public InvokeMethod asInvokeMethod() {
        return this;
    }

    public abstract DexEncodedMethod lookupSingleTarget(Enqueuer.AppInfoWithLiveness var1, DexType var2);

    public abstract Collection<DexEncodedMethod> lookupTargets(AppInfoWithSubtyping var1, DexType var2);

    public DexEncodedMethod computeSingleTarget(Enqueuer.AppInfoWithLiveness appInfo) {
        return this.computeSingleTarget(appInfo, TypeAnalysis.getDefaultTypeEnvironment(), null);
    }

    public DexEncodedMethod computeSingleTarget(Enqueuer.AppInfoWithLiveness appInfo, TypeEnvironment typeEnvironment, DexType invocationContext) {
        return this.lookupSingleTarget(appInfo, appInfo.dexItemFactory.objectType);
    }

    @Override
    public abstract Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness var1, DexType var2);

    protected Inliner.Constraint inliningConstraintForSinlgeTargetInvoke(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        DexType methodHolder;
        DexClass methodClass;
        if (this.method.holder.isArrayType()) {
            return Inliner.Constraint.ALWAYS;
        }
        DexEncodedMethod target = this.lookupSingleTarget(info, invocationContext);
        if (target != null && (methodClass = info.definitionFor(methodHolder = target.method.holder)) != null) {
            Inliner.Constraint methodConstraint = Inliner.Constraint.deriveConstraint(invocationContext, methodHolder, target.accessFlags, info);
            Inliner.Constraint classConstraint = Inliner.Constraint.deriveConstraint(invocationContext, methodHolder, methodClass.accessFlags, info);
            return Inliner.Constraint.min(methodConstraint, classConstraint);
        }
        return Inliner.Constraint.NEVER;
    }

    protected Inliner.Constraint inliningConstraintForVirtualInvoke(AppInfoWithSubtyping info, DexType invocationContext) {
        if (this.method.holder.isArrayType()) {
            return Inliner.Constraint.ALWAYS;
        }
        Collection<DexEncodedMethod> targets = this.lookupTargets(info, invocationContext);
        if (targets == null || targets.isEmpty()) {
            return Inliner.Constraint.NEVER;
        }
        Inliner.Constraint result = Inliner.Constraint.ALWAYS;
        AppInfo.ResolutionResult resolutionResult = info.resolveMethod(this.method.holder, this.method);
        DexEncodedMethod resolutionTarget = resolutionResult.asResultOfResolve();
        if (resolutionTarget == null) {
            return Inliner.Constraint.NEVER;
        }
        DexType methodHolder = resolutionTarget.method.holder;
        DexClass methodClass = info.definitionFor(methodHolder);
        assert (methodClass != null);
        Inliner.Constraint methodConstraint = Inliner.Constraint.deriveConstraint(invocationContext, methodHolder, resolutionTarget.accessFlags, info);
        result = Inliner.Constraint.min(result, methodConstraint);
        Inliner.Constraint classConstraint = Inliner.Constraint.deriveConstraint(invocationContext, methodHolder, methodClass.accessFlags, info);
        if ((result = Inliner.Constraint.min(result, classConstraint)) == Inliner.Constraint.NEVER) {
            return result;
        }
        for (DexEncodedMethod target : targets) {
            methodHolder = target.method.holder;
            methodClass = info.definitionFor(methodHolder);
            assert (methodClass != null);
            methodConstraint = Inliner.Constraint.deriveConstraint(invocationContext, methodHolder, target.accessFlags, info);
            if ((result = Inliner.Constraint.min(result, methodConstraint)) != Inliner.Constraint.NEVER) continue;
            return result;
        }
        return result;
    }

    public abstract Inliner.InlineAction computeInlining(InliningOracle var1, DexType var2);

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        if (this.method.proto.returnType.isVoidType()) {
            return;
        }
        if (this.outValue == null) {
            helper.popOutType(this.method.proto.returnType, this, it);
        } else {
            assert (this.outValue.isUsed());
            helper.storeOutValue(this, it);
        }
    }

    @Override
    public boolean hasInvariantVerificationType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.getInvokedMethod().proto.returnType;
    }
}

