/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kstyle;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupClassBuilder;
import com.android.tools.r8.ir.optimize.lambda.kstyle.ClassInitializerSourceCode;
import com.android.tools.r8.ir.optimize.lambda.kstyle.InstanceInitializerSourceCode;
import com.android.tools.r8.ir.optimize.lambda.kstyle.KStyleConstants;
import com.android.tools.r8.ir.optimize.lambda.kstyle.KStyleLambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.kstyle.KStyleLambdaGroupId;
import com.android.tools.r8.ir.optimize.lambda.kstyle.VirtualMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class KStyleLambdaGroupClassBuilder
extends LambdaGroupClassBuilder<KStyleLambdaGroup>
implements KStyleConstants {
    private final KStyleLambdaGroupId id;

    KStyleLambdaGroupClassBuilder(DexItemFactory factory, KStyleLambdaGroup group, String origin) {
        super(group, factory, origin);
        this.id = group.id();
    }

    @Override
    protected DexType getSuperClassType() {
        return this.factory.kotlin.functional.lambdaType;
    }

    @Override
    protected ClassAccessFlags buildAccessFlags() {
        return PUBLIC_LAMBDA_CLASS_FLAGS;
    }

    @Override
    protected EnclosingMethodAttribute buildEnclosingMethodAttribute() {
        return this.id.enclosing;
    }

    @Override
    protected List<InnerClassAttribute> buildInnerClasses() {
        return this.id.innerClassAccess == -1 ? Collections.emptyList() : Lists.newArrayList(new InnerClassAttribute(this.id.innerClassAccess, ((KStyleLambdaGroup)this.group).getGroupClassType(), null, null));
    }

    @Override
    protected DexAnnotationSet buildAnnotations() {
        String signature = this.id.signature;
        return signature == null ? DexAnnotationSet.empty() : new DexAnnotationSet(new DexAnnotation[]{DexAnnotation.createSignatureAnnotation(signature, this.factory)});
    }

    @Override
    protected DexEncodedMethod[] buildVirtualMethods() {
        Map<DexString, Map<DexProto, List<DexEncodedMethod>>> methods = this.collectVirtualMethods();
        ArrayList<DexEncodedMethod> result = new ArrayList<DexEncodedMethod>();
        for (Map.Entry<DexString, Map<DexProto, List<DexEncodedMethod>>> upper : methods.entrySet()) {
            DexString methodName = upper.getKey();
            for (Map.Entry<DexProto, List<DexEncodedMethod>> inner : upper.getValue().entrySet()) {
                DexProto methodProto = inner.getKey();
                List<DexEncodedMethod> implMethods = inner.getValue();
                boolean isMainMethod = this.id.mainMethodName == methodName && this.id.mainMethodProto == methodProto;
                MethodAccessFlags accessFlags = MAIN_METHOD_FLAGS.copy();
                for (DexEncodedMethod implMethod : implMethods) {
                    if (implMethod == null) continue;
                    implMethod.markForceInline();
                }
                result.add(new DexEncodedMethod(this.factory.createMethod(((KStyleLambdaGroup)this.group).getGroupClassType(), methodProto, methodName), accessFlags, isMainMethod ? this.id.mainMethodAnnotations : DexAnnotationSet.empty(), isMainMethod ? this.id.mainMethodParamAnnotations : DexAnnotationSetRefList.empty(), new SynthesizedCode(new VirtualMethodSourceCode(this.factory, ((KStyleLambdaGroup)this.group).getGroupClassType(), methodProto, ((KStyleLambdaGroup)this.group).getLambdaIdField(this.factory), implMethods))));
            }
        }
        return result.toArray(new DexEncodedMethod[result.size()]);
    }

    private Map<DexString, Map<DexProto, List<DexEncodedMethod>>> collectVirtualMethods() {
        LinkedHashMap<DexString, Map<DexProto, List<DexEncodedMethod>>> methods = new LinkedHashMap<DexString, Map<DexProto, List<DexEncodedMethod>>>();
        assert (this.lambdaIdsOrdered());
        for (LambdaGroup.LambdaInfo lambda2 : this.lambdas) {
            for (DexEncodedMethod method : lambda2.clazz.virtualMethods()) {
                List list = methods.computeIfAbsent(method.method.name, k -> new LinkedHashMap()).computeIfAbsent(method.method.proto, k -> Lists.newArrayList(Collections.nCopies(this.lambdas.size(), null)));
                assert (list.get(lambda2.id) == null);
                list.set(lambda2.id, method);
            }
        }
        return methods;
    }

    private boolean lambdaIdsOrdered() {
        for (int i = 0; i < this.lambdas.size(); ++i) {
            assert (((LambdaGroup.LambdaInfo)this.lambdas.get((int)i)).id == i);
        }
        return true;
    }

    @Override
    protected DexEncodedMethod[] buildDirectMethods() {
        boolean statelessLambda = ((KStyleLambdaGroup)this.group).isStateless();
        DexType groupClassType = ((KStyleLambdaGroup)this.group).getGroupClassType();
        DexEncodedMethod[] result = new DexEncodedMethod[statelessLambda ? 2 : 1];
        DexProto initializerProto = ((KStyleLambdaGroup)this.group).createConstructorProto(this.factory);
        result[0] = new DexEncodedMethod(this.factory.createMethod(groupClassType, initializerProto, this.factory.constructorMethodName), CONSTRUCTOR_FLAGS_RELAXED, DexAnnotationSet.empty(), DexAnnotationSetRefList.empty(), new SynthesizedCode(new InstanceInitializerSourceCode(this.factory, groupClassType, ((KStyleLambdaGroup)this.group).getLambdaIdField(this.factory), id -> ((KStyleLambdaGroup)this.group).getCaptureField(this.factory, id), initializerProto, this.id.mainMethodProto.parameters.size())));
        if (statelessLambda) {
            result[1] = new DexEncodedMethod(this.factory.createMethod(groupClassType, this.factory.createProto(this.factory.voidType, new DexType[0]), this.factory.classConstructorMethodName), CLASS_INITIALIZER_FLAGS, DexAnnotationSet.empty(), DexAnnotationSetRefList.empty(), new SynthesizedCode(new ClassInitializerSourceCode(this.factory, groupClassType, this.lambdas.size(), id -> ((KStyleLambdaGroup)this.group).getSingletonInstanceField(this.factory, id))));
        }
        return result;
    }

    @Override
    protected DexEncodedField[] buildInstanceFields() {
        String capture = this.id.capture;
        int size = capture.length();
        DexEncodedField[] result = new DexEncodedField[1 + size];
        result[0] = new DexEncodedField(((KStyleLambdaGroup)this.group).getLambdaIdField(this.factory), CAPTURE_FIELD_FLAGS_RELAXED, DexAnnotationSet.empty(), null);
        for (int id = 0; id < size; ++id) {
            result[id + 1] = new DexEncodedField(((KStyleLambdaGroup)this.group).getCaptureField(this.factory, id), CAPTURE_FIELD_FLAGS_RELAXED, DexAnnotationSet.empty(), null);
        }
        return result;
    }

    @Override
    protected DexEncodedField[] buildStaticFields() {
        if (!((KStyleLambdaGroup)this.group).isStateless()) {
            return DexEncodedField.EMPTY_ARRAY;
        }
        int size = this.lambdas.size();
        DexEncodedField[] result = new DexEncodedField[size];
        for (int id = 0; id < size; ++id) {
            result[id] = new DexEncodedField(((KStyleLambdaGroup)this.group).getSingletonInstanceField(this.factory, id), SINGLETON_FIELD_FLAGS, DexAnnotationSet.empty(), DexValue.DexValueNull.NULL);
        }
        return result;
    }

    @Override
    protected DexTypeList buildInterfaces() {
        return new DexTypeList(new DexType[]{this.id.iface});
    }
}

