/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kstyle;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.optimize.lambda.CaptureSignature;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;
import com.android.tools.r8.ir.optimize.lambda.kstyle.KStyleConstants;
import com.android.tools.r8.ir.optimize.lambda.kstyle.KStyleLambdaGroupId;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;

public final class KStyleLambdaGroupIdFactory
implements KStyleConstants {
    private KStyleLambdaGroupIdFactory() {
    }

    public static LambdaGroupId create(Kotlin kotlin, DexClass lambda2, InternalOptions options) throws LambdaGroup.LambdaStructureError {
        boolean accessRelaxed = options.proguardConfiguration.isAccessModificationAllowed();
        KStyleLambdaGroupIdFactory.checkAccessFlags((String)"class access flags", (AccessFlags)lambda2.accessFlags, (AccessFlags[])new ClassAccessFlags[]{PUBLIC_LAMBDA_CLASS_FLAGS, LAMBDA_CLASS_FLAGS});
        KStyleLambdaGroupIdFactory.validateStaticFields(kotlin, lambda2);
        String captureSignature = KStyleLambdaGroupIdFactory.validateInstanceFields(lambda2, accessRelaxed);
        KStyleLambdaGroupIdFactory.validateDirectMethods(lambda2);
        DexEncodedMethod mainMethod = KStyleLambdaGroupIdFactory.validateVirtualMethods(lambda2);
        DexType iface = KStyleLambdaGroupIdFactory.validateInterfaces(kotlin, lambda2);
        String genericSignature = KStyleLambdaGroupIdFactory.validateAnnotations(kotlin, lambda2);
        InnerClassAttribute innerClass = KStyleLambdaGroupIdFactory.validateInnerClasses(lambda2);
        return new KStyleLambdaGroupId(captureSignature, iface, accessRelaxed ? "" : lambda2.type.getPackageDescriptor(), genericSignature, mainMethod, innerClass, lambda2.getEnclosingMethod());
    }

    private static DexEncodedMethod validateVirtualMethods(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        DexEncodedMethod mainMethod = null;
        for (DexEncodedMethod method : lambda2.virtualMethods()) {
            if (method.accessFlags.equals(MAIN_METHOD_FLAGS)) {
                if (mainMethod != null) {
                    throw new LambdaGroup.LambdaStructureError("more than one main method found");
                }
                mainMethod = method;
                continue;
            }
            KStyleLambdaGroupIdFactory.checkAccessFlags((String)"unexpected virtual method access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{BRIDGE_METHOD_FLAGS, BRIDGE_METHOD_FLAGS_FIXED});
            KStyleLambdaGroupIdFactory.checkDirectMethodAnnotations(method);
        }
        if (mainMethod == null) {
            throw new LambdaGroup.LambdaStructureError("no main method found");
        }
        return mainMethod;
    }

    private static InnerClassAttribute validateInnerClasses(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        List<InnerClassAttribute> innerClasses = lambda2.getInnerClasses();
        InnerClassAttribute innerClass = null;
        if (innerClasses != null) {
            for (InnerClassAttribute inner : innerClasses) {
                if (inner.getInner() != lambda2.type) continue;
                innerClass = inner;
                if (!innerClass.isAnonymous()) {
                    throw new LambdaGroup.LambdaStructureError("is not anonymous");
                }
                return innerClass;
            }
        }
        return null;
    }

    private static String validateAnnotations(Kotlin kotlin, DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        String signature = null;
        if (!lambda2.annotations.isEmpty()) {
            for (DexAnnotation annotation : lambda2.annotations.annotations) {
                if (DexAnnotation.isSignatureAnnotation(annotation, kotlin.factory)) {
                    signature = DexAnnotation.getSignature(annotation);
                    continue;
                }
                if (annotation.annotation.type == kotlin.metadata.kotlinMetadataType) continue;
                throw new LambdaGroup.LambdaStructureError("unexpected annotation: " + annotation.annotation.type.toSourceString());
            }
        }
        return signature;
    }

    private static void validateStaticFields(Kotlin kotlin, DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        DexEncodedField[] staticFields = lambda2.staticFields();
        if (staticFields.length == 1) {
            DexEncodedField field = staticFields[0];
            if (!(field.field.name == kotlin.functional.kotlinStyleLambdaInstanceName && field.field.type == lambda2.type && field.accessFlags.isPublic() && field.accessFlags.isFinal() && field.accessFlags.isStatic())) {
                throw new LambdaGroup.LambdaStructureError("unexpected static field " + field.toSourceString());
            }
            if (lambda2.instanceFields().length > 0) {
                throw new LambdaGroup.LambdaStructureError("has instance fields along with INSTANCE");
            }
            KStyleLambdaGroupIdFactory.checkAccessFlags((String)"static field access flags", (AccessFlags)field.accessFlags, (AccessFlags[])new FieldAccessFlags[]{SINGLETON_FIELD_FLAGS});
            KStyleLambdaGroupIdFactory.checkFieldAnnotations(field);
        } else {
            if (staticFields.length > 1) {
                throw new LambdaGroup.LambdaStructureError("only one static field max expected, found " + staticFields.length);
            }
            if (lambda2.instanceFields().length == 0) {
                throw new LambdaGroup.LambdaStructureError("stateless lambda without INSTANCE field");
            }
        }
    }

    private static DexType validateInterfaces(Kotlin kotlin, DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        if (lambda2.interfaces.size() == 0) {
            throw new LambdaGroup.LambdaStructureError("does not implement any interfaces");
        }
        if (lambda2.interfaces.size() > 1) {
            throw new LambdaGroup.LambdaStructureError("implements more than one interface: " + lambda2.interfaces.size());
        }
        DexType iface = lambda2.interfaces.values[0];
        if (!kotlin.functional.isFunctionInterface(iface)) {
            throw new LambdaGroup.LambdaStructureError("implements " + iface.toSourceString() + " instead of kotlin functional interface.");
        }
        return iface;
    }

    private static String validateInstanceFields(DexClass lambda2, boolean accessRelaxed) throws LambdaGroup.LambdaStructureError {
        DexEncodedField[] instanceFields;
        for (DexEncodedField field : instanceFields = lambda2.instanceFields()) {
            KStyleLambdaGroupIdFactory.checkAccessFlags((String)"capture field access flags", (AccessFlags)field.accessFlags, (AccessFlags[])new FieldAccessFlags[]{accessRelaxed ? CAPTURE_FIELD_FLAGS_RELAXED : CAPTURE_FIELD_FLAGS});
            KStyleLambdaGroupIdFactory.checkFieldAnnotations(field);
        }
        return CaptureSignature.getCaptureSignature(instanceFields);
    }

    private static void validateDirectMethods(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        DexEncodedMethod[] directMethods;
        for (DexEncodedMethod method : directMethods = lambda2.directMethods()) {
            if (method.isClassInitializer()) {
                if (lambda2.staticFields().length != 1) {
                    throw new LambdaGroup.LambdaStructureError("has static initializer, but no singleton field");
                }
                KStyleLambdaGroupIdFactory.checkAccessFlags((String)"unexpected static initializer access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{CLASS_INITIALIZER_FLAGS});
                KStyleLambdaGroupIdFactory.checkDirectMethodAnnotations(method);
                continue;
            }
            if (method.isStaticMethod()) {
                throw new LambdaGroup.LambdaStructureError("unexpected static method: " + method.method.toSourceString());
            }
            if (method.isInstanceInitializer()) {
                DexType[] parameters = method.method.proto.parameters.values;
                DexEncodedField[] instanceFields = lambda2.instanceFields();
                if (parameters.length != instanceFields.length) {
                    throw new LambdaGroup.LambdaStructureError("constructor parameters don't match captured values.");
                }
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i] == instanceFields[i].field.type) continue;
                    throw new LambdaGroup.LambdaStructureError("constructor parameters don't match captured values.");
                }
                KStyleLambdaGroupIdFactory.checkAccessFlags((String)"unexpected constructor access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{CONSTRUCTOR_FLAGS, CONSTRUCTOR_FLAGS_RELAXED});
                KStyleLambdaGroupIdFactory.checkDirectMethodAnnotations(method);
                continue;
            }
            throw new Unreachable();
        }
    }

    private static void checkDirectMethodAnnotations(DexEncodedMethod method) throws LambdaGroup.LambdaStructureError {
        if (!method.annotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected method annotations [" + method.annotations.toSmaliString() + "] on " + method.method.toSourceString());
        }
        if (!method.parameterAnnotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected method parameters annotations [" + method.annotations.toSmaliString() + "] on " + method.method.toSourceString());
        }
    }

    private static void checkFieldAnnotations(DexEncodedField field) throws LambdaGroup.LambdaStructureError {
        if (!field.annotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected field annotations [" + field.annotations.toSmaliString() + "] on " + field.field.toSourceString());
        }
    }

    @SafeVarargs
    private static <T extends AccessFlags> void checkAccessFlags(String message, T actual, T ... expected) throws LambdaGroup.LambdaStructureError {
        for (T flag : expected) {
            if (!((AccessFlags)flag).equals(actual)) continue;
            return;
        }
        throw new LambdaGroup.LambdaStructureError(message);
    }
}

