/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.it.unimi.dsi.fastutil.longs;

import com.android.tools.r8.it.unimi.dsi.fastutil.HashCommon;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.AbstractLong2ShortFunction;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.Long2ShortMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.LongIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.LongSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.shorts.ShortCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractLong2ShortMap
extends AbstractLong2ShortFunction
implements Long2ShortMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractLong2ShortMap() {
    }

    @Override
    public boolean containsValue(short v) {
        return this.values().contains(v);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object ov) {
        if (ov == null) {
            return false;
        }
        return this.containsValue((Short)ov);
    }

    @Override
    public boolean containsKey(long k) {
        ObjectIterator<Long2ShortMap.Entry> i = this.long2ShortEntrySet().iterator();
        while (i.hasNext()) {
            if (((Long2ShortMap.Entry)i.next()).getLongKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Short> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Long, ? extends Short>> i = m.entrySet().iterator();
        if (m instanceof Long2ShortMap) {
            while (n-- != 0) {
                Long2ShortMap.Entry e = (Long2ShortMap.Entry)i.next();
                this.put(e.getLongKey(), e.getShortValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Long, ? extends Short> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            @Override
            public boolean contains(long k) {
                return AbstractLong2ShortMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractLong2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2ShortMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new AbstractLongIterator(){
                    final ObjectIterator<Map.Entry<Long, Short>> i;
                    {
                        this.i = AbstractLong2ShortMap.this.entrySet().iterator();
                    }

                    @Override
                    public long nextLong() {
                        return ((Long2ShortMap.Entry)this.i.next()).getLongKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            @Override
            public boolean contains(short k) {
                return AbstractLong2ShortMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractLong2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2ShortMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new AbstractShortIterator(){
                    final ObjectIterator<Map.Entry<Long, Short>> i;
                    {
                        this.i = AbstractLong2ShortMap.this.entrySet().iterator();
                    }

                    @Override
                    @Deprecated
                    public short nextShort() {
                        return ((Long2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    @Deprecated
    public ObjectSet<Map.Entry<Long, Short>> entrySet() {
        return this.long2ShortEntrySet();
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Map.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2ShortMap.Entry e = (Long2ShortMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(e.getShortValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2ShortMap.Entry {
        protected long key;
        protected short value;

        public BasicEntry(Long key, Short value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(long key, short value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @Deprecated
        public Long getKey() {
            return this.key;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Short getValue() {
            return this.value;
        }

        @Override
        public short getShortValue() {
            return this.value;
        }

        @Override
        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short setValue(Short value) {
            return this.setValue((short)value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Long)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Short)) {
                return false;
            }
            return this.key == (Long)e.getKey() && this.value == (Short)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

