/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dexsplitter;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DexSplitterHelper;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.utils.FeatureClassMapping;
import com.android.tools.r8.utils.OptionsParsing;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class DexSplitter {
    private static final String DEFAULT_OUTPUT_DIR = "output";
    private static final boolean PRINT_ARGS = false;

    private static FeatureJar parseFeatureJarArgument(String argument) {
        if (argument.contains(":")) {
            String[] parts = argument.split(":");
            if (parts.length > 2) {
                throw new RuntimeException("--feature-jar argument contains more than one :");
            }
            return new FeatureJar(parts[0], parts[1]);
        }
        return new FeatureJar(argument);
    }

    private static Options parseArguments(String[] args) throws IOException {
        Options options = new Options();
        OptionsParsing.ParseContext context = new OptionsParsing.ParseContext(args);
        while (context.head() != null) {
            List<String> inputs = OptionsParsing.tryParseMulti(context, "--input");
            if (inputs != null) {
                inputs.stream().forEach(options::addInputArchive);
                continue;
            }
            List<String> featureJars = OptionsParsing.tryParseMulti(context, "--feature-jar");
            if (featureJars != null) {
                featureJars.stream().forEach(feature -> options.addFeatureJar(DexSplitter.parseFeatureJarArgument(feature)));
                continue;
            }
            String output = OptionsParsing.tryParseSingle(context, "--output", "-o");
            if (output != null) {
                options.setOutput(output);
                continue;
            }
            String proguardMap = OptionsParsing.tryParseSingle(context, "--proguard-map", null);
            if (proguardMap != null) {
                options.setProguardMap(proguardMap);
                continue;
            }
            String featureSplit = OptionsParsing.tryParseSingle(context, "--feature-splits", null);
            if (featureSplit != null) {
                options.setFeatureSplitMapping(featureSplit);
                continue;
            }
            throw new RuntimeException(String.format("Unknown options: '%s'.", context.head()));
        }
        return options;
    }

    private static FeatureClassMapping createFeatureClassMapping(Options options) throws IOException, FeatureClassMapping.FeatureMappingException, ResourceException {
        if (options.getFeatureSplitMapping() != null) {
            return FeatureClassMapping.fromSpecification(Paths.get(options.getFeatureSplitMapping(), new String[0]));
        }
        assert (!options.getFeatureJars().isEmpty());
        return FeatureClassMapping.fromJarFiles(options.getFeatureJars());
    }

    private static void run(String[] args) throws CompilationFailedException, IOException, CompilationException, ExecutionException, ResourceException, FeatureClassMapping.FeatureMappingException {
        Options options = DexSplitter.parseArguments(args);
        DexSplitter.run(options);
    }

    public static void run(Options options) throws IOException, FeatureClassMapping.FeatureMappingException, ResourceException, CompilationException, ExecutionException, CompilationFailedException {
        if (options.getInputArchives().isEmpty()) {
            throw new RuntimeException("Need at least one --input");
        }
        if (options.getFeatureSplitMapping() == null && options.getFeatureJars().isEmpty()) {
            throw new RuntimeException("You must supply a feature split mapping or feature jars");
        }
        if (options.getFeatureSplitMapping() != null && !options.getFeatureJars().isEmpty()) {
            throw new RuntimeException("You can't supply both a feature split mapping and feature jars");
        }
        D8Command.Builder builder = D8Command.builder();
        for (String s : options.inputArchives) {
            builder.addProgramFiles(Paths.get(s, new String[0]));
        }
        builder.setProgramConsumer(DexIndexedConsumer.emptyConsumer());
        FeatureClassMapping featureClassMapping = DexSplitter.createFeatureClassMapping(options);
        DexSplitterHelper.run((D8Command)builder.build(), featureClassMapping, options.getOutput(), options.getProguardMap());
    }

    public static void main(String[] args) {
        try {
            DexSplitter.run(args);
        }
        catch (CompilationException | CompilationFailedException | ResourceException | FeatureClassMapping.FeatureMappingException | IOException | ExecutionException e) {
            System.err.println("Splitting failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printArgs(String[] args) {
        System.err.printf("r8.DexSplitter", new Object[0]);
        for (String s : args) {
            System.err.printf(" %s", s);
        }
        System.err.println("");
    }

    public static class Options {
        private List<String> inputArchives = new ArrayList<String>();
        private List<FeatureJar> featureJars = new ArrayList<FeatureJar>();
        private String output = "output";
        private String featureSplitMapping;
        private String proguardMap;

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public String getFeatureSplitMapping() {
            return this.featureSplitMapping;
        }

        public void setFeatureSplitMapping(String featureSplitMapping) {
            this.featureSplitMapping = featureSplitMapping;
        }

        public String getProguardMap() {
            return this.proguardMap;
        }

        public void setProguardMap(String proguardMap) {
            this.proguardMap = proguardMap;
        }

        public void addInputArchive(String inputArchive) {
            this.inputArchives.add(inputArchive);
        }

        protected void addFeatureJar(FeatureJar featureJar) {
            this.featureJars.add(featureJar);
        }

        public void addFeatureJar(String jar) {
            this.featureJars.add(new FeatureJar(jar));
        }

        public void addFeatureJar(String jar, String outputName) {
            this.featureJars.add(new FeatureJar(jar, outputName));
        }

        public ImmutableList<String> getInputArchives() {
            return ImmutableList.copyOf(this.inputArchives);
        }

        public ImmutableList<FeatureJar> getFeatureJars() {
            return ImmutableList.copyOf(this.featureJars);
        }
    }

    public static class FeatureJar {
        private String jar;
        private String outputName;

        public FeatureJar(String jar, String outputName) {
            this.jar = jar;
            this.outputName = outputName;
        }

        public FeatureJar(String jar) {
            this(jar, FeatureJar.featureNameFromJar(jar));
        }

        public String getJar() {
            return this.jar;
        }

        public String getOutputName() {
            return this.outputName;
        }

        private static String featureNameFromJar(String jar) {
            Path jarPath = Paths.get(jar, new String[0]);
            String featureName = jarPath.getFileName().toString();
            if (featureName.endsWith(".jar") || featureName.endsWith(".zip")) {
                featureName = featureName.substring(0, featureName.length() - 4);
            }
            return featureName;
        }
    }
}

