/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.io.BaseEncoding;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class DexCallSite
extends IndexedDexItem {
    public final DexString methodName;
    public final DexProto methodProto;
    public final DexMethodHandle bootstrapMethod;
    public final List<DexValue> bootstrapArgs;
    public final List<DexMethod> interfaceMethods;
    private DexEncodedArray encodedArray = null;

    DexCallSite(DexString methodName, DexProto methodProto, DexMethodHandle bootstrapMethod, List<DexValue> bootstrapArgs, List<DexMethod> interfaceMethods) {
        assert (methodName != null);
        assert (methodProto != null);
        assert (bootstrapMethod != null);
        assert (bootstrapArgs != null);
        assert (interfaceMethods != null);
        this.methodName = methodName;
        this.methodProto = methodProto;
        this.bootstrapMethod = bootstrapMethod;
        this.bootstrapArgs = bootstrapArgs;
        this.interfaceMethods = interfaceMethods;
    }

    public static DexCallSite fromAsmInvokeDynamic(InvokeDynamicInsnNode insn, JarApplicationReader application, DexType clazz) {
        return DexCallSite.fromAsmInvokeDynamic(application, clazz, insn.name, insn.desc, insn.bsm, insn.bsmArgs);
    }

    public static DexCallSite fromAsmInvokeDynamic(JarApplicationReader application, DexType clazz, String name, String desc, Handle bsmHandle, Object[] bsmArgs) {
        if (bsmHandle.getTag() != 6 && bsmHandle.getTag() != 8) {
            throw new Unreachable("Bootstrap handle invalid: tag == " + bsmHandle.getTag());
        }
        DexMethodHandle bootstrapMethod = DexMethodHandle.fromAsmHandle(bsmHandle, application, clazz);
        ArrayList<DexValue> bootstrapArgs = new ArrayList<DexValue>();
        for (Object arg : bsmArgs) {
            bootstrapArgs.add(DexValue.fromAsmBootstrapArgument(arg, application, clazz));
        }
        return application.getCallSite(name, desc, bootstrapMethod, bootstrapArgs);
    }

    @Override
    public int computeHashCode() {
        return this.methodName.hashCode() + this.methodProto.hashCode() * 7 + this.bootstrapMethod.hashCode() * 31 + this.bootstrapArgs.hashCode() * 101;
    }

    @Override
    public boolean computeEquals(Object other) {
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CallSite: { Name: ").append(this.methodName.toSourceString()).append(", Proto: ").append(this.methodProto.toSourceString()).append(", ").append(this.bootstrapMethod.toSourceString());
        String sep = ", Args: ";
        for (DexItem dexItem : this.bootstrapArgs) {
            builder.append(sep).append(dexItem.toSourceString());
            sep = ", ";
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addCallSite(this)) {
            this.methodName.collectIndexedItems(indexedItems);
            this.methodProto.collectIndexedItems(indexedItems);
            this.bootstrapMethod.collectIndexedItems(indexedItems);
            for (DexValue arg : this.bootstrapArgs) {
                arg.collectIndexedItems(indexedItems);
            }
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this.getEncodedArray());
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public String toSmaliString() {
        return this.toString();
    }

    public String getHash() {
        return new HashBuilder().build();
    }

    public DexEncodedArray getEncodedArray() {
        if (this.encodedArray == null) {
            DexValue[] callSitesValues = new DexValue[3 + this.bootstrapArgs.size()];
            int valuesIndex = 0;
            callSitesValues[valuesIndex++] = new DexValue.DexValueMethodHandle(this.bootstrapMethod);
            callSitesValues[valuesIndex++] = new DexValue.DexValueString(this.methodName);
            callSitesValues[valuesIndex++] = new DexValue.DexValueMethodType(this.methodProto);
            for (DexValue extraArgValue : this.bootstrapArgs) {
                callSitesValues[valuesIndex++] = extraArgValue;
            }
            this.encodedArray = new DexEncodedArray(callSitesValues);
        }
        return this.encodedArray;
    }

    private final class HashBuilder {
        private ByteArrayOutputStream bytes;
        private ObjectOutputStream out;

        private HashBuilder() {
        }

        private void write(DexString string) throws IOException {
            this.out.writeInt(string.size);
            this.out.write(string.content);
        }

        private void write(DexType type) throws IOException {
            this.write(type.descriptor);
        }

        private void write(DexMethodHandle methodHandle) throws IOException {
            this.out.writeShort(methodHandle.type.getValue());
            if (methodHandle.isFieldHandle()) {
                this.write(methodHandle.asField());
            } else {
                this.write(methodHandle.asMethod());
            }
        }

        private void write(DexProto proto) throws IOException {
            this.write(proto.shorty);
            this.write(proto.returnType);
            DexType[] params = proto.parameters.values;
            this.out.writeInt(params.length);
            for (DexType param : params) {
                this.write(param);
            }
        }

        private void write(DexMethod method) throws IOException {
            this.write(method.holder);
            this.write(method.proto);
            this.write(method.name);
        }

        private void write(DexField field) throws IOException {
            this.write(field.clazz);
            this.write(field.type);
            this.write(field.name);
        }

        private void write(List<DexValue> args) throws IOException {
            this.out.writeInt(args.size());
            for (DexValue arg : args) {
                if (arg instanceof DexValue.DexValueString) {
                    this.out.writeByte(0);
                    this.write((DexString)((DexValue.DexValueString)arg).value);
                    continue;
                }
                if (arg instanceof DexValue.DexValueType) {
                    this.out.writeByte(1);
                    this.write((DexType)((DexValue.DexValueType)arg).value);
                    continue;
                }
                if (arg instanceof DexValue.DexValueInt) {
                    this.out.writeByte(2);
                    this.out.writeInt(((DexValue.DexValueInt)arg).value);
                    continue;
                }
                if (arg instanceof DexValue.DexValueLong) {
                    this.out.writeByte(3);
                    this.out.writeLong(((DexValue.DexValueLong)arg).value);
                    continue;
                }
                if (arg instanceof DexValue.DexValueFloat) {
                    this.out.writeByte(4);
                    this.out.writeFloat(((DexValue.DexValueFloat)arg).value);
                    continue;
                }
                if (arg instanceof DexValue.DexValueDouble) {
                    this.out.writeByte(5);
                    this.out.writeDouble(((DexValue.DexValueDouble)arg).value);
                    continue;
                }
                if (arg instanceof DexValue.DexValueMethodHandle) {
                    this.out.writeByte(6);
                    this.write((DexMethodHandle)((DexValue.DexValueMethodHandle)arg).value);
                    continue;
                }
                assert (arg instanceof DexValue.DexValueMethodType);
                this.out.writeByte(7);
                this.write((DexProto)((DexValue.DexValueMethodType)arg).value);
            }
        }

        String build() {
            try {
                this.bytes = new ByteArrayOutputStream();
                this.out = new ObjectOutputStream(this.bytes);
                this.write(DexCallSite.this.methodName);
                this.write(DexCallSite.this.methodProto);
                this.write(DexCallSite.this.bootstrapMethod);
                this.write(DexCallSite.this.bootstrapArgs);
                this.out.close();
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                digest.update(this.bytes.toByteArray());
                return BaseEncoding.base64Url().omitPadding().encode(digest.digest());
            }
            catch (IOException | NoSuchAlgorithmException ex) {
                throw new Unreachable("Cannot get SHA-1 message digest");
            }
        }
    }
}

