/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.code.Format22c;
import com.android.tools.r8.code.Iget;
import com.android.tools.r8.code.IgetBoolean;
import com.android.tools.r8.code.IgetByte;
import com.android.tools.r8.code.IgetChar;
import com.android.tools.r8.code.IgetObject;
import com.android.tools.r8.code.IgetShort;
import com.android.tools.r8.code.IgetWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.function.Function;

public class InstanceGet
extends FieldInstruction {
    public InstanceGet(MemberType type, Value dest, Value object, DexField field) {
        super(type, field, dest, object);
    }

    public Value dest() {
        return this.outValue;
    }

    public Value object() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format22c instruction;
        int destRegister = builder.allocatedRegister(this.dest(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: 
            case INT_OR_FLOAT: {
                instruction = new Iget(destRegister, objectRegister, this.field);
                break;
            }
            case LONG: 
            case DOUBLE: 
            case LONG_OR_DOUBLE: {
                instruction = new IgetWide(destRegister, objectRegister, this.field);
                break;
            }
            case OBJECT: {
                instruction = new IgetObject(destRegister, objectRegister, this.field);
                break;
            }
            case BOOLEAN: {
                instruction = new IgetBoolean(destRegister, objectRegister, this.field);
                break;
            }
            case BYTE: {
                instruction = new IgetByte(destRegister, objectRegister, this.field);
                break;
            }
            case CHAR: {
                instruction = new IgetChar(destRegister, objectRegister, this.field);
                break;
            }
            case SHORT: {
                instruction = new IgetShort(destRegister, objectRegister, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        InstanceGet o = other.asInstanceGet();
        return o.field == this.field && o.type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        InstanceGet o = other.asInstanceGet();
        int result = this.field.slowCompareTo(o.field);
        if (result != 0) {
            return result;
        }
        return this.type.ordinal() - o.type.ordinal();
    }

    @Override
    DexEncodedField lookupTarget(DexType type, AppInfo appInfo) {
        return appInfo.lookupInstanceTarget(type, this.field);
    }

    @Override
    public boolean isInstanceGet() {
        return true;
    }

    @Override
    public InstanceGet asInstanceGet() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.field.toSourceString();
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return TypeLatticeElement.fromDexType(this.field.type, true);
    }

    @Override
    public boolean hasInvariantVerificationType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.field.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(180, this.field, builder.resolveField(this.field)));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value) {
        return this.object() == value;
    }
}

