/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;

public class D8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: d8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --debug                 # Compile with debugging information (default).", "  --release               # Compile without debugging information.", "  --output <file>         # Output result in <outfile>.", "                          # <file> must be an existing directory or a zip file.", "  --lib <file>            # Add <file> as a library resource.", "  --classpath <file>      # Add <file> as a classpath resource.", "  --min-api               # Minimum Android API level compatibility", "  --intermediate          # Compile an intermediate result intended for later", "                          # merging.", new String[]{"  --file-per-class        # Produce a separate dex file per input class", "  --no-desugaring         # Force disable desugaring.", "  --main-dex-list <file>  # List of classes to place in the primary dex file.", "  --version               # Print the version of d8.", "  --help                  # Print this message."}));
    private boolean intermediate = false;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args, Origin origin) {
        return D8Command.parse(args, origin, D8Command.builder());
    }

    public static Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return D8Command.parse(args, origin, D8Command.builder(handler));
    }

    private static Builder parse(String[] args, Origin origin, Builder builder) {
        CompilationMode compilationMode = null;
        Path outputPath = null;
        OutputMode outputMode = null;
        boolean hasDefinedApiLevel = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--debug")) {
                    if (compilationMode == CompilationMode.RELEASE) {
                        builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                        continue;
                    }
                    compilationMode = CompilationMode.DEBUG;
                    continue;
                }
                if (arg.equals("--release")) {
                    if (compilationMode == CompilationMode.DEBUG) {
                        builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                        continue;
                    }
                    compilationMode = CompilationMode.RELEASE;
                    continue;
                }
                if (arg.equals("--file-per-class")) {
                    outputMode = OutputMode.DexFilePerClassFile;
                    continue;
                }
                if (arg.equals("--output")) {
                    String output = args[++i];
                    if (outputPath != null) {
                        builder.getReporter().error(new StringDiagnostic("Cannot output both to '" + outputPath.toString() + "' and '" + output + "'", origin));
                        continue;
                    }
                    outputPath = Paths.get(output, new String[0]);
                    continue;
                }
                if (arg.equals("--lib")) {
                    builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--classpath")) {
                    builder.addClasspathFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--main-dex-list")) {
                    builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--optimize-multidex-for-linearalloc")) {
                    builder.setOptimizeMultidexForLinearAlloc(true);
                    continue;
                }
                if (arg.equals("--min-api")) {
                    hasDefinedApiLevel = D8Command.parseMinApi(builder, args[++i], hasDefinedApiLevel, origin);
                    continue;
                }
                if (arg.equals("--intermediate")) {
                    builder.setIntermediate(true);
                    continue;
                }
                if (arg.equals("--no-desugaring")) {
                    builder.setDisableDesugaring(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, origin));
                    continue;
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
            if (compilationMode != null) {
                builder.setMode(compilationMode);
            }
            if (outputMode == null) {
                outputMode = OutputMode.DexIndexed;
            }
            if (outputPath == null) {
                outputPath = Paths.get(".", new String[0]);
            }
            return (Builder)builder.setOutput(outputPath, outputMode);
        }
        catch (CompilationError e) {
            throw builder.getReporter().fatalError(e);
        }
    }

    private D8Command(AndroidApp inputApp, CompilationMode mode, ProgramConsumer programConsumer, int minApiLevel, Reporter diagnosticsHandler, boolean enableDesugaring, boolean intermediate, boolean optimizeMultidexForLinearAlloc) {
        super(inputApp, mode, programConsumer, minApiLevel, diagnosticsHandler, enableDesugaring, optimizeMultidexForLinearAlloc);
        this.intermediate = intermediate;
    }

    private D8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(new DexItemFactory(), this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.programConsumer = this.getProgramConsumer();
        internal.minimalMainDex = internal.debug;
        internal.minApiLevel = this.getMinApiLevel();
        internal.intermediate = this.intermediate;
        assert (internal.enableMinification);
        internal.enableMinification = false;
        assert (internal.enableTreeShaking);
        internal.enableTreeShaking = false;
        assert (!internal.passthroughDexCode);
        internal.passthroughDexCode = true;
        assert (internal.enableInlining);
        internal.enableInlining = false;
        assert (internal.enableSwitchMapRemoval);
        internal.enableSwitchMapRemoval = false;
        assert (internal.outline.enabled);
        internal.outline.enabled = false;
        assert (internal.enableValuePropagation);
        internal.enableValuePropagation = false;
        internal.enableDesugaring = this.getEnableDesugaring();
        internal.enableLambdaMerging = false;
        internal.enableInheritanceClassInDexDistributor = this.isOptimizeMultidexForLinearAlloc();
        return internal;
    }

    public static class Builder
    extends BaseCompilerCommand.Builder<D8Command, Builder> {
        private boolean intermediate = false;

        Builder() {
            this.setMode(CompilationMode.DEBUG);
        }

        Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            this.setMode(CompilationMode.DEBUG);
        }

        private Builder(AndroidApp app) {
            super(app);
            this.setMode(CompilationMode.DEBUG);
        }

        public Builder addDexProgramData(byte[] data, Origin origin) {
            this.guard(() -> this.getAppBuilder().addDexProgramData(data, origin));
            return this.self();
        }

        public Builder addClasspathFiles(Path ... files) {
            this.guard(() -> Arrays.stream(files).forEach(this::addClasspathFile));
            return this.self();
        }

        public Builder addClasspathFiles(Collection<Path> files) {
            this.guard(() -> files.forEach(this::addClasspathFile));
            return this.self();
        }

        private void addClasspathFile(Path file) {
            this.guard(() -> {
                try {
                    this.getAppBuilder().addClasspathFile(file);
                }
                catch (IOException e) {
                    this.error("Error with classpath entry: ", file, e);
                }
            });
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider2) {
            this.guard(() -> this.getAppBuilder().addClasspathResourceProvider(provider2));
            return this.self();
        }

        public Builder setIntermediate(boolean value) {
            this.intermediate = value;
            return this.self();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.getProgramConsumer() instanceof ClassFileConsumer) {
                reporter.error("D8 does not support compiling to Java class files");
            }
            if (this.getAppBuilder().hasMainDexList()) {
                if (this.intermediate) {
                    reporter.error("Option --main-dex-list cannot be used with --intermediate");
                }
                if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                    reporter.error("Option --main-dex-list cannot be used with --file-per-class");
                }
            }
            super.validate();
        }

        @Override
        D8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new D8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.intermediate |= this.getProgramConsumer() instanceof DexFilePerClassFileConsumer;
            return new D8Command(this.getAppBuilder().build(), this.getMode(), this.getProgramConsumer(), this.getMinApiLevel(), this.getReporter(), !this.getDisableDesugaring(), this.intermediate, this.isOptimizeMultidexForLinearAlloc());
        }

        private static DexIndexedConsumer createIndexedConsumer(Path path) {
            if (path == null) {
                return DexIndexedConsumer.emptyConsumer();
            }
            return FileUtils.isArchive(path) ? new DexIndexedConsumer.ArchiveConsumer(path) : new DexIndexedConsumer.DirectoryConsumer(path);
        }

        private static DexFilePerClassFileConsumer createPerClassFileConsumer(Path path) {
            if (path == null) {
                return DexFilePerClassFileConsumer.emptyConsumer();
            }
            return FileUtils.isArchive(path) ? new DexFilePerClassFileConsumer.ArchiveConsumer(path) : new DexFilePerClassFileConsumer.DirectoryConsumer(path);
        }
    }
}

