/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.cf.code.CfArrayLength;
import com.android.tools.r8.cf.code.CfArrayLoad;
import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfBinop;
import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfConstClass;
import com.android.tools.r8.cf.code.CfConstMethodHandle;
import com.android.tools.r8.cf.code.CfConstMethodType;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfIf;
import com.android.tools.r8.cf.code.CfIfCmp;
import com.android.tools.r8.cf.code.CfIinc;
import com.android.tools.r8.cf.code.CfInstanceOf;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfMonitor;
import com.android.tools.r8.cf.code.CfMultiANewArray;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.cf.code.CfNop;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.cf.code.CfSwitch;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.cf.code.CfUnop;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarCode;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.org.objectweb.asm.AnnotationVisitor;
import com.android.tools.r8.org.objectweb.asm.Attribute;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import com.android.tools.r8.org.objectweb.asm.FieldVisitor;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Opcodes;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.TypePath;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class JarClassFileReader {
    private static final int ACC_SYNTHETIC_ATTRIBUTE = 262144;
    public static final String SYNTHETIC_ANNOTATION = "Ljava/lang/Synthetic;";
    private final JarApplicationReader application;
    private final Consumer<DexClass> classConsumer;

    public JarClassFileReader(JarApplicationReader application, Consumer<DexClass> classConsumer) {
        this.application = application;
        this.classConsumer = classConsumer;
    }

    public void read(Origin origin, ClassKind classKind, InputStream input) throws IOException {
        ClassReader reader = new ClassReader(input);
        int flags = 4;
        if (this.application.options.enableCfFrontend) {
            flags = 8;
        }
        reader.accept(new CreateDexClassVisitor(origin, classKind, reader.b, this.application, this.classConsumer), flags);
    }

    private static int cleanAccessFlags(int access) {
        return access & 0xFFFBFFFF & 0xFFFDFFFF;
    }

    public static MethodAccessFlags createMethodAccessFlags(String name, int access) {
        boolean isConstructor = name.equals("<init>") || name.equals("<clinit>");
        return MethodAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(access), isConstructor);
    }

    private static AnnotationVisitor createAnnotationVisitor(String desc, boolean visible, List<DexAnnotation> annotations, JarApplicationReader application) {
        assert (annotations != null);
        int visiblity = visible ? 1 : 0;
        return new CreateAnnotationVisitor(application, (names, values) -> annotations.add(new DexAnnotation(visiblity, JarClassFileReader.createEncodedAnnotation(desc, names, values, application))));
    }

    private static DexEncodedAnnotation createEncodedAnnotation(String desc, List<DexString> names, List<DexValue> values, JarApplicationReader application) {
        assert (names == null && values.isEmpty() || names != null && !names.isEmpty() && names.size() == values.size());
        DexAnnotationElement[] elements = new DexAnnotationElement[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            elements[i] = new DexAnnotationElement(names.get(i), values.get(i));
        }
        return new DexEncodedAnnotation(application.getTypeFromDescriptor(desc), elements);
    }

    private static DexAnnotationSet createAnnotationSet(List<DexAnnotation> annotations) {
        return annotations == null || annotations.isEmpty() ? DexAnnotationSet.empty() : new DexAnnotationSet(annotations.toArray(new DexAnnotation[annotations.size()]));
    }

    private static class CreateAnnotationVisitor
    extends AnnotationVisitor {
        private final JarApplicationReader application;
        private final BiConsumer<List<DexString>, List<DexValue>> onVisitEnd;
        private List<DexString> names = null;
        private final List<DexValue> values = new ArrayList<DexValue>();

        public CreateAnnotationVisitor(JarApplicationReader application, BiConsumer<List<DexString>, List<DexValue>> onVisitEnd) {
            super(393216);
            this.application = application;
            this.onVisitEnd = onVisitEnd;
        }

        @Override
        public void visit(String name, Object value) {
            this.addElement(name, this.getDexValue(value));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            DexType owner = this.application.getTypeFromDescriptor(desc);
            this.addElement(name, new DexValue.DexValueEnum(this.application.getField(owner, value, desc)));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new CreateAnnotationVisitor(this.application, (names, values) -> this.addElement(name, new DexValue.DexValueAnnotation(JarClassFileReader.createEncodedAnnotation(desc, names, values, this.application))));
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new CreateAnnotationVisitor(this.application, (names, values) -> {
                assert (names == null);
                this.addElement(name, new DexValue.DexValueArray(values.toArray(new DexValue[values.size()])));
            });
        }

        @Override
        public void visitEnd() {
            this.onVisitEnd.accept(this.names, this.values);
        }

        private void addElement(String name, DexValue value) {
            if (name != null) {
                if (this.names == null) {
                    this.names = new ArrayList<DexString>();
                }
                this.names.add(this.application.getString(name));
            }
            this.values.add(value);
        }

        private static DexValue.DexValueArray getDexValueArray(Object value) {
            if (value instanceof byte[]) {
                byte[] values = (byte[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueByte.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof boolean[]) {
                boolean[] values = (boolean[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueBoolean.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof char[]) {
                char[] values = (char[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueChar.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof short[]) {
                short[] values = (short[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueShort.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof int[]) {
                int[] values = (int[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueInt.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof long[]) {
                long[] values = (long[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueLong.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof float[]) {
                float[] values = (float[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueFloat.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof double[]) {
                double[] values = (double[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueDouble.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            throw new Unreachable("Unexpected type of annotation value: " + value);
        }

        private DexValue getDexValue(Object value) {
            if (value == null) {
                return DexValue.DexValueNull.NULL;
            }
            if (value instanceof Byte) {
                return DexValue.DexValueByte.create((Byte)value);
            }
            if (value instanceof Boolean) {
                return DexValue.DexValueBoolean.create((Boolean)value);
            }
            if (value instanceof Character) {
                return DexValue.DexValueChar.create(((Character)value).charValue());
            }
            if (value instanceof Short) {
                return DexValue.DexValueShort.create((Short)value);
            }
            if (value instanceof Integer) {
                return DexValue.DexValueInt.create((Integer)value);
            }
            if (value instanceof Long) {
                return DexValue.DexValueLong.create((Long)value);
            }
            if (value instanceof Float) {
                return DexValue.DexValueFloat.create(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return DexValue.DexValueDouble.create((Double)value);
            }
            if (value instanceof String) {
                return new DexValue.DexValueString(this.application.getString((String)value));
            }
            if (value instanceof Type) {
                return new DexValue.DexValueType(this.application.getTypeFromDescriptor(((Type)value).getDescriptor()));
            }
            return CreateAnnotationVisitor.getDexValueArray(value);
        }
    }

    private static class CfCreateMethodVisitor
    extends CreateMethodVisitor {
        private final JarApplicationReader application;
        private final DexItemFactory factory;
        private int maxStack;
        private int maxLocals;
        private List<CfInstruction> instructions;
        private List<CfTryCatch> tryCatchRanges;
        private List<CfCode.LocalVariableInfo> localVariables;
        private Map<Label, CfLabel> labelMap;

        public CfCreateMethodVisitor(int access, String name, String desc, String signature, String[] exceptions, CreateDexClassVisitor parent) {
            super(access, name, desc, signature, exceptions, parent);
            this.application = parent.application;
            this.factory = this.application.getFactory();
        }

        @Override
        public void visitCode() {
            assert (!this.flags.isAbstract() && !this.flags.isNative());
            this.maxStack = 0;
            this.maxLocals = 0;
            this.instructions = new ArrayList<CfInstruction>();
            this.tryCatchRanges = new ArrayList<CfTryCatch>();
            this.localVariables = new ArrayList<CfCode.LocalVariableInfo>();
            this.labelMap = new IdentityHashMap<Label, CfLabel>();
        }

        @Override
        public void visitEnd() {
            if (!this.flags.isAbstract() && !this.flags.isNative() && this.parent.classKind == ClassKind.PROGRAM) {
                this.code = new CfCode(this.method, this.maxStack, this.maxLocals, this.instructions, this.tryCatchRanges, this.localVariables);
            }
            super.visitEnd();
        }

        @Override
        public void visitFrame(int frameType, int nLocals, Object[] localTypes, int nStack, Object[] stackTypes) {
            assert (frameType == -1);
            Int2ReferenceSortedMap<CfFrame.FrameType> parsedLocals = this.parseLocals(nLocals, localTypes);
            List<CfFrame.FrameType> parsedStack = this.parseStack(nStack, stackTypes);
            this.instructions.add(new CfFrame(parsedLocals, parsedStack));
        }

        private Int2ReferenceSortedMap<CfFrame.FrameType> parseLocals(int typeCount, Object[] asmTypes) {
            Int2ReferenceAVLTreeMap<CfFrame.FrameType> types = new Int2ReferenceAVLTreeMap<CfFrame.FrameType>();
            int i = 0;
            for (int j = 0; j < typeCount; ++j) {
                Object localType = asmTypes[j];
                CfFrame.FrameType value = this.getFrameType(localType);
                types.put(i++, value);
                if (!value.isWide()) continue;
                ++i;
            }
            return types;
        }

        private List<CfFrame.FrameType> parseStack(int nStack, Object[] stackTypes) {
            ArrayList<CfFrame.FrameType> dexStack = new ArrayList<CfFrame.FrameType>(nStack);
            for (int i = 0; i < nStack; ++i) {
                dexStack.add(this.getFrameType(stackTypes[i]));
            }
            return dexStack;
        }

        private CfFrame.FrameType getFrameType(Object localType) {
            if (localType instanceof Label) {
                return CfFrame.FrameType.uninitializedNew(this.getLabel((Label)localType));
            }
            if (localType == Opcodes.UNINITIALIZED_THIS) {
                return CfFrame.FrameType.uninitializedThis();
            }
            if (localType == null || localType == Opcodes.TOP) {
                return CfFrame.FrameType.top();
            }
            return CfFrame.FrameType.initialized(this.parseAsmType(localType));
        }

        private CfLabel getLabel(Label label) {
            return this.labelMap.computeIfAbsent(label, l -> new CfLabel());
        }

        private DexType parseAsmType(Object local) {
            assert (local != null && local != Opcodes.TOP);
            if (local == Opcodes.INTEGER) {
                return this.factory.intType;
            }
            if (local == Opcodes.FLOAT) {
                return this.factory.floatType;
            }
            if (local == Opcodes.LONG) {
                return this.factory.longType;
            }
            if (local == Opcodes.DOUBLE) {
                return this.factory.doubleType;
            }
            if (local == Opcodes.NULL) {
                return DexItemFactory.nullValueType;
            }
            if (local instanceof String) {
                return this.createTypeFromInternalType((String)local);
            }
            throw new Unreachable("Unexpected ASM type: " + local);
        }

        private DexType createTypeFromInternalType(String local) {
            assert (local.indexOf(46) == -1);
            return this.factory.createType("L" + local + ";");
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 0: {
                    this.instructions.add(new CfNop());
                    break;
                }
                case 1: {
                    this.instructions.add(new CfConstNull());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.instructions.add(new CfConstNumber(opcode - 3, ValueType.INT));
                    break;
                }
                case 9: 
                case 10: {
                    this.instructions.add(new CfConstNumber(opcode - 9, ValueType.LONG));
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.instructions.add(new CfConstNumber(Float.floatToRawIntBits(opcode - 11), ValueType.FLOAT));
                    break;
                }
                case 14: 
                case 15: {
                    this.instructions.add(new CfConstNumber(Double.doubleToRawLongBits(opcode - 14), ValueType.DOUBLE));
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.instructions.add(new CfArrayLoad(CfCreateMethodVisitor.getMemberTypeForOpcode(opcode)));
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.instructions.add(new CfArrayStore(CfCreateMethodVisitor.getMemberTypeForOpcode(opcode)));
                    break;
                }
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    this.instructions.add(CfStackInstruction.fromAsm(opcode));
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    this.instructions.add(new CfBinop(opcode));
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    this.instructions.add(new CfUnop(opcode));
                    break;
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.instructions.add(new CfBinop(opcode));
                    break;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    this.instructions.add(new CfUnop(opcode));
                    break;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    this.instructions.add(new CfBinop(opcode));
                    break;
                }
                case 172: {
                    this.instructions.add(new CfReturn(ValueType.INT));
                    break;
                }
                case 173: {
                    this.instructions.add(new CfReturn(ValueType.LONG));
                    break;
                }
                case 174: {
                    this.instructions.add(new CfReturn(ValueType.FLOAT));
                    break;
                }
                case 175: {
                    this.instructions.add(new CfReturn(ValueType.DOUBLE));
                    break;
                }
                case 176: {
                    this.instructions.add(new CfReturn(ValueType.OBJECT));
                    break;
                }
                case 177: {
                    this.instructions.add(new CfReturnVoid());
                    break;
                }
                case 190: {
                    this.instructions.add(new CfArrayLength());
                    break;
                }
                case 191: {
                    this.instructions.add(new CfThrow());
                    break;
                }
                case 194: {
                    this.instructions.add(new CfMonitor(Monitor.Type.ENTER));
                    break;
                }
                case 195: {
                    this.instructions.add(new CfMonitor(Monitor.Type.EXIT));
                    break;
                }
                default: {
                    throw new Unreachable("Unknown instruction");
                }
            }
        }

        private DexType opType(int opcode, DexItemFactory factory) {
            switch (opcode) {
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 116: 
                case 120: 
                case 122: 
                case 124: {
                    return factory.intType;
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 123: 
                case 125: {
                    return factory.longType;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 118: {
                    return factory.floatType;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: 
                case 119: {
                    return factory.doubleType;
                }
            }
            throw new Unreachable("Unexpected opcode " + opcode);
        }

        private static MemberType getMemberTypeForOpcode(int opcode) {
            switch (opcode) {
                case 46: 
                case 79: {
                    return MemberType.INT;
                }
                case 48: 
                case 81: {
                    return MemberType.FLOAT;
                }
                case 47: 
                case 80: {
                    return MemberType.LONG;
                }
                case 49: 
                case 82: {
                    return MemberType.DOUBLE;
                }
                case 50: 
                case 83: {
                    return MemberType.OBJECT;
                }
                case 51: 
                case 84: {
                    return MemberType.BOOLEAN;
                }
                case 52: 
                case 85: {
                    return MemberType.CHAR;
                }
                case 53: 
                case 86: {
                    return MemberType.SHORT;
                }
            }
            throw new Unreachable("Unexpected array opcode " + opcode);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            switch (opcode) {
                case 16: 
                case 17: {
                    this.instructions.add(new CfConstNumber(operand, ValueType.INT));
                    break;
                }
                case 188: {
                    this.instructions.add(new CfNewArray(this.factory.createArrayType(1, CfCreateMethodVisitor.arrayTypeDesc(operand, this.factory))));
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected int opcode " + opcode);
                }
            }
        }

        private static DexType arrayTypeDesc(int arrayTypeCode, DexItemFactory factory) {
            switch (arrayTypeCode) {
                case 4: {
                    return factory.booleanType;
                }
                case 5: {
                    return factory.charType;
                }
                case 6: {
                    return factory.floatType;
                }
                case 7: {
                    return factory.doubleType;
                }
                case 8: {
                    return factory.byteType;
                }
                case 9: {
                    return factory.shortType;
                }
                case 10: {
                    return factory.intType;
                }
                case 11: {
                    return factory.longType;
                }
            }
            throw new Unreachable("Unexpected array-type code " + arrayTypeCode);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            ValueType type;
            switch (opcode) {
                case 21: 
                case 54: {
                    type = ValueType.INT;
                    break;
                }
                case 23: 
                case 56: {
                    type = ValueType.FLOAT;
                    break;
                }
                case 22: 
                case 55: {
                    type = ValueType.LONG;
                    break;
                }
                case 24: 
                case 57: {
                    type = ValueType.DOUBLE;
                    break;
                }
                case 25: 
                case 58: {
                    type = ValueType.OBJECT;
                    break;
                }
                case 169: {
                    throw new Unreachable("RET should be handled by the ASM jsr inliner");
                }
                default: {
                    throw new Unreachable("Unexpected VarInsn opcode: " + opcode);
                }
            }
            if (21 <= opcode && opcode <= 25) {
                this.instructions.add(new CfLoad(type, var));
            } else {
                this.instructions.add(new CfStore(type, var));
            }
        }

        @Override
        public void visitTypeInsn(int opcode, String typeName) {
            DexType type = this.createTypeFromInternalType(typeName);
            switch (opcode) {
                case 187: {
                    this.instructions.add(new CfNew(type));
                    break;
                }
                case 189: {
                    this.instructions.add(new CfNewArray(this.factory.createArrayType(1, type)));
                    break;
                }
                case 192: {
                    this.instructions.add(new CfCheckCast(type));
                    break;
                }
                case 193: {
                    this.instructions.add(new CfInstanceOf(type));
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected TypeInsn opcode: " + opcode);
                }
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DexField field = this.factory.createField(this.createTypeFromInternalType(owner), this.factory.createType(desc), name);
            this.instructions.add(new CfFieldInstruction(opcode, field, field));
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.visitMethodInsn(opcode, owner, name, desc, false);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            DexMethod method = this.application.getMethod(owner, name, desc);
            this.instructions.add(new CfInvoke(opcode, method, itf));
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            DexCallSite callSite = DexCallSite.fromAsmInvokeDynamic(this.application, this.parent.type, name, desc, bsm, bsmArgs);
            this.instructions.add(new CfInvokeDynamic(callSite));
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            CfLabel target = this.getLabel(label);
            if (153 <= opcode && opcode <= 166) {
                if (opcode <= 158) {
                    this.instructions.add(new CfIf(CfCreateMethodVisitor.ifType(opcode), ValueType.INT, target));
                } else {
                    ValueType valueType = opcode <= 164 ? ValueType.INT : ValueType.OBJECT;
                    this.instructions.add(new CfIfCmp(CfCreateMethodVisitor.ifType(opcode), valueType, target));
                }
            } else {
                switch (opcode) {
                    case 167: {
                        this.instructions.add(new CfGoto(target));
                        break;
                    }
                    case 198: 
                    case 199: {
                        If.Type type = opcode == 198 ? If.Type.EQ : If.Type.NE;
                        this.instructions.add(new CfIf(type, ValueType.OBJECT, target));
                        break;
                    }
                    case 168: {
                        throw new Unreachable("JSR should be handled by the ASM jsr inliner");
                    }
                    default: {
                        throw new Unreachable("Unexpected JumpInsn opcode: " + opcode);
                    }
                }
            }
        }

        private static If.Type ifType(int opcode) {
            switch (opcode) {
                case 153: 
                case 159: 
                case 165: {
                    return If.Type.EQ;
                }
                case 154: 
                case 160: 
                case 166: {
                    return If.Type.NE;
                }
                case 155: 
                case 161: {
                    return If.Type.LT;
                }
                case 156: 
                case 162: {
                    return If.Type.GE;
                }
                case 157: 
                case 163: {
                    return If.Type.GT;
                }
                case 158: 
                case 164: {
                    return If.Type.LE;
                }
            }
            throw new Unreachable("Unexpected If instruction opcode: " + opcode);
        }

        @Override
        public void visitLabel(Label label) {
            this.instructions.add(this.getLabel(label));
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type type = (Type)cst;
                if (type.getSort() == 11) {
                    DexProto proto = this.application.getProto(type.getDescriptor());
                    this.instructions.add(new CfConstMethodType(proto));
                } else {
                    this.instructions.add(new CfConstClass(this.factory.createType(type.getDescriptor())));
                }
            } else if (cst instanceof String) {
                this.instructions.add(new CfConstString(this.factory.createString((String)cst)));
            } else if (cst instanceof Long) {
                this.instructions.add(new CfConstNumber((Long)cst, ValueType.LONG));
            } else if (cst instanceof Double) {
                long l = Double.doubleToRawLongBits((Double)cst);
                this.instructions.add(new CfConstNumber(l, ValueType.DOUBLE));
            } else if (cst instanceof Integer) {
                this.instructions.add(new CfConstNumber(((Integer)cst).intValue(), ValueType.INT));
            } else if (cst instanceof Float) {
                long i = Float.floatToRawIntBits(((Float)cst).floatValue());
                this.instructions.add(new CfConstNumber(i, ValueType.FLOAT));
            } else if (cst instanceof Handle) {
                this.instructions.add(new CfConstMethodHandle(DexMethodHandle.fromAsmHandle((Handle)cst, this.application, this.parent.type)));
            } else {
                throw new CompilationError("Unsupported constant: " + cst.toString());
            }
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            this.instructions.add(new CfIinc(var, increment));
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            assert (max == min + labels.length - 1);
            ArrayList<CfLabel> targets = new ArrayList<CfLabel>(labels.length);
            for (Label label : labels) {
                targets.add(this.getLabel(label));
            }
            this.instructions.add(new CfSwitch(CfSwitch.Kind.TABLE, this.getLabel(dflt), new int[]{min}, targets));
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            ArrayList<CfLabel> targets = new ArrayList<CfLabel>(labels.length);
            for (Label label : labels) {
                targets.add(this.getLabel(label));
            }
            this.instructions.add(new CfSwitch(CfSwitch.Kind.LOOKUP, this.getLabel(dflt), keys, targets));
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.instructions.add(new CfMultiANewArray(this.factory.createType(desc), dims));
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            List<DexType> guards = Collections.singletonList(type == null ? DexItemFactory.catchAllType : this.createTypeFromInternalType(type));
            List<CfLabel> targets = Collections.singletonList(this.getLabel(handler));
            this.tryCatchRanges.add(new CfTryCatch(this.getLabel(start), this.getLabel(end), guards, targets));
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            DebugLocalInfo debugLocalInfo = new DebugLocalInfo(this.factory.createString(name), this.factory.createType(desc), signature == null ? null : this.factory.createString(signature));
            this.localVariables.add(new CfCode.LocalVariableInfo(index, debugLocalInfo, this.getLabel(start), this.getLabel(end)));
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            this.instructions.add(new CfPosition(this.getLabel(start), new Position(line, null, this.method, null)));
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            assert (maxStack >= 0);
            assert (maxLocals >= 0);
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
        }
    }

    private static class CreateMethodVisitor
    extends MethodVisitor {
        private final int access;
        private final String name;
        private final String desc;
        final CreateDexClassVisitor parent;
        private final int parameterCount;
        private List<DexAnnotation> annotations = null;
        private DexValue defaultAnnotation = null;
        private int fakeParameterAnnotations = 0;
        private List<List<DexAnnotation>> parameterAnnotations = null;
        private List<DexValue> parameterNames = null;
        private List<DexValue> parameterFlags = null;
        final DexMethod method;
        final MethodAccessFlags flags;
        Code code = null;

        public CreateMethodVisitor(int access, String name, String desc, String signature, String[] exceptions, CreateDexClassVisitor parent) {
            super(393216);
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.parent = parent;
            this.method = parent.application.getMethod(parent.type, name, desc);
            this.flags = JarClassFileReader.createMethodAccessFlags(name, access);
            this.parameterCount = JarApplicationReader.getArgumentCount(desc);
            if (exceptions != null && exceptions.length > 0) {
                DexValue[] values = new DexValue[exceptions.length];
                for (int i = 0; i < exceptions.length; ++i) {
                    values[i] = new DexValue.DexValueType(parent.application.getTypeFromName(exceptions[i]));
                }
                this.addAnnotation(DexAnnotation.createThrowsAnnotation(values, parent.application.getFactory()));
            }
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, parent.application.getFactory()));
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new CreateAnnotationVisitor(this.parent.application, (names, elements) -> {
                assert (elements.size() == 1);
                this.defaultAnnotation = (DexValue)elements.get(0);
            });
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (desc.equals(JarClassFileReader.SYNTHETIC_ANNOTATION)) {
                if (this.parameterAnnotations == null) {
                    ++this.fakeParameterAnnotations;
                }
                return null;
            }
            if (this.parameterAnnotations == null) {
                int adjustedParameterCount = this.parameterCount - this.fakeParameterAnnotations;
                this.parameterAnnotations = new ArrayList<List<DexAnnotation>>(adjustedParameterCount);
                for (int i = 0; i < adjustedParameterCount; ++i) {
                    this.parameterAnnotations.add(new ArrayList());
                }
            }
            assert (this.mv == null);
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.parameterAnnotations.get(parameter - this.fakeParameterAnnotations), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitParameter(String name, int access) {
            if (this.parameterNames == null) {
                assert (this.parameterFlags == null);
                this.parameterNames = new ArrayList<DexValue>(this.parameterCount);
                this.parameterFlags = new ArrayList<DexValue>(this.parameterCount);
            }
            this.parameterNames.add(new DexValue.DexValueString(this.parent.application.getFactory().createString(name)));
            this.parameterFlags.add(DexValue.DexValueInt.create(access));
            super.visitParameter(name, access);
        }

        @Override
        public void visitCode() {
            assert (!this.flags.isAbstract() && !this.flags.isNative());
            if (this.parent.classKind == ClassKind.PROGRAM) {
                this.code = new JarCode(this.method, this.parent.origin, this.parent.context, this.parent.application);
            }
        }

        @Override
        public void visitEnd() {
            DexAnnotationSetRefList parameterAnnotationSets;
            assert (this.flags.isAbstract() || this.flags.isNative() || this.parent.classKind != ClassKind.PROGRAM || this.code != null);
            if (this.parameterAnnotations == null) {
                parameterAnnotationSets = DexAnnotationSetRefList.empty();
            } else {
                DexAnnotationSet[] sets = new DexAnnotationSet[this.parameterAnnotations.size()];
                for (int i = 0; i < this.parameterAnnotations.size(); ++i) {
                    sets[i] = JarClassFileReader.createAnnotationSet(this.parameterAnnotations.get(i));
                }
                parameterAnnotationSets = new DexAnnotationSetRefList(sets, this.fakeParameterAnnotations);
            }
            InternalOptions internalOptions = ((CreateDexClassVisitor)this.parent).application.options;
            if (this.parameterNames != null && internalOptions.canUseParameterNameAnnotations()) {
                assert (this.parameterFlags != null);
                if (this.parameterNames.size() != this.parameterCount) {
                    internalOptions.warningInvalidParameterAnnotations(this.method, this.parent.origin, this.parameterCount, this.parameterNames.size());
                }
                this.getAnnotations().add(DexAnnotation.createMethodParametersAnnotation(this.parameterNames.toArray(new DexValue[this.parameterNames.size()]), this.parameterFlags.toArray(new DexValue[this.parameterFlags.size()]), this.parent.application.getFactory()));
            }
            DexEncodedMethod dexMethod = new DexEncodedMethod(this.method, this.flags, JarClassFileReader.createAnnotationSet(this.annotations), parameterAnnotationSets, this.code);
            if (this.flags.isStatic() || this.flags.isConstructor() || this.flags.isPrivate()) {
                this.parent.directMethods.add(dexMethod);
            } else {
                this.parent.virtualMethods.add(dexMethod);
            }
            if (this.defaultAnnotation != null) {
                this.parent.addDefaultAnnotation(this.name, this.defaultAnnotation);
            }
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }
    }

    private static class CreateFieldVisitor
    extends FieldVisitor {
        private final CreateDexClassVisitor parent;
        private final int access;
        private final String name;
        private final String desc;
        private final Object value;
        private List<DexAnnotation> annotations = null;

        public CreateFieldVisitor(CreateDexClassVisitor parent, int access, String name, String desc, String signature, Object value) {
            super(393216);
            this.parent = parent;
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.value = value;
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, parent.application.getFactory()));
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitEnd() {
            FieldAccessFlags flags = FieldAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(this.access));
            DexField dexField = this.parent.application.getField(this.parent.type, this.name, this.desc);
            DexAnnotationSet annotationSet = JarClassFileReader.createAnnotationSet(this.annotations);
            DexValue staticValue = flags.isStatic() ? this.getStaticValue(this.value, dexField.type) : null;
            DexEncodedField field = new DexEncodedField(dexField, flags, annotationSet, staticValue);
            if (flags.isStatic()) {
                this.parent.staticFields.add(field);
            } else {
                this.parent.instanceFields.add(field);
            }
        }

        private DexValue getStaticValue(Object value, DexType type) {
            if (value == null) {
                return null;
            }
            DexItemFactory factory = this.parent.application.getFactory();
            if (type == factory.booleanType) {
                int i = (Integer)value;
                assert (0 <= i && i <= 1);
                return DexValue.DexValueBoolean.create(i == 1);
            }
            if (type == factory.byteType) {
                return DexValue.DexValueByte.create(((Integer)value).byteValue());
            }
            if (type == factory.shortType) {
                return DexValue.DexValueShort.create(((Integer)value).shortValue());
            }
            if (type == factory.charType) {
                return DexValue.DexValueChar.create((char)((Integer)value).intValue());
            }
            if (type == factory.intType) {
                return DexValue.DexValueInt.create((Integer)value);
            }
            if (type == factory.floatType) {
                return DexValue.DexValueFloat.create(((Float)value).floatValue());
            }
            if (type == factory.longType) {
                return DexValue.DexValueLong.create((Long)value);
            }
            if (type == factory.doubleType) {
                return DexValue.DexValueDouble.create((Double)value);
            }
            if (type == factory.stringType) {
                return new DexValue.DexValueString(factory.createString((String)value));
            }
            throw new Unreachable("Unexpected static-value type " + type);
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }
    }

    private static class CreateDexClassVisitor
    extends ClassVisitor {
        private final Origin origin;
        private final ClassKind classKind;
        private final JarApplicationReader application;
        private final Consumer<DexClass> classConsumer;
        private final JarCode.ReparseContext context = new JarCode.ReparseContext();
        private int version;
        private DexType type;
        private ClassAccessFlags accessFlags;
        private DexType superType;
        private DexTypeList interfaces;
        private DexString sourceFile;
        private EnclosingMethodAttribute enclosingMember = null;
        private final List<InnerClassAttribute> innerClasses = new ArrayList<InnerClassAttribute>();
        private List<DexAnnotation> annotations = null;
        private List<DexAnnotationElement> defaultAnnotations = null;
        private final List<DexEncodedField> staticFields = new ArrayList<DexEncodedField>();
        private final List<DexEncodedField> instanceFields = new ArrayList<DexEncodedField>();
        private final List<DexEncodedMethod> directMethods = new ArrayList<DexEncodedMethod>();
        private final List<DexEncodedMethod> virtualMethods = new ArrayList<DexEncodedMethod>();

        public CreateDexClassVisitor(Origin origin, ClassKind classKind, byte[] classCache, JarApplicationReader application, Consumer<DexClass> classConsumer) {
            super(393216);
            this.origin = origin;
            this.classKind = classKind;
            this.classConsumer = classConsumer;
            this.context.classCache = classCache;
            this.application = application;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.innerClasses.add(new InnerClassAttribute(access, this.application.getTypeFromName(name), outerName == null ? null : this.application.getTypeFromName(outerName), innerName == null ? null : this.application.getString(innerName)));
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
            assert (this.enclosingMember == null);
            DexType ownerType = this.application.getTypeFromName(owner);
            this.enclosingMember = name == null ? new EnclosingMethodAttribute(ownerType) : new EnclosingMethodAttribute(this.application.getMethod(ownerType, name, desc));
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.version = version;
            this.accessFlags = ClassAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(access));
            this.type = this.application.getTypeFromName(name);
            if (!this.accessFlags.areValid(this.getMajorVersion())) {
                throw new CompilationError("Illegal class file: Class " + name + " has invalid access flags. Found: " + this.accessFlags.toString(), this.origin);
            }
            if (superName == null && !name.equals("java/lang/Object")) {
                throw new CompilationError("Illegal class file: Class " + name + " is missing a super type.", this.origin);
            }
            if (this.accessFlags.isInterface() && !Objects.equals(superName, "java/lang/Object")) {
                throw new CompilationError("Illegal class file: Interface " + name + " must extend class java.lang.Object. Found: " + Objects.toString(superName), this.origin);
            }
            assert (superName != null || name.equals("java/lang/Object"));
            this.superType = superName == null ? null : this.application.getTypeFromName(superName);
            this.interfaces = this.application.getTypeListFromNames(interfaces);
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, this.application.getFactory()));
            }
        }

        @Override
        public void visitSource(String source, String debug) {
            if (source != null) {
                this.sourceFile = this.application.getString(source);
            }
            if (debug != null) {
                this.getAnnotations().add(DexAnnotation.createSourceDebugExtensionAnnotation(new DexValue.DexValueString(this.application.getString(debug)), this.application.getFactory()));
            }
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return new CreateFieldVisitor(this, access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.application.options.enableCfFrontend) {
                return new CfCreateMethodVisitor(access, name, desc, signature, exceptions, this);
            }
            return new CreateMethodVisitor(access, name, desc, signature, exceptions, this);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.application);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
            DexClass clazz;
            if (this.defaultAnnotations != null) {
                this.addAnnotation(DexAnnotation.createAnnotationDefaultAnnotation(this.type, this.defaultAnnotations, this.application.getFactory()));
            }
            if ((clazz = this.classKind.create(this.type, ProgramResource.Kind.CF, this.origin, this.accessFlags, this.superType, this.interfaces, this.sourceFile, this.enclosingMember, this.innerClasses, JarClassFileReader.createAnnotationSet(this.annotations), this.staticFields.toArray(new DexEncodedField[this.staticFields.size()]), this.instanceFields.toArray(new DexEncodedField[this.instanceFields.size()]), this.directMethods.toArray(new DexEncodedMethod[this.directMethods.size()]), this.virtualMethods.toArray(new DexEncodedMethod[this.virtualMethods.size()]), this.application.getFactory().getSkipNameValidationForTesting())).isProgramClass()) {
                this.context.owner = clazz.asProgramClass();
                clazz.asProgramClass().setClassFileVersion(this.version);
            }
            this.classConsumer.accept(clazz);
        }

        private void addDefaultAnnotation(String name, DexValue value) {
            if (this.defaultAnnotations == null) {
                this.defaultAnnotations = new ArrayList<DexAnnotationElement>();
            }
            this.defaultAnnotations.add(new DexAnnotationElement(this.application.getString(name), value));
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }

        private int getMajorVersion() {
            return this.version & 0xFFFF;
        }

        private int getMinorVersion() {
            return this.version >> 16 & 0xFFFF;
        }
    }
}

