/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ObjectToOffsetMapping {
    private static final int NOT_FOUND = -1;
    private static final int NOT_SET = -2;
    private final DexProgramClass[] classes;
    private final Reference2IntMap<DexProto> protos;
    private final Reference2IntMap<DexType> types;
    private final Reference2IntMap<DexMethod> methods;
    private final Reference2IntMap<DexField> fields;
    private final Reference2IntMap<DexString> strings;
    private final Reference2IntMap<DexCallSite> callSites;
    private final Reference2IntMap<DexMethodHandle> methodHandles;
    private DexString firstJumboString;

    public ObjectToOffsetMapping(DexApplication application, Collection<DexProgramClass> classes, Collection<DexProto> protos, Collection<DexType> types, Collection<DexMethod> methods, Collection<DexField> fields, Collection<DexString> strings, Collection<DexCallSite> callSites, Collection<DexMethodHandle> methodHandles) {
        assert (application != null);
        assert (classes != null);
        assert (protos != null);
        assert (types != null);
        assert (methods != null);
        assert (fields != null);
        assert (strings != null);
        assert (callSites != null);
        assert (methodHandles != null);
        this.classes = ObjectToOffsetMapping.sortClasses(application, classes);
        this.protos = this.createMap(protos, true, this::failOnOverflow);
        this.types = this.createMap(types, true, this::failOnOverflow);
        this.methods = this.createMap(methods, true, this::failOnOverflow);
        this.fields = this.createMap(fields, true, this::failOnOverflow);
        this.strings = this.createMap(strings, true, this::setFirstJumboString);
        this.callSites = this.createMap(callSites, false, this::failOnOverflow);
        this.methodHandles = this.createMap(methodHandles, false, this::failOnOverflow);
    }

    private void setFirstJumboString(DexString string) {
        assert (this.firstJumboString == null);
        this.firstJumboString = string;
    }

    private void failOnOverflow(DexItem item) {
        throw new CompilationError("Index overflow for " + item.getClass());
    }

    private <T extends IndexedDexItem> Reference2IntMap<T> createMap(Collection<T> items, boolean sort, Consumer<T> onUInt16Overflow) {
        if (items.isEmpty()) {
            return null;
        }
        Reference2IntLinkedOpenHashMap<IndexedDexItem> map = new Reference2IntLinkedOpenHashMap<IndexedDexItem>(items.size());
        map.defaultReturnValue(-1);
        Collection sorted = sort ? (Collection)items.stream().sorted().collect(Collectors.toList()) : items;
        int index = 0;
        for (IndexedDexItem item : sorted) {
            if (index == 65536) {
                onUInt16Overflow.accept(item);
            }
            map.put(item, index++);
        }
        return map;
    }

    private static DexProgramClass[] sortClasses(DexApplication application, Collection<DexProgramClass> classes) {
        ProgramClassDepthsMemoized classDepths = new ProgramClassDepthsMemoized(application);
        List<DexProgramClass> sortedClasses = classes.stream().sorted((x, y) -> {
            int dy;
            int dx = classDepths.getDepth((DexProgramClass)x);
            return dx != (dy = classDepths.getDepth((DexProgramClass)y)) ? dx - dy : x.type.compareTo(y.type);
        }).collect(Collectors.toList());
        return sortedClasses.toArray(new DexProgramClass[sortedClasses.size()]);
    }

    private static <T> Collection<T> keysOrEmpty(Map<T, ?> map) {
        return map == null ? Collections.emptyList() : map.keySet();
    }

    public Collection<DexMethod> getMethods() {
        return ObjectToOffsetMapping.keysOrEmpty(this.methods);
    }

    public DexProgramClass[] getClasses() {
        return this.classes;
    }

    public Collection<DexType> getTypes() {
        return ObjectToOffsetMapping.keysOrEmpty(this.types);
    }

    public Collection<DexProto> getProtos() {
        return ObjectToOffsetMapping.keysOrEmpty(this.protos);
    }

    public Collection<DexField> getFields() {
        return ObjectToOffsetMapping.keysOrEmpty(this.fields);
    }

    public Collection<DexString> getStrings() {
        return ObjectToOffsetMapping.keysOrEmpty(this.strings);
    }

    public Collection<DexCallSite> getCallSites() {
        return ObjectToOffsetMapping.keysOrEmpty(this.callSites);
    }

    public Collection<DexMethodHandle> getMethodHandles() {
        return ObjectToOffsetMapping.keysOrEmpty(this.methodHandles);
    }

    public boolean hasJumboStrings() {
        return this.firstJumboString != null;
    }

    public DexString getFirstJumboString() {
        return this.firstJumboString;
    }

    public DexString getFirstString() {
        for (Reference2IntMap.Entry entry : this.strings.reference2IntEntrySet()) {
            if (entry.getIntValue() != 0) continue;
            return (DexString)entry.getKey();
        }
        return null;
    }

    private <T extends IndexedDexItem> int getOffsetFor(T item, Reference2IntMap<T> map) {
        int index = map.getInt(item);
        assert (index != -2) : "Index was not set: " + item;
        assert (index != -1) : "Missing dependency: " + item;
        return index;
    }

    public int getOffsetFor(DexProto proto) {
        return this.getOffsetFor(proto, this.protos);
    }

    public int getOffsetFor(DexField field) {
        return this.getOffsetFor(field, this.fields);
    }

    public int getOffsetFor(DexMethod method) {
        return this.getOffsetFor(method, this.methods);
    }

    public int getOffsetFor(DexString string) {
        return this.getOffsetFor(string, this.strings);
    }

    public int getOffsetFor(DexType type) {
        return this.getOffsetFor(type, this.types);
    }

    public int getOffsetFor(DexCallSite callSite) {
        return this.getOffsetFor(callSite, this.callSites);
    }

    public int getOffsetFor(DexMethodHandle methodHandle) {
        return this.getOffsetFor(methodHandle, this.methodHandles);
    }

    private static class ProgramClassDepthsMemoized {
        private static final int UNKNOWN_DEPTH = -1;
        private final DexApplication application;
        private final Reference2IntMap<DexProgramClass> depthOfClasses = new Reference2IntOpenHashMap<DexProgramClass>();

        ProgramClassDepthsMemoized(DexApplication application) {
            this.application = application;
            this.depthOfClasses.defaultReturnValue(-1);
        }

        int getDepth(DexProgramClass programClass) {
            int depth = this.depthOfClasses.getInt(programClass);
            if (depth == -1) {
                int maxDepth;
                DexType superType = programClass.superType;
                if (superType == null) {
                    maxDepth = 0;
                } else {
                    maxDepth = 1;
                    DexProgramClass superClass = this.application.programDefinitionFor(superType);
                    if (superClass != null) {
                        maxDepth = this.getDepth(superClass);
                    }
                }
                for (DexType inf : programClass.interfaces.values) {
                    DexProgramClass infClass = this.application.programDefinitionFor(inf);
                    maxDepth = Math.max(maxDepth, infClass == null ? 1 : this.getDepth(infClass));
                }
                depth = maxDepth + 1;
                this.depthOfClasses.put(programClass, depth);
            }
            return depth;
        }
    }
}

