/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeSuperRange;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InvokeSuper
extends InvokeMethodWithReceiver {
    public final boolean itf;

    public InvokeSuper(DexMethod target, Value result, List<Value> arguments, boolean itf) {
        super(target, result, arguments);
        this.itf = itf;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.SUPER;
    }

    @Override
    protected String getTypeString() {
        return "Super";
    }

    @Override
    public DexEncodedMethod computeSingleTarget(Enqueuer.AppInfoWithLiveness appInfo, TypeEnvironment typeEnvironment, DexType invocationContext) {
        if (invocationContext == null) {
            return null;
        }
        try {
            return appInfo.lookupSuperTarget(this.getInvokedMethod(), invocationContext);
        }
        catch (CompilationError ce) {
            return null;
        }
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke()) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeSuperRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeSuper(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvoke(183, this.getInvokedMethod(), this.itf));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeSuper() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeSuper() {
        return true;
    }

    @Override
    public InvokeSuper asInvokeSuper() {
        return this;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(Enqueuer.AppInfoWithLiveness appInfo, DexType invocationContext) {
        return appInfo.lookupSuperTarget(this.getInvokedMethod(), invocationContext);
    }

    @Override
    public Collection<DexEncodedMethod> lookupTargets(AppInfoWithSubtyping appInfo, DexType invocationContext) {
        DexEncodedMethod target = appInfo.lookupSuperTarget(this.getInvokedMethod(), invocationContext);
        return target == null ? Collections.emptyList() : Collections.singletonList(target);
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.SAMECLASS;
    }
}

