/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class AppInfo {
    public final DexApplication app;
    public final DexItemFactory dexItemFactory;
    private final ConcurrentHashMap<DexType, Map<Descriptor<?, ?>, KeyedDexItem<?>>> definitions = new ConcurrentHashMap();

    public AppInfo(DexApplication application) {
        this.app = application;
        this.dexItemFactory = this.app.dexItemFactory;
    }

    protected AppInfo(AppInfo previous) {
        this.app = previous.app;
        this.dexItemFactory = this.app.dexItemFactory;
        this.definitions.putAll(previous.definitions);
    }

    protected AppInfo(DirectMappedDexApplication application, GraphLense lense) {
        this(application);
    }

    private Map<Descriptor<?, ?>, KeyedDexItem<?>> computeDefinitions(DexType type) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DexClass clazz = this.app.definitionFor(type);
        if (clazz != null) {
            clazz.forEachMethod(method -> builder.put(method.getKey(), method));
            clazz.forEachField(field -> builder.put(field.getKey(), field));
        }
        return builder.build();
    }

    public Iterable<DexProgramClass> classes() {
        return this.app.classes();
    }

    public Iterable<DexProgramClass> classesWithDeterministicOrder() {
        return this.app.classesWithDeterministicOrder();
    }

    public DexClass definitionFor(DexType type) {
        return this.app.definitionFor(type);
    }

    public Origin originFor(DexType type) {
        DexClass definition = this.app.definitionFor(type);
        return definition == null ? Origin.unknown() : definition.origin;
    }

    public DexEncodedMethod definitionFor(DexMethod method) {
        return (DexEncodedMethod)this.getDefinitions(method.getHolder()).get(method);
    }

    public DexEncodedField definitionFor(DexField field) {
        return (DexEncodedField)this.getDefinitions(field.getHolder()).get(field);
    }

    private Map<Descriptor<?, ?>, KeyedDexItem<?>> getDefinitions(DexType type) {
        Map<Descriptor<?, ?>, KeyedDexItem<?>> typeDefinitions = this.definitions.get(type);
        if (typeDefinitions != null) {
            return typeDefinitions;
        }
        typeDefinitions = this.computeDefinitions(type);
        Map<Descriptor<?, ?>, KeyedDexItem<?>> existing = this.definitions.putIfAbsent(type, typeDefinitions);
        return existing != null ? existing : typeDefinitions;
    }

    public DexEncodedMethod lookupStaticTarget(DexMethod method) {
        ResolutionResult resolutionResult = this.resolveMethod(method.holder, method);
        DexEncodedMethod target = resolutionResult.asSingleTarget();
        return target == null || target.isStaticMethod() ? target : null;
    }

    public DexEncodedMethod lookupSuperTarget(DexMethod method, DexType invocationContext) {
        ResolutionResult resolutionResult = this.resolveMethod(method.holder, method);
        if (resolutionResult.asListOfTargets().isEmpty()) {
            return null;
        }
        DexClass contextClass = this.definitionFor(invocationContext);
        if (contextClass == null || contextClass.superType == null) {
            return null;
        }
        resolutionResult = this.resolveMethod(contextClass.superType, method);
        DexEncodedMethod target = resolutionResult.asSingleTarget();
        return target == null || !target.isStaticMethod() ? target : null;
    }

    public DexEncodedMethod lookupDirectTarget(DexMethod method) {
        ResolutionResult resolutionResult = this.resolveMethod(method.holder, method);
        DexEncodedMethod target = resolutionResult.asSingleTarget();
        return target == null || target.isDirectMethod() ? target : null;
    }

    public DexEncodedMethod lookupVirtualTarget(DexType type, DexMethod method) {
        assert (type.isClassType());
        ResolutionResult resolutionResult = this.resolveMethodOnClass(type, method);
        DexEncodedMethod target = resolutionResult.asSingleTarget();
        return target == null || target.isVirtualMethod() ? target : null;
    }

    public ResolutionResult resolveMethod(DexType holder, DexMethod method) {
        DexClass definition = this.definitionFor(holder);
        if (definition == null) {
            return EmptyResult.get();
        }
        return definition.isInterface() ? this.resolveMethodOnInterface(holder, method) : this.resolveMethodOnClass(holder, method);
    }

    public ResolutionResult resolveMethodOnClass(DexType holder, DexMethod method) {
        DexClass clazz = this.definitionFor(holder);
        if (clazz == null || clazz.isInterface()) {
            return EmptyResult.get();
        }
        DexEncodedMethod singleTarget = this.resolveMethodOnClassStep2(clazz, method);
        if (singleTarget != null) {
            return singleTarget;
        }
        return this.resolveMethodStep3(clazz, method);
    }

    private DexEncodedMethod resolveMethodOnClassStep2(DexClass clazz, DexMethod method) {
        DexClass superClass;
        DexMethod signaturePolymorphic;
        DexEncodedMethod result;
        if (clazz.type == this.dexItemFactory.methodHandleType && (result = clazz.lookupMethod(signaturePolymorphic = this.dexItemFactory.createMethod(clazz.type, this.dexItemFactory.createProto(this.dexItemFactory.objectType, this.dexItemFactory.objectArrayType), method.name))) != null && result.accessFlags.isNative() && result.accessFlags.isVarargs()) {
            return result;
        }
        DexEncodedMethod result2 = clazz.lookupMethod(method);
        if (result2 != null) {
            return result2;
        }
        if (clazz.superType != null && (superClass = this.definitionFor(clazz.superType)) != null) {
            return this.resolveMethodOnClassStep2(superClass, method);
        }
        return null;
    }

    private ResolutionResult resolveMethodStep3(DexClass clazz, DexMethod method) {
        MultiResultBuilder builder = new MultiResultBuilder();
        DexEncodedMethod anyTarget = this.resolveMethodStep3Helper(clazz, method, builder);
        ResolutionResult result = builder.build();
        if (result != null) {
            return result;
        }
        return anyTarget == null ? EmptyResult.get() : anyTarget;
    }

    private DexEncodedMethod resolveMethodStep3Helper(DexClass clazz, DexMethod method, MultiResultBuilder builder) {
        DexClass superClass;
        DexEncodedMethod result = null;
        for (DexType iface : clazz.interfaces.values) {
            DexClass definiton = this.definitionFor(iface);
            if (definiton == null) continue;
            DexEncodedMethod localResult = definiton.lookupMethod(method);
            result = this.selectCandidate(result, localResult);
            if (localResult != null && localResult.isNonAbstractVirtualMethod()) {
                builder.add(localResult);
                continue;
            }
            localResult = this.resolveMethodStep3Helper(definiton, method, builder);
            result = this.selectCandidate(result, localResult);
        }
        if (clazz.superType != null && (superClass = this.definitionFor(clazz.superType)) != null) {
            DexEncodedMethod superResult = this.resolveMethodStep3Helper(superClass, method, builder);
            result = this.selectCandidate(result, superResult);
        }
        return result;
    }

    public ResolutionResult resolveMethodOnInterface(DexType holder, DexMethod desc) {
        DexClass definition = this.definitionFor(holder);
        if (definition == null || !definition.isInterface()) {
            return EmptyResult.get();
        }
        DexEncodedMethod result = definition.lookupMethod(desc);
        if (result != null) {
            return result;
        }
        DexClass objectClass = this.definitionFor(this.dexItemFactory.objectType);
        if (objectClass == null) {
            return EmptyResult.get();
        }
        result = objectClass.lookupMethod(desc);
        if (result != null && result.accessFlags.isPublic() && !result.accessFlags.isAbstract()) {
            return result;
        }
        return this.resolveMethodStep3(definition, desc);
    }

    public DexEncodedField lookupInstanceTarget(DexType type, DexField field) {
        assert (type.isClassType());
        DexEncodedField result = this.resolveFieldOn(type, field);
        return result == null || result.accessFlags.isStatic() ? null : result;
    }

    public DexEncodedField lookupStaticTarget(DexType type, DexField field) {
        assert (type.isClassType());
        DexEncodedField result = this.resolveFieldOn(type, field);
        return result == null || !result.accessFlags.isStatic() ? null : result;
    }

    public DexEncodedField resolveFieldOn(DexType type, DexField desc) {
        DexClass holder = this.definitionFor(type);
        if (holder == null) {
            return null;
        }
        DexEncodedField result = holder.lookupField(desc);
        if (result != null) {
            return result;
        }
        for (DexType iface : holder.interfaces.values) {
            result = this.resolveFieldOn(iface, desc);
            if (result == null) continue;
            return result;
        }
        if (holder.superType != null && (result = this.resolveFieldOn(holder.superType, desc)) != null) {
            return result;
        }
        return null;
    }

    public DexEncodedMethod dispatchStaticInvoke(ResolutionResult resolvedMethod) {
        DexEncodedMethod target = resolvedMethod.asSingleTarget();
        if (target != null && target.accessFlags.isStatic()) {
            return target;
        }
        return null;
    }

    public DexEncodedMethod dispatchDirectInvoke(ResolutionResult resolvedMethod) {
        DexEncodedMethod target = resolvedMethod.asSingleTarget();
        if (target != null && !target.accessFlags.isStatic()) {
            return target;
        }
        return null;
    }

    private DexEncodedMethod selectCandidate(DexEncodedMethod previous, DexEncodedMethod current) {
        if (previous != null) {
            assert (!previous.accessFlags.isPrivate());
            assert (!previous.accessFlags.isStatic());
            return previous;
        }
        if (current != null && !current.accessFlags.isPrivate() && !current.accessFlags.isStatic()) {
            return current;
        }
        return null;
    }

    public boolean hasSubtyping() {
        return false;
    }

    public AppInfoWithSubtyping withSubtyping() {
        return null;
    }

    public boolean hasLiveness() {
        return false;
    }

    public Enqueuer.AppInfoWithLiveness withLiveness() {
        return null;
    }

    public void registerNewType(DexType newType, DexType superType) {
    }

    public boolean isInMainDexList(DexType type) {
        return this.app.mainDexList.contains(type);
    }

    public List<DexClass> getSuperTypeClasses(DexType type) {
        DexClass clazz;
        ArrayList<DexClass> result = new ArrayList<DexClass>();
        while ((clazz = this.definitionFor(type)) != null) {
            result.add(clazz);
            type = clazz.superType;
            if (type != null) continue;
        }
        return result;
    }

    private static class EmptyResult
    implements ResolutionResult {
        private static final EmptyResult SINGLETON = new EmptyResult();

        private EmptyResult() {
        }

        private static EmptyResult get() {
            return SINGLETON;
        }

        @Override
        public DexEncodedMethod asResultOfResolve() {
            return null;
        }

        @Override
        public DexEncodedMethod asSingleTarget() {
            return null;
        }

        @Override
        public boolean hasSingleTarget() {
            return false;
        }

        @Override
        public List<DexEncodedMethod> asListOfTargets() {
            return Collections.emptyList();
        }

        @Override
        public void forEachTarget(Consumer<DexEncodedMethod> consumer) {
        }
    }

    private static class MultiResult
    implements ResolutionResult {
        private final ImmutableList<DexEncodedMethod> methods;

        private MultiResult(ImmutableList<DexEncodedMethod> results) {
            assert (results.size() > 1);
            this.methods = results;
        }

        @Override
        public DexEncodedMethod asResultOfResolve() {
            return (DexEncodedMethod)this.methods.get(0);
        }

        @Override
        public DexEncodedMethod asSingleTarget() {
            return null;
        }

        @Override
        public boolean hasSingleTarget() {
            return false;
        }

        @Override
        public List<DexEncodedMethod> asListOfTargets() {
            return this.methods;
        }

        @Override
        public void forEachTarget(Consumer<DexEncodedMethod> consumer) {
            this.methods.forEach(consumer);
        }
    }

    private static class MultiResultBuilder {
        private ImmutableList.Builder<DexEncodedMethod> builder;
        private DexEncodedMethod singleResult;

        private MultiResultBuilder() {
        }

        void add(DexEncodedMethod result) {
            if (this.builder != null) {
                this.builder.add((Object)result);
            } else if (this.singleResult != null) {
                this.builder = ImmutableList.builder();
                this.builder.add(new DexEncodedMethod[]{this.singleResult, result});
                this.singleResult = null;
            } else {
                this.singleResult = result;
            }
        }

        ResolutionResult build() {
            if (this.builder != null) {
                return new MultiResult((ImmutableList)this.builder.build());
            }
            return this.singleResult;
        }
    }

    public static interface ResolutionResult {
        public DexEncodedMethod asResultOfResolve();

        public DexEncodedMethod asSingleTarget();

        public boolean hasSingleTarget();

        public List<DexEncodedMethod> asListOfTargets();

        public void forEachTarget(Consumer<DexEncodedMethod> var1);
    }
}

