/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class DeadCodeRemover {
    public static void removeDeadCode(IRCode code, CodeRewriter codeRewriter, InternalOptions options) {
        DeadCodeRemover.removeUnneededCatchHandlers(code);
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        worklist.addAll(code.blocks);
        BasicBlock block = (BasicBlock)worklist.poll();
        while (block != null) {
            DeadCodeRemover.removeDeadInstructions(worklist, code, block, options);
            DeadCodeRemover.removeDeadPhis(worklist, block, options);
            block = (BasicBlock)worklist.poll();
        }
        assert (code.isConsistentSSA());
        codeRewriter.rewriteMoveResult(code);
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Value value) {
        BasicBlock block = null;
        if (value.isPhi()) {
            block = value.asPhi().getBlock();
        } else if (value.definition.hasBlock()) {
            block = value.definition.getBlock();
        }
        if (block != null) {
            worklist.add(block);
        }
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Instruction instruction) {
        for (Value inValue : instruction.inValues()) {
            DeadCodeRemover.updateWorklist(worklist, inValue);
        }
        for (Value debugValue : instruction.getDebugValues()) {
            DeadCodeRemover.updateWorklist(worklist, debugValue);
        }
    }

    private static void removeDeadPhis(Queue<BasicBlock> worklist, BasicBlock block, InternalOptions options) {
        Iterator<Phi> phiIt = block.getPhis().iterator();
        while (phiIt.hasNext()) {
            Phi phi = phiIt.next();
            if (!phi.isDead(options)) continue;
            phiIt.remove();
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
                DeadCodeRemover.updateWorklist(worklist, operand);
            }
        }
    }

    private static void removeDeadInstructions(Queue<BasicBlock> worklist, IRCode code, BasicBlock block, InternalOptions options) {
        InstructionListIterator iterator = block.listIterator(block.getInstructions().size());
        while (iterator.hasPrevious()) {
            Instruction current = (Instruction)iterator.previous();
            if (current.isInvoke() && current.outValue() != null && !current.outValue().isUsed()) {
                current.setOutValue(null);
            }
            if (!current.canBeDeadCode(code, options)) continue;
            Value outValue = current.outValue();
            assert (outValue != null);
            if (!outValue.isDead(options)) continue;
            DeadCodeRemover.updateWorklist(worklist, current);
            outValue.clearUsers();
            iterator.removeOrReplaceByDebugLocalRead();
        }
    }

    private static void removeUnneededCatchHandlers(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.hasCatchHandlers() || block.canThrow()) continue;
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            for (BasicBlock target : handlers.getUniqueTargets()) {
                target.unlinkCatchHandler();
            }
        }
        code.removeUnreachableBlocks();
    }
}

