/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfArrayLoad
extends CfInstruction {
    private final MemberType type;

    public CfArrayLoad(MemberType type) {
        this.type = type;
    }

    public MemberType getType() {
        return this.type;
    }

    private int getLoadType() {
        switch (this.type) {
            case OBJECT: {
                return 50;
            }
            case BYTE: 
            case BOOLEAN: {
                return 51;
            }
            case CHAR: {
                return 52;
            }
            case SHORT: {
                return 53;
            }
            case INT: {
                return 46;
            }
            case FLOAT: {
                return 48;
            }
            case LONG: {
                return 47;
            }
            case DOUBLE: {
                return 49;
            }
        }
        throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.getLoadType());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        CfState.Slot value;
        CfState.Slot index = state.pop();
        CfState.Slot array = state.pop();
        assert (array.type.isObjectOrNull());
        ValueType memberType = ValueType.fromMemberType(this.type);
        if (array.preciseType != null) {
            value = state.push(array.preciseType.toArrayElementType(builder.getFactory()));
            assert (state.peek().type == memberType);
        } else {
            value = state.push(memberType);
        }
        builder.addArrayGet(this.type, value.register, array.register, index.register);
    }
}

