/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfNumberConversion
extends CfInstruction {
    private final NumericType from;
    private final NumericType to;

    public CfNumberConversion(NumericType from, NumericType to) {
        assert (from != to);
        assert (from != NumericType.BYTE && from != NumericType.SHORT && from != NumericType.CHAR);
        assert (to != NumericType.BYTE && to != NumericType.SHORT && to != NumericType.CHAR || from == NumericType.INT);
        this.from = from;
        this.to = to;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.getAsmOpcode());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public int getAsmOpcode() {
        switch (this.from) {
            case INT: {
                switch (this.to) {
                    case BYTE: {
                        return 145;
                    }
                    case CHAR: {
                        return 146;
                    }
                    case SHORT: {
                        return 147;
                    }
                    case LONG: {
                        return 133;
                    }
                    case FLOAT: {
                        return 134;
                    }
                    case DOUBLE: {
                        return 135;
                    }
                }
                throw new Unreachable("Invalid CfNumberConversion from " + (Object)((Object)this.from) + " to " + (Object)((Object)this.to));
            }
            case LONG: {
                switch (this.to) {
                    case INT: {
                        return 136;
                    }
                    case FLOAT: {
                        return 137;
                    }
                    case DOUBLE: {
                        return 138;
                    }
                }
                throw new Unreachable("Invalid CfNumberConversion from " + (Object)((Object)this.from) + " to " + (Object)((Object)this.to));
            }
            case FLOAT: {
                switch (this.to) {
                    case INT: {
                        return 139;
                    }
                    case LONG: {
                        return 140;
                    }
                    case DOUBLE: {
                        return 141;
                    }
                }
                throw new Unreachable("Invalid CfNumberConversion from " + (Object)((Object)this.from) + " to " + (Object)((Object)this.to));
            }
            case DOUBLE: {
                switch (this.to) {
                    case INT: {
                        return 142;
                    }
                    case LONG: {
                        return 143;
                    }
                    case FLOAT: {
                        return 144;
                    }
                }
                throw new Unreachable("Invalid CfNumberConversion from " + (Object)((Object)this.from) + " to " + (Object)((Object)this.to));
            }
        }
        throw new Unreachable("Invalid CfNumberConversion from " + (Object)((Object)this.from) + " to " + (Object)((Object)this.to));
    }

    public static CfNumberConversion fromAsm(int opcode) {
        switch (opcode) {
            case 133: {
                return new CfNumberConversion(NumericType.INT, NumericType.LONG);
            }
            case 134: {
                return new CfNumberConversion(NumericType.INT, NumericType.FLOAT);
            }
            case 135: {
                return new CfNumberConversion(NumericType.INT, NumericType.DOUBLE);
            }
            case 136: {
                return new CfNumberConversion(NumericType.LONG, NumericType.INT);
            }
            case 137: {
                return new CfNumberConversion(NumericType.LONG, NumericType.FLOAT);
            }
            case 138: {
                return new CfNumberConversion(NumericType.LONG, NumericType.DOUBLE);
            }
            case 139: {
                return new CfNumberConversion(NumericType.FLOAT, NumericType.INT);
            }
            case 140: {
                return new CfNumberConversion(NumericType.FLOAT, NumericType.LONG);
            }
            case 141: {
                return new CfNumberConversion(NumericType.FLOAT, NumericType.DOUBLE);
            }
            case 142: {
                return new CfNumberConversion(NumericType.DOUBLE, NumericType.INT);
            }
            case 143: {
                return new CfNumberConversion(NumericType.DOUBLE, NumericType.LONG);
            }
            case 144: {
                return new CfNumberConversion(NumericType.DOUBLE, NumericType.FLOAT);
            }
            case 145: {
                return new CfNumberConversion(NumericType.INT, NumericType.BYTE);
            }
            case 146: {
                return new CfNumberConversion(NumericType.INT, NumericType.CHAR);
            }
            case 147: {
                return new CfNumberConversion(NumericType.INT, NumericType.SHORT);
            }
        }
        throw new Unreachable("Unexpected CfNumberConversion opcode " + opcode);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int source = state.pop().register;
        builder.addConversion(this.to, this.from, state.push((ValueType)ValueType.fromNumericType((NumericType)this.to)).register, source);
    }
}

