/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.code.Const;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.InvokeStatic;
import com.android.tools.r8.code.NewInstance;
import com.android.tools.r8.code.Throw;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.JumboStringRewriter;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class DexEncodedMethod
extends KeyedDexItem<DexMethod>
implements AppInfo.ResolutionResult {
    public static final DexEncodedMethod[] EMPTY_ARRAY = new DexEncodedMethod[0];
    public static final DexEncodedMethod SENTINEL = new DexEncodedMethod(null, null, null, null, null);
    public final DexMethod method;
    public final MethodAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    public ParameterAnnotationsList parameterAnnotationsList;
    private Code code;
    private CompilationState compilationState = CompilationState.NOT_PROCESSED;
    private OptimizationInfo optimizationInfo = DefaultOptimizationInfo.DEFAULT;

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code) {
        this.method = method;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.parameterAnnotationsList = parameterAnnotationsList;
        this.code = code;
        assert (code == null || !accessFlags.isAbstract());
    }

    public boolean isProcessed() {
        return this.compilationState != CompilationState.NOT_PROCESSED;
    }

    public boolean isInstanceInitializer() {
        return this.accessFlags.isConstructor() && !this.accessFlags.isStatic();
    }

    public boolean isDefaultInitializer() {
        return this.isInstanceInitializer() && this.method.proto.parameters.isEmpty();
    }

    public boolean isClassInitializer() {
        return this.accessFlags.isConstructor() && this.accessFlags.isStatic();
    }

    public boolean isVirtualMethod() {
        return !this.accessFlags.isStatic() && !this.accessFlags.isPrivate() && !this.accessFlags.isConstructor();
    }

    public boolean isNonAbstractVirtualMethod() {
        return this.isVirtualMethod() && !this.accessFlags.isAbstract();
    }

    public boolean isPrivateMethod() {
        return this.accessFlags.isPrivate();
    }

    public boolean isDirectMethod() {
        return (this.accessFlags.isPrivate() || this.accessFlags.isConstructor()) && !this.accessFlags.isStatic();
    }

    public boolean isStaticMethod() {
        return this.accessFlags.isStatic();
    }

    public boolean isSyntheticMethod() {
        return this.accessFlags.isSynthetic();
    }

    public boolean isInliningCandidate(DexEncodedMethod container, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo) {
        return this.isInliningCandidate(container.method.getHolder(), inliningReason, appInfo);
    }

    public boolean isInliningCandidate(DexType containerType, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo) {
        if (this.isClassInitializer()) {
            return false;
        }
        if (inliningReason == Inliner.Reason.FORCE) {
            assert (this.isInliningCandidate(containerType, Inliner.Reason.SIMPLE, appInfo));
            return true;
        }
        switch (this.compilationState) {
            case PROCESSED_INLINING_CANDIDATE_ANY: {
                return true;
            }
            case PROCESSED_INLINING_CANDIDATE_SUBCLASS: {
                return containerType.isSubtypeOf(this.method.getHolder(), appInfo);
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE: {
                return containerType.isSamePackage(this.method.getHolder());
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_CLASS: {
                return containerType == this.method.getHolder();
            }
        }
        return false;
    }

    public boolean markProcessed(Inliner.Constraint state) {
        CompilationState prevCompilationState = this.compilationState;
        switch (state) {
            case ALWAYS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_ANY;
                break;
            }
            case SUBCLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SUBCLASS;
                break;
            }
            case PACKAGE: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE;
                break;
            }
            case SAMECLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_CLASS;
                break;
            }
            case NEVER: {
                this.compilationState = CompilationState.PROCESSED_NOT_INLINING_CANDIDATE;
            }
        }
        return prevCompilationState != this.compilationState;
    }

    public void markNotProcessed() {
        this.compilationState = CompilationState.NOT_PROCESSED;
    }

    public IRCode buildIR(AppInfo appInfo, InternalOptions options, Origin origin) {
        return this.code == null ? null : this.code.buildIR(this, appInfo, options, origin);
    }

    public IRCode buildInliningIRForTesting(InternalOptions options, ValueNumberGenerator valueNumberGenerator) {
        return this.buildInliningIR(null, options, valueNumberGenerator, null, Origin.unknown());
    }

    public IRCode buildInliningIR(AppInfo appInfo, InternalOptions options, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        return this.code.buildInliningIR(this, appInfo, options, valueNumberGenerator, callerPosition, origin);
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public void setCode(IRCode ir, RegisterAllocator registerAllocator, InternalOptions options) {
        DexBuilder builder = new DexBuilder(ir, registerAllocator, options);
        this.code = builder.build(this.method.getArity());
    }

    public String toString() {
        return "Encoded method " + this.method;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.method.collectIndexedItems(indexedItems);
        if (this.code != null) {
            this.code.collectIndexedItems(indexedItems, this.method);
        }
        this.annotations.collectIndexedItems(indexedItems);
        this.parameterAnnotationsList.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        if (this.code != null) {
            this.code.collectMixedSectionItems(mixedItems);
        }
        this.annotations.collectMixedSectionItems(mixedItems);
        this.parameterAnnotationsList.collectMixedSectionItems(mixedItems);
    }

    public Code getCode() {
        return this.code;
    }

    public void setDexCode(DexCode code) {
        this.code = code;
    }

    public void removeCode() {
        this.code = null;
    }

    public boolean hasDebugPositions() {
        assert (this.code != null && this.code.isDexCode());
        return this.code.asDexCode().hasDebugPositions();
    }

    public String qualifiedName() {
        return this.method.qualifiedName();
    }

    public String descriptor() {
        return this.descriptor(NamingLens.getIdentityLens());
    }

    public String descriptor(NamingLens namingLens) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (DexType type : this.method.proto.parameters.values) {
            builder.append(namingLens.lookupDescriptor(type).toString());
        }
        builder.append(")");
        builder.append(namingLens.lookupDescriptor(this.method.proto.returnType).toString());
        return builder.toString();
    }

    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        builder.append(".method ");
        builder.append(this.accessFlags.toSmaliString());
        builder.append(" ");
        builder.append(this.method.name.toSmaliString());
        builder.append(this.method.proto.toSmaliString());
        builder.append("\n");
        if (this.code != null) {
            DexCode dexCode = this.code.asDexCode();
            builder.append("    .registers ");
            builder.append(dexCode.registerSize);
            builder.append("\n\n");
            builder.append(dexCode.toSmaliString(naming));
        }
        builder.append(".end method\n");
        return builder.toString();
    }

    @Override
    public String toSourceString() {
        return this.method.toSourceString();
    }

    public DexEncodedMethod toAbstractMethod() {
        this.accessFlags.setAbstract();
        this.code = null;
        return this;
    }

    private DexCode generateCodeFromTemplate(int numberOfRegisters, int outRegisters, Instruction ... instructions) {
        int offset = 0;
        for (Instruction instruction : instructions) {
            assert (!(instruction instanceof ConstString));
            instruction.setOffset(offset);
            offset += instruction.getSize();
        }
        int requiredArgRegisters = this.accessFlags.isStatic() ? 0 : 1;
        for (DexType type : this.method.proto.parameters.values) {
            requiredArgRegisters += ValueType.fromDexType(type).requiredRegisters();
        }
        return new DexCode(Math.max(numberOfRegisters, requiredArgRegisters), requiredArgRegisters, outRegisters, instructions, new DexCode.Try[0], new DexCode.TryHandler[0], null, null);
    }

    public DexEncodedMethod toEmptyThrowingMethodDex() {
        assert (!this.accessFlags.isAbstract() && !this.accessFlags.isNative());
        Builder builder = DexEncodedMethod.builder(this);
        Instruction[] insn = new Instruction[]{new Const(0, 0), new Throw(0)};
        DexCode emptyThrowingCode = this.generateCodeFromTemplate(1, 0, insn);
        builder.setCode(emptyThrowingCode);
        return builder.build();
    }

    public DexEncodedMethod toEmptyThrowingMethodCf() {
        assert (!this.accessFlags.isAbstract() && !this.accessFlags.isNative());
        Builder builder = DexEncodedMethod.builder(this);
        CfInstruction[] insn = new CfInstruction[]{new CfConstNull(), new CfThrow()};
        CfCode emptyThrowingCode = new CfCode(this.method, 1, this.method.proto.parameters.size() + 1, Arrays.asList(insn), Collections.emptyList(), Collections.emptyList());
        builder.setCode(emptyThrowingCode);
        return builder.build();
    }

    public DexEncodedMethod toMethodThatLogsError(DexItemFactory itemFactory) {
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(this.method);
        DexString message = itemFactory.createString("Shaking error: Missing method in " + this.method.holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("TOIGHTNESS");
        DexType[] args = new DexType[]{itemFactory.stringType, itemFactory.stringType};
        DexProto proto = itemFactory.createProto(itemFactory.intType, args);
        DexMethod logMethod = itemFactory.createMethod(itemFactory.createType("Landroid/util/Log;"), proto, itemFactory.createString("e"));
        DexType exceptionType = itemFactory.createType("Ljava/lang/RuntimeException;");
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        DexCode code = this.isInstanceInitializer() ? this.generateCodeFromTemplate(3, 2, new ConstStringJumbo(0, tag), new ConstStringJumbo(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0), new InvokeDirect(1, this.method, 2, 0, 0, 0, 0)) : this.generateCodeFromTemplate(2, 2, new ConstStringJumbo(0, tag), new ConstStringJumbo(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0));
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        return builder.build();
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method) {
        if (this.method == method) {
            return this;
        }
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(method);
        return builder.build();
    }

    public DexEncodedMethod toRenamedMethod(DexString name, DexItemFactory factory) {
        if (this.method.name == name) {
            return this;
        }
        DexMethod newMethod = factory.createMethod(this.method.holder, this.method.proto, name);
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        return builder.build();
    }

    public DexEncodedMethod toForwardingMethod(DexClass holder, DexItemFactory itemFactory) {
        assert (this.accessFlags.isPublic());
        this.accessFlags.unsetFinal();
        DexMethod newMethod = itemFactory.createMethod(holder.type, this.method.proto, this.method.name);
        Invoke.Type type = this.accessFlags.isStatic() ? Invoke.Type.STATIC : Invoke.Type.SUPER;
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        if (this.accessFlags.isAbstract()) {
            builder.accessFlags.setAbstract();
        } else {
            builder.setCode(new SynthesizedCode(new ForwardMethodSourceCode(this.accessFlags.isStatic() ? null : holder.type, this.method.proto, this.accessFlags.isStatic() ? null : this.method.holder, this.method, type), registry -> {
                if (this.accessFlags.isStatic()) {
                    registry.registerInvokeStatic(this.method);
                } else {
                    registry.registerInvokeSuper(this.method);
                }
            }));
        }
        builder.accessFlags.setSynthetic();
        return builder.build();
    }

    public synchronized void rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, DexApplication application, boolean force) {
        assert (this.code == null || this.code.isDexCode());
        if (this.code == null) {
            return;
        }
        DexCode code = this.code.asDexCode();
        DexString firstJumboString = null;
        if (force) {
            firstJumboString = mapping.getFirstString();
        } else if (code.highestSortingString != null && mapping.getOffsetFor(code.highestSortingString) > 65535) {
            firstJumboString = mapping.getFirstJumboString();
        }
        if (firstJumboString != null) {
            JumboStringRewriter rewriter = new JumboStringRewriter(this, firstJumboString, application.dexItemFactory);
            rewriter.rewrite();
        }
    }

    public String codeToString() {
        return this.code == null ? "<no code>" : this.code.toString(this, null);
    }

    @Override
    public DexMethod getKey() {
        return this.method;
    }

    public boolean hasAnnotation() {
        return !this.annotations.isEmpty() || !this.parameterAnnotationsList.isEmpty();
    }

    public void registerCodeReferences(UseRegistry registry) {
        if (this.code != null) {
            this.code.registerCodeReferences(registry);
        }
    }

    public static int slowCompare(DexEncodedMethod m1, DexEncodedMethod m2) {
        return m1.method.slowCompareTo(m2.method);
    }

    private synchronized OptimizationInfo ensureMutableOI() {
        if (this.optimizationInfo == DefaultOptimizationInfo.DEFAULT) {
            this.optimizationInfo = new OptimizationInfo();
        }
        return this.optimizationInfo;
    }

    public synchronized void markReturnsArgument(int argument) {
        this.ensureMutableOI().markReturnsArgument(argument);
    }

    public synchronized void markNeverReturnsNull() {
        this.ensureMutableOI().markNeverReturnsNull();
    }

    public synchronized void markNeverReturnsNormally() {
        this.ensureMutableOI().markNeverReturnsNormally();
    }

    public synchronized void markReturnsConstant(long value) {
        this.ensureMutableOI().markReturnsConstant(value);
    }

    public synchronized void markReceiverOnlyUsedForReadingFields(Set<DexField> fields) {
        this.ensureMutableOI().markReceiverOnlyUsedForReadingFields(fields);
    }

    public synchronized void markOnlyInitializesFieldsWithNoOtherSideEffects(Map<DexField, Integer> mapping) {
        this.ensureMutableOI().markOnlyInitializesFieldsWithNoOtherSideEffects(mapping);
    }

    public synchronized void markForceInline() {
        this.ensureMutableOI().markForceInline();
    }

    public synchronized void markUseIdentifierNameString() {
        this.ensureMutableOI().markUseIdentifierNameString();
    }

    public synchronized void markCheckNullReceiverBeforeAnySideEffect(boolean mark) {
        this.ensureMutableOI().markCheckNullReceiverBeforeAnySideEffect(mark);
    }

    public synchronized void markTriggerClassInitBeforeAnySideEffect(boolean mark) {
        this.ensureMutableOI().markTriggerClassInitBeforeAnySideEffect(mark);
    }

    public OptimizationInfo getOptimizationInfo() {
        return this.optimizationInfo;
    }

    private static Builder builder(DexEncodedMethod from) {
        return new Builder(from);
    }

    @Override
    public DexEncodedMethod asResultOfResolve() {
        return this;
    }

    @Override
    public DexEncodedMethod asSingleTarget() {
        return this;
    }

    @Override
    public boolean hasSingleTarget() {
        return true;
    }

    @Override
    public List<DexEncodedMethod> asListOfTargets() {
        return Collections.singletonList(this);
    }

    @Override
    public void forEachTarget(Consumer<DexEncodedMethod> consumer) {
        consumer.accept(this);
    }

    private static class Builder {
        private DexMethod method;
        private final MethodAccessFlags accessFlags;
        private final DexAnnotationSet annotations;
        private final ParameterAnnotationsList parameterAnnotations;
        private Code code;
        private CompilationState compilationState = CompilationState.NOT_PROCESSED;
        private OptimizationInfo optimizationInfo = DefaultOptimizationInfo.DEFAULT;

        private Builder(DexEncodedMethod from) {
            this.method = from.method;
            this.accessFlags = from.accessFlags.copy();
            this.annotations = from.annotations;
            this.parameterAnnotations = from.parameterAnnotationsList;
            this.code = from.code;
            this.compilationState = from.compilationState;
            this.optimizationInfo = from.optimizationInfo.copy();
        }

        public void setMethod(DexMethod method) {
            this.method = method;
        }

        public void setCode(Code code) {
            this.code = code;
        }

        public DexEncodedMethod build() {
            assert (this.method != null);
            assert (this.accessFlags != null);
            assert (this.annotations != null);
            assert (this.parameterAnnotations != null);
            DexEncodedMethod result = new DexEncodedMethod(this.method, this.accessFlags, this.annotations, this.parameterAnnotations, this.code);
            result.compilationState = this.compilationState;
            result.optimizationInfo = this.optimizationInfo;
            return result;
        }
    }

    private static class DefaultOptimizationInfo
    extends OptimizationInfo {
        static final OptimizationInfo DEFAULT = new DefaultOptimizationInfo();

        private DefaultOptimizationInfo() {
        }

        @Override
        public OptimizationInfo copy() {
            return this;
        }
    }

    public static class OptimizationInfo {
        private int returnedArgument = -1;
        private boolean neverReturnsNull = false;
        private boolean neverReturnsNormally = false;
        private boolean returnsConstant = false;
        private long returnedConstant = 0L;
        private boolean forceInline = false;
        private boolean useIdentifierNameString = false;
        private boolean checksNullReceiverBeforeAnySideEffect = false;
        private boolean triggersClassInitBeforeAnySideEffect = false;
        private Set<DexField> receiverOnlyUsedForReadingFields = null;
        private Map<DexField, Integer> onlyInitializesFieldsWithNoOtherSideEffects = null;

        private OptimizationInfo() {
        }

        private OptimizationInfo(OptimizationInfo template) {
            this.returnedArgument = template.returnedArgument;
            this.neverReturnsNull = template.neverReturnsNull;
            this.returnsConstant = template.returnsConstant;
            this.returnedConstant = template.returnedConstant;
            this.forceInline = template.forceInline;
            this.useIdentifierNameString = template.useIdentifierNameString;
            this.checksNullReceiverBeforeAnySideEffect = template.checksNullReceiverBeforeAnySideEffect;
        }

        public boolean returnsArgument() {
            return this.returnedArgument != -1;
        }

        public int getReturnedArgument() {
            assert (this.returnsArgument());
            return this.returnedArgument;
        }

        public boolean neverReturnsNull() {
            return this.neverReturnsNull;
        }

        public boolean neverReturnsNormally() {
            return this.neverReturnsNormally;
        }

        public boolean returnsConstant() {
            return this.returnsConstant;
        }

        public boolean isReceiverOnlyUsedForReadingFields(Set<DexField> fields) {
            return this.receiverOnlyUsedForReadingFields != null && fields.containsAll(this.receiverOnlyUsedForReadingFields);
        }

        public Map<DexField, Integer> onlyInitializesFieldsWithNoOtherSideEffects() {
            return this.onlyInitializesFieldsWithNoOtherSideEffects;
        }

        public long getReturnedConstant() {
            assert (this.returnsConstant());
            return this.returnedConstant;
        }

        public boolean forceInline() {
            return this.forceInline;
        }

        public boolean useIdentifierNameString() {
            return this.useIdentifierNameString;
        }

        public boolean checksNullReceiverBeforeAnySideEffect() {
            return this.checksNullReceiverBeforeAnySideEffect;
        }

        public boolean triggersClassInitBeforeAnySideEffect() {
            return this.triggersClassInitBeforeAnySideEffect;
        }

        private void markReturnsArgument(int argument) {
            assert (argument >= 0);
            assert (this.returnedArgument == -1 || this.returnedArgument == argument);
            this.returnedArgument = argument;
        }

        private void markNeverReturnsNull() {
            this.neverReturnsNull = true;
        }

        private void markNeverReturnsNormally() {
            this.neverReturnsNormally = true;
        }

        private void markReturnsConstant(long value) {
            assert (!this.returnsConstant || this.returnedConstant == value);
            this.returnsConstant = true;
            this.returnedConstant = value;
        }

        private void markReceiverOnlyUsedForReadingFields(Set<DexField> fields) {
            this.receiverOnlyUsedForReadingFields = fields;
        }

        private void markOnlyInitializesFieldsWithNoOtherSideEffects(Map<DexField, Integer> mapping) {
            this.onlyInitializesFieldsWithNoOtherSideEffects = mapping == null ? null : (mapping.isEmpty() ? Collections.emptyMap() : ImmutableMap.copyOf(mapping));
        }

        private void markForceInline() {
            this.forceInline = true;
        }

        private void markUseIdentifierNameString() {
            this.useIdentifierNameString = true;
        }

        public OptimizationInfo copy() {
            return new OptimizationInfo(this);
        }

        private void markCheckNullReceiverBeforeAnySideEffect(boolean mark) {
            this.checksNullReceiverBeforeAnySideEffect = mark;
        }

        private void markTriggerClassInitBeforeAnySideEffect(boolean mark) {
            this.triggersClassInitBeforeAnySideEffect = mark;
        }
    }

    public static enum CompilationState {
        NOT_PROCESSED,
        PROCESSED_NOT_INLINING_CANDIDATE,
        PROCESSED_INLINING_CANDIDATE_ANY,
        PROCESSED_INLINING_CANDIDATE_SUBCLASS,
        PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE,
        PROCESSED_INLINING_CANDIDATE_SAME_CLASS;

    }
}

