/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.synthetic.SyntheticSourceCode;
import java.util.ArrayList;

public final class ForwardMethodSourceCode
extends SyntheticSourceCode {
    private final DexType targetReceiver;
    private final DexMethod target;
    private final Invoke.Type invokeType;
    private final boolean castResult;

    public ForwardMethodSourceCode(DexType receiver, DexProto proto, DexType targetReceiver, DexMethod target, Invoke.Type invokeType) {
        this(receiver, proto, targetReceiver, target, invokeType, false);
    }

    public ForwardMethodSourceCode(DexType receiver, DexProto proto, DexType targetReceiver, DexMethod target, Invoke.Type invokeType, boolean castResult) {
        super(receiver, proto);
        assert (targetReceiver == null == (invokeType == Invoke.Type.STATIC));
        this.target = target;
        this.targetReceiver = targetReceiver;
        this.invokeType = invokeType;
        this.castResult = castResult;
        assert (this.checkSignatures());
        switch (invokeType) {
            case DIRECT: 
            case STATIC: 
            case SUPER: 
            case INTERFACE: 
            case VIRTUAL: {
                break;
            }
            default: {
                throw new Unimplemented("Invoke type " + (Object)((Object)invokeType) + " is not yet supported.");
            }
        }
    }

    private boolean checkSignatures() {
        ArrayList<DexType> sourceParams = new ArrayList<DexType>();
        if (this.receiver != null) {
            sourceParams.add(this.receiver);
        }
        sourceParams.addAll(Lists.newArrayList(this.proto.parameters.values));
        ArrayList<DexType> targetParams = new ArrayList<DexType>();
        if (this.targetReceiver != null) {
            targetParams.add(this.targetReceiver);
        }
        targetParams.addAll(Lists.newArrayList(this.target.proto.parameters.values));
        assert (sourceParams.size() == targetParams.size());
        for (int i = 0; i < sourceParams.size(); ++i) {
            DexType source = (DexType)sourceParams.get(i);
            DexType target = (DexType)targetParams.get(i);
            assert (source.isClassType() && target.isClassType() || source == target);
        }
        assert (this.proto.returnType == this.target.proto.returnType || this.castResult);
        return true;
    }

    @Override
    protected void prepareInstructions() {
        ArrayList<ValueType> argValueTypes = new ArrayList<ValueType>();
        ArrayList<Integer> argRegisters = new ArrayList<Integer>();
        if (this.receiver != null) {
            argValueTypes.add(ValueType.OBJECT);
            argRegisters.add(this.getReceiverRegister());
        }
        DexType[] accessorParams = this.proto.parameters.values;
        for (int i = 0; i < accessorParams.length; ++i) {
            argValueTypes.add(ValueType.fromDexType(accessorParams[i]));
            argRegisters.add(this.getParamRegister(i));
        }
        this.add(builder -> builder.addInvoke(this.invokeType, (DexItem)this.target, this.target.proto, argValueTypes, argRegisters));
        if (this.proto.returnType.isVoidType()) {
            this.add(IRBuilder::addReturn);
        } else {
            ValueType valueType = ValueType.fromDexType(this.proto.returnType);
            int tempValue = this.nextRegister(valueType);
            this.add(builder -> builder.addMoveResult(tempValue));
            if (this.proto.returnType != this.target.proto.returnType) {
                this.add(builder -> builder.addCheckCast(tempValue, this.proto.returnType));
            }
            this.add(builder -> builder.addReturn(valueType, tempValue));
        }
    }
}

