/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DataResource;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Keep
public interface DataEntryResource
extends DataResource {
    public InputStream getByteStream() throws ResourceException;

    public static DataEntryResource fromFile(Path dir, Path file) {
        return new LocalDataEntryResource(dir.resolve(file).toFile(), file.toString().replace(File.separatorChar, '/'));
    }

    public static DataEntryResource fromZip(ZipFile zip, ZipEntry entry) {
        return new ZipDataEntryResource(zip, entry);
    }

    public static class LocalDataEntryResource
    implements DataEntryResource {
        private final File file;
        private final String relativePath;

        private LocalDataEntryResource(File file, String relativePath) {
            assert (file != null);
            assert (relativePath != null);
            this.file = file;
            this.relativePath = relativePath;
        }

        @Override
        public Origin getOrigin() {
            return new PathOrigin(this.file.toPath());
        }

        @Override
        public String getName() {
            return this.relativePath;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new ResourceException(this.getOrigin(), (Throwable)e);
            }
        }
    }

    public static class ZipDataEntryResource
    implements DataEntryResource {
        private final ZipFile zip;
        private final ZipEntry entry;

        private ZipDataEntryResource(ZipFile zip, ZipEntry entry) {
            assert (zip != null);
            assert (entry != null);
            this.zip = zip;
            this.entry = entry;
        }

        @Override
        public Origin getOrigin() {
            return new ArchiveEntryOrigin(this.entry.getName(), new PathOrigin(Paths.get(this.zip.getName(), new String[0])));
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new ResourceException(this.getOrigin(), (Throwable)e);
            }
        }
    }
}

