/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DeadCodeRemover {
    public static void removeDeadCode(IRCode code, CodeRewriter codeRewriter, GraphLense graphLense, InternalOptions options) {
        DeadCodeRemover.removeUnneededCatchHandlers(code, graphLense, options);
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        worklist.addAll(code.blocks);
        BasicBlock block = (BasicBlock)worklist.poll();
        while (block != null) {
            DeadCodeRemover.removeDeadInstructions(worklist, code, block, options);
            DeadCodeRemover.removeDeadPhis(worklist, block, options);
            block = (BasicBlock)worklist.poll();
        }
        assert (code.isConsistentSSA());
        codeRewriter.rewriteMoveResult(code);
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Value value) {
        BasicBlock block = null;
        if (value.isPhi()) {
            block = value.asPhi().getBlock();
        } else if (value.definition.hasBlock()) {
            block = value.definition.getBlock();
        }
        if (block != null) {
            worklist.add(block);
        }
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Instruction instruction) {
        for (Value inValue : instruction.inValues()) {
            DeadCodeRemover.updateWorklist(worklist, inValue);
        }
        for (Value debugValue : instruction.getDebugValues()) {
            DeadCodeRemover.updateWorklist(worklist, debugValue);
        }
    }

    private static void removeDeadPhis(Queue<BasicBlock> worklist, BasicBlock block, InternalOptions options) {
        Iterator<Phi> phiIt = block.getPhis().iterator();
        while (phiIt.hasNext()) {
            Phi phi = phiIt.next();
            if (!phi.isDead(options)) continue;
            phiIt.remove();
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
                DeadCodeRemover.updateWorklist(worklist, operand);
            }
        }
    }

    private static void removeDeadInstructions(Queue<BasicBlock> worklist, IRCode code, BasicBlock block, InternalOptions options) {
        InstructionListIterator iterator = block.listIterator(block.getInstructions().size());
        while (iterator.hasPrevious()) {
            Instruction current = (Instruction)iterator.previous();
            if (current.isInvoke() && current.outValue() != null && !current.outValue().isUsed()) {
                current.setOutValue(null);
            }
            if (!current.canBeDeadCode(code, options)) continue;
            Value outValue = current.outValue();
            assert (outValue != null);
            if (!outValue.isDead(options)) continue;
            DeadCodeRemover.updateWorklist(worklist, current);
            outValue.clearUsers();
            iterator.removeOrReplaceByDebugLocalRead();
        }
    }

    private static void removeUnneededCatchHandlers(IRCode code, GraphLense graphLense, InternalOptions options) {
        for (BasicBlock block : code.blocks) {
            if (!block.hasCatchHandlers()) continue;
            if (block.canThrow()) {
                if (!options.enableClassMerging) continue;
                block.renameGuardsInCatchHandlers(graphLense);
                DeadCodeRemover.unlinkDeadCatchHandlers(block, graphLense);
                continue;
            }
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            for (BasicBlock target : handlers.getUniqueTargets()) {
                target.unlinkCatchHandler();
            }
        }
        code.removeUnreachableBlocks();
    }

    private static void unlinkDeadCatchHandlers(BasicBlock block, GraphLense graphLense) {
        assert (block.hasCatchHandlers());
        CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
        List<DexType> guards = catchHandlers.getGuards();
        List<BasicBlock> targets = catchHandlers.getAllTargets();
        HashSet<DexType> previouslySeenGuards = new HashSet<DexType>();
        ArrayList<BasicBlock> deadCatchHandlers = new ArrayList<BasicBlock>();
        for (int i = 0; i < guards.size(); ++i) {
            boolean guardSeenBefore;
            DexType guard = graphLense.lookupType(guards.get(i));
            boolean bl = guardSeenBefore = !previouslySeenGuards.add(guard);
            if (!guardSeenBefore) continue;
            deadCatchHandlers.add(targets.get(i));
        }
        for (BasicBlock deadCatchHandler : deadCatchHandlers) {
            deadCatchHandler.unlinkCatchHandler();
        }
        assert (block.consistentCatchHandlers());
    }
}

