/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.optimize.InvokeSingleTargetExtractor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class VisibilityBridgeRemover {
    private final AppInfoWithSubtyping appInfo;
    private final DexApplication application;
    private final Set<DexEncodedMethod> unneededVisibilityBridges = Sets.newIdentityHashSet();

    public VisibilityBridgeRemover(AppInfoWithSubtyping appInfo, DexApplication application) {
        this.appInfo = appInfo;
        this.application = application;
    }

    private void identifyBridgeMethod(DexEncodedMethod method) {
        MethodAccessFlags accessFlags = method.accessFlags;
        if (accessFlags.isBridge() && !accessFlags.isAbstract()) {
            InvokeSingleTargetExtractor targetExtractor = new InvokeSingleTargetExtractor();
            method.getCode().registerCodeReferences(targetExtractor);
            DexMethod target = targetExtractor.getTarget();
            InvokeSingleTargetExtractor.InvokeKind kind = targetExtractor.getKind();
            if (target != null && target.hasSameProtoAndName(method.method)) {
                DexEncodedMethod targetMethod;
                assert (!accessFlags.isPrivate() && !accessFlags.isConstructor());
                if (kind == InvokeSingleTargetExtractor.InvokeKind.SUPER && (targetMethod = this.appInfo.resolveMethod(target.getHolder(), target).asSingleTarget()) != null && targetMethod.accessFlags.isPublic()) {
                    this.unneededVisibilityBridges.add(method);
                }
            }
        }
    }

    private void removeUnneededVisibilityBridges() {
        Set classes = this.unneededVisibilityBridges.stream().map(method -> method.method.getHolder()).collect(Collectors.toSet());
        for (DexType type : classes) {
            DexClass clazz = this.appInfo.definitionFor(type);
            clazz.setVirtualMethods(this.removeMethods(clazz.virtualMethods(), this.unneededVisibilityBridges));
        }
    }

    private DexEncodedMethod[] removeMethods(DexEncodedMethod[] methods, Set<DexEncodedMethod> removals) {
        assert (methods != null);
        List<DexEncodedMethod> newMethods = Arrays.stream(methods).filter(method -> !removals.contains(method)).collect(Collectors.toList());
        assert (newMethods.size() < methods.length);
        return newMethods.toArray(new DexEncodedMethod[newMethods.size()]);
    }

    public DexApplication run() {
        for (DexClass dexClass : this.appInfo.classes()) {
            dexClass.forEachMethod(this::identifyBridgeMethod);
        }
        if (!this.unneededVisibilityBridges.isEmpty()) {
            this.removeUnneededVisibilityBridges();
        }
        return this.application;
    }
}

