/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.ir.code.Invoke;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class GraphLense {
    public static Builder builder() {
        return new Builder();
    }

    public abstract DexType lookupType(DexType var1);

    public DexMethod lookupMethod(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        return this.lookupMethod(method, null, null);
    }

    public abstract DexMethod lookupMethod(DexMethod var1, DexEncodedMethod var2, Invoke.Type var3);

    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        DexMethod result = this.lookupMethod(method);
        if (result != null) {
            return ImmutableSet.of(result);
        }
        return ImmutableSet.of();
    }

    public abstract DexField lookupField(DexField var1);

    public abstract boolean isContextFreeForMethods();

    public boolean isContextFreeForMethod(DexMethod method) {
        return this.isContextFreeForMethods();
    }

    public static GraphLense getIdentityLense() {
        return new IdentityGraphLense();
    }

    public final boolean isIdentityLense() {
        return this instanceof IdentityGraphLense;
    }

    public static class NestedGraphLense
    extends GraphLense {
        private final GraphLense previousLense;
        protected final DexItemFactory dexItemFactory;
        private final Map<DexType, DexType> typeMap;
        private final Map<DexType, DexType> arrayTypeCache = new IdentityHashMap<DexType, DexType>();
        private final Map<DexMethod, DexMethod> methodMap;
        private final Map<DexField, DexField> fieldMap;

        public NestedGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, GraphLense previousLense, DexItemFactory dexItemFactory) {
            this.typeMap = typeMap;
            this.methodMap = methodMap;
            this.fieldMap = fieldMap;
            this.previousLense = previousLense;
            this.dexItemFactory = dexItemFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DexType lookupType(DexType type) {
            if (type.isArrayType()) {
                NestedGraphLense nestedGraphLense = this;
                synchronized (nestedGraphLense) {
                    DexType result = this.arrayTypeCache.get(type);
                    if (result == null) {
                        DexType newType;
                        DexType baseType = type.toBaseType(this.dexItemFactory);
                        result = baseType == (newType = this.lookupType(baseType)) ? type : type.replaceBaseType(newType, this.dexItemFactory);
                        this.arrayTypeCache.put(type, result);
                    }
                    return result;
                }
            }
            DexType previous = this.previousLense.lookupType(type);
            return this.typeMap.getOrDefault(previous, previous);
        }

        @Override
        public DexMethod lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
            DexMethod previous = this.previousLense.lookupMethod(method, context, type);
            return this.methodMap.getOrDefault(previous, previous);
        }

        @Override
        public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
            HashSet<DexMethod> result = new HashSet<DexMethod>();
            for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
                result.add(this.methodMap.getOrDefault(previous, previous));
            }
            return result;
        }

        @Override
        public DexField lookupField(DexField field) {
            DexField previous = this.previousLense.lookupField(field);
            return this.fieldMap.getOrDefault(previous, previous);
        }

        @Override
        public boolean isContextFreeForMethods() {
            return this.previousLense.isContextFreeForMethods();
        }

        @Override
        public boolean isContextFreeForMethod(DexMethod method) {
            return this.previousLense.isContextFreeForMethod(method);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<DexType, DexType> entry : this.typeMap.entrySet()) {
                builder.append(entry.getKey().toSourceString()).append(" -> ");
                builder.append(entry.getValue().toSourceString()).append(System.lineSeparator());
            }
            for (Map.Entry<IndexedDexItem, IndexedDexItem> entry : this.methodMap.entrySet()) {
                builder.append(((DexMethod)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexMethod)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            for (Map.Entry<IndexedDexItem, IndexedDexItem> entry : this.fieldMap.entrySet()) {
                builder.append(((DexField)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexField)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            builder.append(this.previousLense.toString());
            return builder.toString();
        }
    }

    private static class IdentityGraphLense
    extends GraphLense {
        private IdentityGraphLense() {
        }

        @Override
        public DexType lookupType(DexType type) {
            return type;
        }

        @Override
        public DexMethod lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
            return method;
        }

        @Override
        public DexField lookupField(DexField field) {
            return field;
        }

        @Override
        public boolean isContextFreeForMethods() {
            return true;
        }
    }

    public static class Builder {
        protected final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();
        protected final Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
        protected final Map<DexField, DexField> fieldMap = new IdentityHashMap<DexField, DexField>();

        protected Builder() {
        }

        public void map(DexType from, DexType to) {
            this.typeMap.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
        }

        public void map(DexField from, DexField to) {
            this.fieldMap.put(from, to);
        }

        public GraphLense build(DexItemFactory dexItemFactory) {
            return this.build(dexItemFactory, new IdentityGraphLense());
        }

        public GraphLense build(DexItemFactory dexItemFactory, GraphLense previousLense) {
            if (this.typeMap.isEmpty() && this.methodMap.isEmpty() && this.fieldMap.isEmpty()) {
                return previousLense;
            }
            return new NestedGraphLense(this.typeMap, this.methodMap, this.fieldMap, previousLense, dexItemFactory);
        }
    }
}

