/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class LensCodeRewriter {
    private final GraphLense graphLense;
    private final AppInfoWithSubtyping appInfo;
    private final InternalOptions options;

    public LensCodeRewriter(GraphLense graphLense, AppInfoWithSubtyping appInfo, InternalOptions options) {
        this.graphLense = graphLense;
        this.appInfo = appInfo;
        this.options = options;
    }

    private Value makeOutValue(Instruction insn, IRCode code) {
        if (insn.outValue() == null) {
            return null;
        }
        return code.createValue(insn.outType(), insn.getLocalInfo());
    }

    public void rewrite(IRCode code, DexEncodedMethod method) {
        ListIterator<BasicBlock> blocks = code.blocks.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = (BasicBlock)blocks.next();
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                Instruction newNewArray;
                DexType newType;
                DexField actualField;
                DexField field;
                Instruction current = (Instruction)iterator.next();
                if (current.isInvokeCustom()) {
                    InvokeCustom invokeCustom = current.asInvokeCustom();
                    DexCallSite callSite = invokeCustom.getCallSite();
                    DexType[] newParameters = new DexType[callSite.methodProto.parameters.size()];
                    for (int i = 0; i < callSite.methodProto.parameters.size(); ++i) {
                        newParameters[i] = this.graphLense.lookupType(callSite.methodProto.parameters.values[i]);
                    }
                    DexProto newMethodProto = this.appInfo.dexItemFactory.createProto(this.graphLense.lookupType(callSite.methodProto.returnType), newParameters);
                    DexMethodHandle newBootstrapMethod = this.rewriteDexMethodHandle(method, callSite.bootstrapMethod);
                    List<DexValue> newArgs = callSite.bootstrapArgs.stream().map(arg -> {
                        if (arg instanceof DexValue.DexValueMethodHandle) {
                            return new DexValue.DexValueMethodHandle(this.rewriteDexMethodHandle(method, (DexMethodHandle)((DexValue.DexValueMethodHandle)arg).value));
                        }
                        return arg;
                    }).collect(Collectors.toList());
                    if (newMethodProto.equals(callSite.methodProto) && newBootstrapMethod == callSite.bootstrapMethod && newArgs.equals(callSite.bootstrapArgs)) continue;
                    DexCallSite newCallSite = this.appInfo.dexItemFactory.createCallSite(callSite.methodName, newMethodProto, newBootstrapMethod, newArgs);
                    InvokeCustom newInvokeCustom = new InvokeCustom(newCallSite, invokeCustom.outValue(), invokeCustom.inValues());
                    iterator.replaceCurrentInstruction(newInvokeCustom);
                    continue;
                }
                if (current.isInvokeMethod()) {
                    InvokeMethod invoke = current.asInvokeMethod();
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    DexType invokedHolder = invokedMethod.getHolder();
                    if (!invokedHolder.isClassType()) continue;
                    DexMethod actualTarget = this.graphLense.lookupMethod(invokedMethod, method, invoke.getType());
                    Invoke.Type invokeType = this.getInvokeType(invoke, actualTarget, invokedMethod, method);
                    if (actualTarget == invokedMethod && invoke.getType() == invokeType) continue;
                    Invoke newInvoke = Invoke.create(invokeType, actualTarget, null, invoke.outValue(), invoke.inValues());
                    iterator.replaceCurrentInstruction(newInvoke);
                    if (actualTarget.proto.returnType == invokedMethod.proto.returnType || newInvoke.outValue() == null) continue;
                    Value newValue = code.createValue(newInvoke.outType(), invoke.getLocalInfo());
                    newInvoke.outValue().replaceUsers(newValue);
                    CheckCast cast = new CheckCast(newValue, newInvoke.outValue(), this.graphLense.lookupType(invokedMethod.proto.returnType));
                    cast.setPosition(current.getPosition());
                    iterator.add(cast);
                    if (!newInvoke.getBlock().hasCatchHandlers()) continue;
                    iterator.previous();
                    iterator.split(code, 1, blocks);
                    continue;
                }
                if (current.isInstanceGet()) {
                    InstanceGet instanceGet = current.asInstanceGet();
                    field = instanceGet.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    InstanceGet newInstanceGet = new InstanceGet(instanceGet.getType(), instanceGet.dest(), instanceGet.object(), actualField);
                    iterator.replaceCurrentInstruction(newInstanceGet);
                    continue;
                }
                if (current.isInstancePut()) {
                    InstancePut instancePut = current.asInstancePut();
                    field = instancePut.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    InstancePut newInstancePut = new InstancePut(instancePut.getType(), actualField, instancePut.object(), instancePut.value());
                    iterator.replaceCurrentInstruction(newInstancePut);
                    continue;
                }
                if (current.isStaticGet()) {
                    StaticGet staticGet = current.asStaticGet();
                    field = staticGet.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    StaticGet newStaticGet = new StaticGet(staticGet.getType(), staticGet.dest(), actualField);
                    iterator.replaceCurrentInstruction(newStaticGet);
                    continue;
                }
                if (current.isStaticPut()) {
                    StaticPut staticPut = current.asStaticPut();
                    field = staticPut.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    StaticPut newStaticPut = new StaticPut(staticPut.getType(), staticPut.inValue(), actualField);
                    iterator.replaceCurrentInstruction(newStaticPut);
                    continue;
                }
                if (current.isCheckCast()) {
                    CheckCast checkCast = current.asCheckCast();
                    newType = this.graphLense.lookupType(checkCast.getType());
                    if (newType == checkCast.getType()) continue;
                    CheckCast newCheckCast = new CheckCast(this.makeOutValue(checkCast, code), checkCast.object(), newType);
                    iterator.replaceCurrentInstruction(newCheckCast);
                    continue;
                }
                if (current.isConstClass()) {
                    ConstClass constClass = current.asConstClass();
                    newType = this.graphLense.lookupType(constClass.getValue());
                    if (newType == constClass.getValue()) continue;
                    ConstClass newConstClass = new ConstClass(this.makeOutValue(constClass, code), newType);
                    iterator.replaceCurrentInstruction(newConstClass);
                    continue;
                }
                if (current.isInstanceOf()) {
                    InstanceOf instanceOf = current.asInstanceOf();
                    newType = this.graphLense.lookupType(instanceOf.type());
                    if (newType == instanceOf.type()) continue;
                    InstanceOf newInstanceOf = new InstanceOf(this.makeOutValue(instanceOf, code), instanceOf.value(), newType);
                    iterator.replaceCurrentInstruction(newInstanceOf);
                    continue;
                }
                if (current.isInvokeNewArray()) {
                    InvokeNewArray newArray = current.asInvokeNewArray();
                    newType = this.graphLense.lookupType(newArray.getArrayType());
                    if (newType == newArray.getArrayType()) continue;
                    newNewArray = new InvokeNewArray(newType, this.makeOutValue(newArray, code), newArray.inValues());
                    iterator.replaceCurrentInstruction(newNewArray);
                    continue;
                }
                if (current.isNewArrayEmpty()) {
                    NewArrayEmpty newArrayEmpty = current.asNewArrayEmpty();
                    newType = this.graphLense.lookupType(newArrayEmpty.type);
                    if (newType == newArrayEmpty.type) continue;
                    newNewArray = new NewArrayEmpty(this.makeOutValue(newArrayEmpty, code), newArrayEmpty.size(), newType);
                    iterator.replaceCurrentInstruction(newNewArray);
                    continue;
                }
                if (!current.isNewInstance()) continue;
                NewInstance newInstance = current.asNewInstance();
                DexType newClazz = this.graphLense.lookupType(newInstance.clazz);
                if (newClazz == newInstance.clazz) continue;
                NewInstance newNewInstance = new NewInstance(newClazz, this.makeOutValue(newInstance, code));
                iterator.replaceCurrentInstruction(newNewInstance);
            }
        }
        assert (code.isConsistentSSA());
    }

    private DexMethodHandle rewriteDexMethodHandle(DexEncodedMethod method, DexMethodHandle methodHandle) {
        if (methodHandle.isMethodHandle()) {
            DexMethod invokedMethod = methodHandle.asMethod();
            DexMethod actualTarget = this.graphLense.lookupMethod(invokedMethod, method, methodHandle.type.toInvokeType());
            if (actualTarget != invokedMethod) {
                DexClass clazz = this.appInfo.definitionFor(actualTarget.holder);
                DexMethodHandle.MethodHandleType newType = methodHandle.type;
                if (clazz != null && (newType.isInvokeInterface() || newType.isInvokeInstance())) {
                    newType = clazz.accessFlags.isInterface() ? DexMethodHandle.MethodHandleType.INVOKE_INTERFACE : DexMethodHandle.MethodHandleType.INVOKE_INSTANCE;
                }
                return new DexMethodHandle(newType, actualTarget);
            }
        } else {
            DexField field = methodHandle.asField();
            DexField actualField = this.graphLense.lookupField(field);
            if (actualField != field) {
                return new DexMethodHandle(methodHandle.type, actualField);
            }
        }
        return methodHandle;
    }

    private Invoke.Type getInvokeType(InvokeMethod invoke, DexMethod actualTarget, DexMethod originalTarget, DexEncodedMethod invocationContext) {
        if (invoke.isInvokeVirtual() || invoke.isInvokeInterface()) {
            DexClass newTargetClass = this.appInfo.definitionFor(actualTarget.holder);
            if (newTargetClass == null) {
                return invoke.getType();
            }
            DexClass originalTargetClass = this.appInfo.definitionFor(originalTarget.holder);
            if (originalTargetClass != null && originalTargetClass.isInterface() ^ invoke.getType() == Invoke.Type.INTERFACE) {
                return newTargetClass.accessFlags.isInterface() ? Invoke.Type.VIRTUAL : Invoke.Type.INTERFACE;
            }
            return newTargetClass.accessFlags.isInterface() ? Invoke.Type.INTERFACE : Invoke.Type.VIRTUAL;
        }
        if (this.options.enableClassMerging && invoke.isInvokeSuper() && actualTarget.getHolder() == invocationContext.method.getHolder()) {
            DexClass targetClass = this.appInfo.definitionFor(actualTarget.holder);
            if (targetClass == null) {
                return invoke.getType();
            }
            DexEncodedMethod method = targetClass.lookupDirectMethod(actualTarget);
            if (method != null) {
                return Invoke.Type.DIRECT;
            }
        }
        return invoke.getType();
    }
}

