/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.List;
import java.util.Set;

public final class IdentifierNameStringUtils {
    public static boolean isReflectionMethod(DexItemFactory dexItemFactory, DexMethod method) {
        int arity = method.getArity();
        if (method.holder.descriptor == dexItemFactory.classDescriptor) {
            if (arity != 1 && arity != 2) {
                return false;
            }
            if (arity == 1 ? method.proto.returnType.descriptor != dexItemFactory.classDescriptor && method.proto.returnType.descriptor != dexItemFactory.fieldDescriptor : method.proto.returnType.descriptor != dexItemFactory.methodDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != dexItemFactory.stringDescriptor) {
                return false;
            }
            if (arity == 2 && method.proto.parameters.values[1].descriptor != dexItemFactory.classArrayDescriptor) {
                return false;
            }
        } else if (method.holder.descriptor == dexItemFactory.intFieldUpdaterDescriptor || method.holder.descriptor == dexItemFactory.longFieldUpdaterDescriptor) {
            if (arity != 2) {
                return false;
            }
            if (method.proto.returnType.descriptor != method.holder.descriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[1].descriptor != dexItemFactory.stringDescriptor) {
                return false;
            }
        } else if (method.holder.descriptor == dexItemFactory.referenceFieldUpdaterDescriptor) {
            if (arity != 3) {
                return false;
            }
            if (method.proto.returnType.descriptor != method.holder.descriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[1].descriptor != dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[2].descriptor != dexItemFactory.stringDescriptor) {
                return false;
            }
        } else {
            if (arity != 2 && arity != 3) {
                return false;
            }
            if (arity == 2 ? method.proto.returnType.descriptor != dexItemFactory.fieldDescriptor : method.proto.returnType.descriptor != dexItemFactory.methodDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[1].descriptor != dexItemFactory.stringDescriptor) {
                return false;
            }
            if (arity == 3 && method.proto.parameters.values[2].descriptor != dexItemFactory.classArrayDescriptor) {
                return false;
            }
        }
        return true;
    }

    public static DexItemBasedString identifyIdentiferNameString(AppInfo appInfo, InvokeMethod invoke) {
        List<Value> ins = invoke.arguments();
        if (ins.size() == 1) {
            Value in = ins.get(0);
            if (in.isConstString()) {
                ConstString constString = in.getConstInstruction().asConstString();
                return IdentifierNameStringUtils.inferMemberOrTypeFromNameString(appInfo, constString.getValue());
            }
            return null;
        }
        boolean isReferenceFieldUpdater = invoke.getReturnType().descriptor == appInfo.dexItemFactory.referenceFieldUpdaterDescriptor;
        int positionOfIdentifier = isReferenceFieldUpdater ? 2 : 1;
        Value in = ins.get(positionOfIdentifier);
        if (!in.isConstString()) {
            return null;
        }
        Value classValue = ins.get(0);
        if (!classValue.isConstClass()) {
            return null;
        }
        DexType holderType = classValue.getConstInstruction().asConstClass().getValue();
        DexClass holder = appInfo.definitionFor(holderType);
        if (holder == null) {
            return null;
        }
        DexString dexString = in.getConstInstruction().asConstString().getValue();
        DexItemBasedString itemBasedString = null;
        int numOfParams = ins.size();
        if (isReferenceFieldUpdater) {
            Value fieldTypeValue = ins.get(1);
            if (!fieldTypeValue.isConstClass()) {
                return null;
            }
            DexType fieldType = fieldTypeValue.getConstInstruction().asConstClass().getValue();
            itemBasedString = IdentifierNameStringUtils.inferFieldInHolder(appInfo, holder, dexString.toString(), fieldType);
        } else if (numOfParams == 2) {
            itemBasedString = IdentifierNameStringUtils.inferFieldInHolder(appInfo, holder, dexString.toString(), null);
        } else {
            assert (numOfParams == 3);
            DexTypeList arguments = IdentifierNameStringUtils.retrieveDexTypeListFromClassList(invoke, ins.get(2));
            itemBasedString = IdentifierNameStringUtils.inferMethodInHolder(appInfo, holder, dexString.toString(), arguments);
        }
        return itemBasedString;
    }

    static DexItemBasedString inferMemberOrTypeFromNameString(AppInfo appInfo, DexString dexString) {
        String maybeDescriptor;
        DexItemBasedString itemBasedString = IdentifierNameStringUtils.inferMemberFromNameString(appInfo, dexString);
        if (itemBasedString == null && (maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(dexString.toString())) != null) {
            DexType type = appInfo.dexItemFactory.createType(maybeDescriptor);
            itemBasedString = appInfo.dexItemFactory.createItemBasedString(type);
        }
        return itemBasedString;
    }

    private static DexItemBasedString inferMemberFromNameString(AppInfo appInfo, DexString dexString) {
        String identifier = dexString.toString();
        String typeIdentifier = null;
        String memberIdentifier = null;
        String[] items = identifier.split("#");
        if (items.length > 2) {
            return null;
        }
        if (items.length == 2) {
            typeIdentifier = items[0];
            memberIdentifier = items[1];
        } else {
            int lastDot = identifier.lastIndexOf(".");
            if (0 < lastDot && lastDot < identifier.length() - 1) {
                typeIdentifier = identifier.substring(0, lastDot);
                memberIdentifier = identifier.substring(lastDot + 1);
            }
        }
        if (typeIdentifier == null) {
            return null;
        }
        String maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(typeIdentifier);
        if (maybeDescriptor == null) {
            return null;
        }
        DexType type = appInfo.dexItemFactory.createType(maybeDescriptor);
        DexClass holder = appInfo.definitionFor(type);
        if (holder == null) {
            return null;
        }
        DexItemBasedString itemBasedString = IdentifierNameStringUtils.inferFieldInHolder(appInfo, holder, memberIdentifier, null);
        if (itemBasedString == null) {
            itemBasedString = IdentifierNameStringUtils.inferMethodInHolder(appInfo, holder, memberIdentifier, null);
        }
        return itemBasedString;
    }

    private static DexItemBasedString inferFieldInHolder(AppInfo appInfo, DexClass holder, String name, DexType fieldType) {
        DexItemBasedString itemBasedString = null;
        for (DexEncodedField encodedField : holder.staticFields()) {
            if (!encodedField.field.name.toString().equals(name) || fieldType != null && encodedField.field.type != fieldType) continue;
            itemBasedString = appInfo.dexItemFactory.createItemBasedString(encodedField.field);
            break;
        }
        if (itemBasedString == null) {
            for (DexEncodedField encodedField : holder.instanceFields()) {
                if (!encodedField.field.name.toString().equals(name) || fieldType != null && encodedField.field.type != fieldType) continue;
                itemBasedString = appInfo.dexItemFactory.createItemBasedString(encodedField.field);
                break;
            }
        }
        return itemBasedString;
    }

    private static DexItemBasedString inferMethodInHolder(AppInfo appInfo, DexClass holder, String name, DexTypeList arguments) {
        DexItemBasedString itemBasedString = null;
        for (DexEncodedMethod encodedMethod : holder.directMethods()) {
            if (!encodedMethod.method.name.toString().equals(name) || arguments != null && !encodedMethod.method.proto.parameters.equals(arguments)) continue;
            itemBasedString = appInfo.dexItemFactory.createItemBasedString(encodedMethod.method);
            break;
        }
        if (itemBasedString == null) {
            for (DexEncodedMethod encodedMethod : holder.virtualMethods()) {
                if (!encodedMethod.method.name.toString().equals(name) || arguments != null && !encodedMethod.method.proto.parameters.equals(arguments)) continue;
                itemBasedString = appInfo.dexItemFactory.createItemBasedString(encodedMethod.method);
                break;
            }
        }
        return itemBasedString;
    }

    private static DexTypeList retrieveDexTypeListFromClassList(InvokeMethod invoke, Value classListValue) {
        Instruction instr2;
        if (!classListValue.definition.isInvokeNewArray() && !classListValue.definition.isNewArrayEmpty()) {
            return null;
        }
        BasicBlock block = classListValue.definition.getBlock();
        InstructionIterator iterator2 = block.iterator();
        iterator2.nextUntil(instr -> instr == classListValue.definition);
        Set<Instruction> users = classListValue.definition.outValue().uniqueUsers();
        int maxIndex = -1;
        Int2ObjectArrayMap<DexType> typeMap = new Int2ObjectArrayMap<DexType>();
        while (iterator2.hasNext() && (instr2 = (Instruction)iterator2.next()) != invoke) {
            if (!users.contains(instr2)) continue;
            if (!instr2.isArrayPut()) {
                return null;
            }
            ArrayPut arrayPut = instr2.asArrayPut();
            assert (arrayPut.array() == classListValue);
            if (!arrayPut.value().isConstClass() || !arrayPut.index().isConstNumber()) {
                return null;
            }
            int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
            if (index < 0 || typeMap.containsKey((Object)index)) {
                return null;
            }
            maxIndex = maxIndex < index ? index : maxIndex;
            DexType type = arrayPut.value().getConstInstruction().asConstClass().getValue();
            typeMap.put(Integer.valueOf(index), type);
        }
        if (maxIndex < 0) {
            return DexTypeList.empty();
        }
        for (int i = 0; i <= maxIndex; ++i) {
            if (typeMap.containsKey((Object)i)) continue;
            return null;
        }
        DexType[] types = new DexType[maxIndex + 1];
        for (int i = 0; i <= maxIndex; ++i) {
            types[i] = (DexType)typeMap.get((Object)i);
        }
        return new DexTypeList(types);
    }
}

